/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.gardencore.api.block.IChain;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import com.jaquadro.minecraft.gardencore.util.RenderHelper;
import com.jaquadro.minecraft.gardencore.util.RenderHelperState;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileEntityCandelabra;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCandelabra
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconArm;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconArmExt;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconPlate;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconCandle;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBase;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconHang;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconCandleSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconCandleTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconHolderSide;

    public BlockCandelabra(String blockName) {
        super(Material.field_151573_f);
        this.func_149663_c(blockName);
        this.func_149675_a(true);
        this.func_149711_c(2.5f);
        this.func_149752_b(5.0f);
        this.func_149715_a(0.0f);
        this.func_149658_d("GardenStuff:candelabra");
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.sconceRenderID;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float hwidth;
        TileEntityCandelabra tile = this.getTileEntity(world, x, y, z);
        float yMin = 0.0f;
        float yMax = 1.0f;
        float xMin = 0.0f;
        float xMax = 1.0f;
        float zMin = 0.0f;
        float zMax = 1.0f;
        float depth = tile.getLevel() == 2 ? 0.5f : 0.390625f;
        float f = hwidth = tile.getLevel() == 0 ? 0.125f : 0.390625f;
        if (tile.isSconce()) {
            yMin = 0.0625f;
            yMax = 0.875f;
            switch (tile.getDirection()) {
                case 2: {
                    zMax = depth;
                    xMin = 0.5f - hwidth;
                    xMax = 0.5f + hwidth;
                    break;
                }
                case 3: {
                    zMin = 1.0f - depth;
                    xMin = 0.5f - hwidth;
                    xMax = 0.5f + hwidth;
                    break;
                }
                case 4: {
                    xMax = depth;
                    zMin = 0.5f - hwidth;
                    zMax = 0.5f + hwidth;
                    break;
                }
                case 5: {
                    xMin = 1.0f - depth;
                    zMin = 0.5f - hwidth;
                    zMax = 0.5f + hwidth;
                }
            }
        } else {
            yMax = 0.9375f;
            zMin = 0.359375f;
            xMin = 0.359375f;
            zMax = 0.640625f;
            xMax = 0.640625f;
            switch (tile.getLevel()) {
                case 0: {
                    yMax = 0.9375f;
                    break;
                }
                case 1: {
                    if (tile.getDirection() == 2 || tile.getDirection() == 3) {
                        xMin = 0.03125f;
                        xMax = 0.96875f;
                        break;
                    }
                    zMin = 0.03125f;
                    zMax = 0.96875f;
                    break;
                }
                case 2: {
                    zMin = 0.03125f;
                    xMin = 0.03125f;
                    zMax = 0.96875f;
                    xMax = 0.96875f;
                }
            }
        }
        this.func_149676_a(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        this.func_149676_a((float)this.field_149759_B, (float)this.field_149760_C, (float)this.field_149754_D, (float)this.field_149755_E, (float)this.field_149756_F - 0.09375f, (float)this.field_149757_G);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntityCandelabra te = (TileEntityCandelabra)world.func_147438_o(x, y, z);
        if (te == null || te.isDirectionInitialized()) {
            return;
        }
        int quadrant = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (quadrant) {
            case 0: {
                te.setDirection(3);
                break;
            }
            case 1: {
                te.setDirection(4);
                break;
            }
            case 2: {
                te.setDirection(2);
                break;
            }
            case 3: {
                te.setDirection(5);
            }
        }
        if (world.field_72995_K) {
            te.func_145843_s();
            world.func_147471_g(x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntityCandelabra tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return;
        }
        double[] c = new double[3];
        int level = tile.getLevel();
        int dir = tile.getDirection();
        float flameDepth = 0.96875f;
        if (tile.isSconce()) {
            if (level == 0) {
                RenderHelper.instance.state.transformCoord(0.5, flameDepth, 0.25, c, RenderHelperState.ROTATION_BY_FACE_FACE[2][dir]);
                this.renderParticleAt(world, (double)x + c[0], (double)y + c[1], (double)z + c[2]);
            }
            if (level == 1 || level == 2) {
                RenderHelper.instance.state.transformCoord(0.25, flameDepth, 0.25, c, RenderHelperState.ROTATION_BY_FACE_FACE[2][dir]);
                this.renderParticleAt(world, (double)x + c[0], (double)y + c[1], (double)z + c[2]);
                RenderHelper.instance.state.transformCoord(0.75, flameDepth, 0.25, c, RenderHelperState.ROTATION_BY_FACE_FACE[2][dir]);
                this.renderParticleAt(world, (double)x + c[0], (double)y + c[1], (double)z + c[2]);
            }
            if (level == 2) {
                RenderHelper.instance.state.transformCoord(0.5, flameDepth, 0.375, c, RenderHelperState.ROTATION_BY_FACE_FACE[2][dir]);
                this.renderParticleAt(world, (double)x + c[0], (double)y + c[1], (double)z + c[2]);
            }
        } else {
            boolean hanging;
            Block blockUpper = world.func_147439_a(x, y + 1, z);
            boolean bl = hanging = level > 0 && (blockUpper instanceof IChain || blockUpper.isSideSolid((IBlockAccess)world, x, y + 1, z, ForgeDirection.DOWN));
            if (level >= 0 && !hanging) {
                RenderHelper.instance.state.transformCoord(0.5, flameDepth + 0.0625f, 0.5, c, RenderHelperState.ROTATION_BY_FACE_FACE[2][dir]);
                this.renderParticleAt(world, (double)x + c[0], (double)y + c[1], (double)z + c[2]);
            }
            if (level >= 1) {
                RenderHelper.instance.state.transformCoord(0.15625, flameDepth, 0.5, c, RenderHelperState.ROTATION_BY_FACE_FACE[2][dir]);
                this.renderParticleAt(world, (double)x + c[0], (double)y + c[1], (double)z + c[2]);
                RenderHelper.instance.state.transformCoord(0.84375, flameDepth, 0.5, c, RenderHelperState.ROTATION_BY_FACE_FACE[2][dir]);
                this.renderParticleAt(world, (double)x + c[0], (double)y + c[1], (double)z + c[2]);
            }
            if (level >= 2) {
                RenderHelper.instance.state.transformCoord(0.5, flameDepth, 0.15625, c, RenderHelperState.ROTATION_BY_FACE_FACE[2][dir]);
                this.renderParticleAt(world, (double)x + c[0], (double)y + c[1], (double)z + c[2]);
                RenderHelper.instance.state.transformCoord(0.5, flameDepth, 0.84375, c, RenderHelperState.ROTATION_BY_FACE_FACE[2][dir]);
                this.renderParticleAt(world, (double)x + c[0], (double)y + c[1], (double)z + c[2]);
            }
        }
    }

    private void renderParticleAt(World world, double x, double y, double z) {
        world.func_72869_a("flame", x, y, z, 0.0, 0.0, 0.0);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntityCandelabra tile = this.getTileEntity(world, x, y, z);
        if (tile == null) {
            return 0;
        }
        switch (tile.getLevel()) {
            case 0: {
                return 13;
            }
            case 1: {
                return 14;
            }
            case 2: {
                return 15;
            }
        }
        return 0;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List blockList) {
        for (int i = 0; i < 3; ++i) {
            blockList.add(new ItemStack(item, 1, i));
        }
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityCandelabra();
    }

    public TileEntityCandelabra getTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof TileEntityCandelabra ? (TileEntityCandelabra)te : null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconArm() {
        return this.iconArm;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconArmExt() {
        return this.iconArmExt;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconCandle() {
        return this.iconCandle;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconBase() {
        return this.iconBase;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconHang() {
        return this.iconHang;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconCandleSide() {
        return this.iconCandleSide;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconCandleTop() {
        return this.iconCandleTop;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconHolderSide() {
        return this.iconHolderSide;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.iconCandle = register.func_94245_a(this.func_149641_N() + "_candle");
        this.iconArm = register.func_94245_a(this.func_149641_N() + "_arm");
        this.iconArmExt = register.func_94245_a(this.func_149641_N() + "_arm_ext");
        this.iconBase = register.func_94245_a(this.func_149641_N() + "_base");
        this.iconHang = register.func_94245_a(this.func_149641_N() + "_hang");
        this.iconCandleSide = register.func_94245_a(this.func_149641_N() + "_candle_side");
        this.iconCandleTop = register.func_94245_a(this.func_149641_N() + "_candle_top");
        this.iconHolderSide = register.func_94245_a(this.func_149641_N() + "_holder_side");
    }
}

