/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block.support;

import com.jaquadro.minecraft.gardencore.api.block.IGardenBlock;
import com.jaquadro.minecraft.gardencore.api.block.garden.IConnectionProfile;
import com.jaquadro.minecraft.gardencore.block.support.BasicSlotProfile;
import com.jaquadro.minecraft.gardencore.block.support.Slot14Profile;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class Slot14ProfileBounded
extends Slot14Profile {
    private IGardenBlock garden;
    private AxisAlignedBB[] bound = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0)};
    private AxisAlignedBB[] boundS = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)0.6875), AxisAlignedBB.func_72330_a((double)0.0, (double)0.0625, (double)0.0, (double)1.0, (double)0.125, (double)0.75), AxisAlignedBB.func_72330_a((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.8125)};
    private AxisAlignedBB[] boundN = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.3125, (double)1.0, (double)0.0625, (double)1.0), AxisAlignedBB.func_72330_a((double)0.0, (double)0.0625, (double)0.25, (double)1.0, (double)0.125, (double)1.0), AxisAlignedBB.func_72330_a((double)0.0, (double)0.125, (double)0.1875, (double)1.0, (double)1.0, (double)1.0)};
    private AxisAlignedBB[] boundE = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.6875, (double)0.0625, (double)1.0), AxisAlignedBB.func_72330_a((double)0.0, (double)0.0625, (double)0.0, (double)0.75, (double)0.125, (double)1.0), AxisAlignedBB.func_72330_a((double)0.0, (double)0.125, (double)0.0, (double)0.8125, (double)1.0, (double)1.0)};
    private AxisAlignedBB[] boundW = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.3125, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0), AxisAlignedBB.func_72330_a((double)0.25, (double)0.0625, (double)0.0, (double)1.0, (double)0.125, (double)1.0), AxisAlignedBB.func_72330_a((double)0.1875, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)1.0)};
    private AxisAlignedBB[] boundSW = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.3125, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)0.6875), AxisAlignedBB.func_72330_a((double)0.25, (double)0.0625, (double)0.0, (double)1.0, (double)0.125, (double)0.75), AxisAlignedBB.func_72330_a((double)0.1875, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.8125)};
    private AxisAlignedBB[] boundSE = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.6875, (double)0.0625, (double)0.6875), AxisAlignedBB.func_72330_a((double)0.0, (double)0.0625, (double)0.0, (double)0.75, (double)0.125, (double)0.75), AxisAlignedBB.func_72330_a((double)0.0, (double)0.125, (double)0.0, (double)0.8125, (double)1.0, (double)0.8125)};
    private AxisAlignedBB[] boundNW = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.3125, (double)0.0, (double)0.3125, (double)1.0, (double)0.0625, (double)1.0), AxisAlignedBB.func_72330_a((double)0.25, (double)0.0625, (double)0.25, (double)1.0, (double)0.125, (double)1.0), AxisAlignedBB.func_72330_a((double)0.1875, (double)0.125, (double)0.1875, (double)1.0, (double)1.0, (double)1.0)};
    private AxisAlignedBB[] boundNE = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.3125, (double)0.8125, (double)0.0625, (double)1.0), AxisAlignedBB.func_72330_a((double)0.0, (double)0.0625, (double)0.25, (double)0.75, (double)0.125, (double)1.0), AxisAlignedBB.func_72330_a((double)0.0, (double)0.125, (double)0.1875, (double)0.8125, (double)1.0, (double)1.0)};

    public Slot14ProfileBounded(IGardenBlock garden, BasicSlotProfile.Slot[] slots) {
        super(slots);
        this.garden = garden;
    }

    @Override
    public AxisAlignedBB[] getClippingBounds(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        IConnectionProfile connection = this.garden.getConnectionProfile();
        AxisAlignedBB[] activeBound = this.bound;
        switch (slot) {
            case 2: {
                activeBound = this.boundNW;
                if (connection.isAttachedNeighbor(blockAccess, x, y, z, x - 1, y, z - 1)) {
                    boolean connectedN = connection.isAttachedNeighbor(blockAccess, x, y, z, x, y, z - 1);
                    boolean connectedW = connection.isAttachedNeighbor(blockAccess, x, y, z, x - 1, y, z);
                    if (connectedN && connectedW) {
                        activeBound = this.bound;
                        break;
                    }
                    if (connectedN) {
                        activeBound = this.boundN;
                        break;
                    }
                    if (!connectedW) break;
                    activeBound = this.boundW;
                    break;
                }
                if (connection.isAttachedNeighbor(blockAccess, x, y, z, x, y, z - 1)) {
                    activeBound = this.boundW;
                    break;
                }
                if (!connection.isAttachedNeighbor(blockAccess, x, y, z, x - 1, y, z)) break;
                activeBound = this.boundN;
                break;
            }
            case 3: {
                activeBound = this.boundNE;
                if (connection.isAttachedNeighbor(blockAccess, x, y, z, x + 1, y, z - 1)) {
                    boolean connectedN = connection.isAttachedNeighbor(blockAccess, x, y, z, x, y, z - 1);
                    boolean connectedE = connection.isAttachedNeighbor(blockAccess, x, y, z, x + 1, y, z);
                    if (connectedN && connectedE) {
                        activeBound = this.bound;
                        break;
                    }
                    if (connectedN) {
                        activeBound = this.boundN;
                        break;
                    }
                    if (!connectedE) break;
                    activeBound = this.boundE;
                    break;
                }
                if (connection.isAttachedNeighbor(blockAccess, x, y, z, x, y, z - 1)) {
                    activeBound = this.boundE;
                    break;
                }
                if (!connection.isAttachedNeighbor(blockAccess, x, y, z, x + 1, y, z)) break;
                activeBound = this.boundN;
                break;
            }
            case 4: {
                activeBound = this.boundSW;
                if (connection.isAttachedNeighbor(blockAccess, x, y, z, x - 1, y, z + 1)) {
                    boolean connectedS = connection.isAttachedNeighbor(blockAccess, x, y, z, x, y, z + 1);
                    boolean connectedW = connection.isAttachedNeighbor(blockAccess, x, y, z, x - 1, y, z);
                    if (connectedS && connectedW) {
                        activeBound = this.bound;
                        break;
                    }
                    if (connectedS) {
                        activeBound = this.boundS;
                        break;
                    }
                    if (!connectedW) break;
                    activeBound = this.boundW;
                    break;
                }
                if (connection.isAttachedNeighbor(blockAccess, x, y, z, x, y, z + 1)) {
                    activeBound = this.boundW;
                    break;
                }
                if (!connection.isAttachedNeighbor(blockAccess, x, y, z, x - 1, y, z)) break;
                activeBound = this.boundS;
                break;
            }
            case 5: {
                activeBound = this.boundSE;
                if (connection.isAttachedNeighbor(blockAccess, x, y, z, x + 1, y, z + 1)) {
                    boolean connectedS = connection.isAttachedNeighbor(blockAccess, x, y, z, x, y, z + 1);
                    boolean connectedE = connection.isAttachedNeighbor(blockAccess, x, y, z, x + 1, y, z);
                    if (connectedS && connectedE) {
                        activeBound = this.bound;
                        break;
                    }
                    if (connectedS) {
                        activeBound = this.boundS;
                        break;
                    }
                    if (!connectedE) break;
                    activeBound = this.boundE;
                    break;
                }
                if (connection.isAttachedNeighbor(blockAccess, x, y, z, x, y, z + 1)) {
                    activeBound = this.boundE;
                    break;
                }
                if (!connection.isAttachedNeighbor(blockAccess, x, y, z, x + 1, y, z)) break;
                activeBound = this.boundS;
                break;
            }
        }
        return activeBound;
    }
}

