/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block;

import com.jaquadro.minecraft.gardencore.api.IPlantProxy;
import com.jaquadro.minecraft.gardencore.api.block.IGardenBlock;
import com.jaquadro.minecraft.gardencore.api.block.garden.IConnectionProfile;
import com.jaquadro.minecraft.gardencore.api.block.garden.ISlotProfile;
import com.jaquadro.minecraft.gardencore.api.block.garden.ISlotShareProfile;
import com.jaquadro.minecraft.gardencore.api.plant.PlantItem;
import com.jaquadro.minecraft.gardencore.block.BlockGardenProxy;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import com.jaquadro.minecraft.gardencore.core.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockGarden
extends BlockContainer
implements IGardenBlock {
    public static final int SLOT_INVALID = -1;
    protected IConnectionProfile connectionProfile;
    protected ISlotProfile slotProfile;
    protected ISlotShareProfile slotShareProfile;

    protected BlockGarden(String blockName, Material material) {
        super(material);
        this.func_149663_c(blockName);
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (side != ForgeDirection.UP.ordinal()) {
            return false;
        }
        TileEntityGarden tileEntity = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tileEntity == null) {
            tileEntity = this.createNewTileEntity(world, 0);
            world.func_147455_a(x, y, z, (TileEntity)tileEntity);
        }
        return this.applyItemToGarden(world, x, y, z, player, null, hitX, hitY, hitZ);
    }

    public abstract TileEntityGarden createNewTileEntity(World var1, int var2);

    public void func_149681_a(World world, int x, int y, int z, int p_149681_5_, EntityPlayer player) {
        TileEntityGarden te;
        super.func_149681_a(world, x, y, z, p_149681_5_, player);
        if (player.field_71075_bZ.field_75098_d && (te = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            te.clearPlantedContents();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        TileEntityGarden te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            for (ItemStack item : te.getReachableContents()) {
                this.func_149642_a(world, x, y, z, item);
            }
            te.clearReachableContents();
        }
        super.func_149749_a(world, x, y, z, block, data);
    }

    @Override
    public int getDefaultSlot() {
        return -1;
    }

    @Override
    public IConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    @Override
    public ISlotProfile getSlotProfile() {
        return this.slotProfile;
    }

    @Override
    public ISlotShareProfile getSlotShareProfile() {
        return this.slotShareProfile;
    }

    public void clearPlantedContents(IBlockAccess world, int x, int y, int z) {
        TileEntityGarden te = this.getTileEntity(world, x, y, z);
        if (te != null) {
            te.clearReachableContents();
        }
        BlockGarden.validateBlockState(te);
    }

    public NBTTagCompound saveAndClearPlantedContents(IBlockAccess world, int x, int y, int z) {
        TileEntityGarden te = this.getTileEntity(world, x, y, z);
        if (te == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        te.func_145841_b(tag);
        this.clearPlantedContents(world, x, y, z);
        return tag;
    }

    public void restorePlantedContents(IBlockAccess world, int x, int y, int z, NBTTagCompound tag) {
        TileEntityGarden te = this.getTileEntity(world, x, y, z);
        if (te == null) {
            return;
        }
        te.func_145839_a(tag);
        BlockGarden.validateBlockState(te);
    }

    public Block getPlantBlockFromSlot(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        TileEntityGarden te = this.getTileEntity(blockAccess, x, y, z);
        ItemStack stack = te.getPlantInSlot(slot);
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        return Block.func_149634_a((Item)stack.func_77973_b());
    }

    public int getPlantMetaFromSlot(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        TileEntityGarden te = this.getTileEntity(blockAccess, x, y, z);
        ItemStack stack = te.getPlantInSlot(slot);
        if (stack == null || stack.func_77973_b() == null) {
            return 0;
        }
        return stack.func_77960_j();
    }

    public static void validateBlockState(TileEntityGarden tileEntity) {
        int y;
        Block baseBlock = tileEntity.func_145831_w().func_147439_a(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        if (!(baseBlock instanceof BlockGarden)) {
            return;
        }
        BlockGarden garden = (BlockGarden)baseBlock;
        int plantHeight = garden.getAggregatePlantHeight((IBlockAccess)tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        World world = tileEntity.func_145831_w();
        int x = tileEntity.field_145851_c;
        int z = tileEntity.field_145849_e;
        int yLimit = y + plantHeight;
        for (y = tileEntity.field_145848_d + 1; y < yLimit; ++y) {
            Block block = world.func_147439_a(x, y, z);
            if (block.isAir((IBlockAccess)world, x, y, z)) {
                world.func_147465_d(x, y, z, (Block)ModBlocks.gardenProxy, 0, 3);
            }
            world.func_147479_m(x, y, z);
        }
        while (world.func_147439_a(x, y, z) instanceof BlockGardenProxy) {
            world.func_147468_f(x, y++, z);
        }
    }

    public int getAggregatePlantHeight(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntityGarden garden = this.getTileEntity(blockAccess, x, y, z);
        int height = 0;
        for (int slot : this.slotProfile.getPlantSlots()) {
            ItemStack item = garden.func_70301_a(slot);
            PlantItem plant = PlantItem.getForItem(blockAccess, item);
            if (plant == null) continue;
            height = Math.max(height, plant.getPlantHeight());
        }
        return height;
    }

    public final boolean applyItemToGarden(World world, int x, int y, int z, EntityPlayer player, ItemStack itemStack, float hitX, float hitY, float hitZ) {
        return this.applyItemToGarden(world, x, y, z, player, itemStack, hitX, hitY, hitZ, true);
    }

    public final boolean applyItemToGarden(World world, int x, int y, int z, EntityPlayer player, ItemStack itemStack) {
        return this.applyItemToGarden(world, x, y, z, player, itemStack, 0.0f, 0.0f, 0.0f, false);
    }

    protected boolean applyItemToGarden(World world, int x, int y, int z, EntityPlayer player, ItemStack itemStack, float hitX, float hitY, float hitZ, boolean hitValid) {
        ItemStack item;
        ItemStack itemStack2 = item = itemStack == null ? player.field_71071_by.func_70448_g() : itemStack;
        if (item == null) {
            return false;
        }
        int slot = this.getSlot(world, x, y, z, player, hitX, hitY, hitZ);
        if (this.applyTestKitToGarden(world, x, y, z, slot, item)) {
            return true;
        }
        PlantItem plant = PlantItem.getForItem((IBlockAccess)world, item);
        if (plant != null) {
            int plantSlot;
            int n = plantSlot = hitValid ? this.getEmptySlotForPlant(world, x, y, z, player, plant, hitX, hitY, hitZ) : this.getEmptySlotForPlant(world, x, y, z, player, plant);
            if (plantSlot == -1) {
                return false;
            }
            if (this.canSustainPlantIndependently((IBlockAccess)world, x, y, z, plant)) {
                return false;
            }
            return this.applyPlantToGarden(world, x, y, z, (EntityPlayer)(itemStack == null ? player : null), plantSlot, plant);
        }
        return false;
    }

    public boolean canSustainPlantIndependently(IBlockAccess blockAccess, int x, int y, int z, PlantItem plant) {
        Item item = plant.getPlantSourceItem().func_77973_b();
        if (item instanceof IPlantable) {
            return this.canSustainPlant(blockAccess, x, y, z, ForgeDirection.UP, (IPlantable)item);
        }
        return false;
    }

    @Override
    public abstract ItemStack getGardenSubstrate(IBlockAccess var1, int var2, int var3, int var4, int var5);

    protected int getSlot(World world, int x, int y, int z, EntityPlayer player, float hitX, float hitY, float hitZ) {
        return -1;
    }

    protected int getEmptySlotForPlant(World world, int x, int y, int z, EntityPlayer player, PlantItem plant) {
        return -1;
    }

    protected int getEmptySlotForPlant(World world, int x, int y, int z, EntityPlayer player, PlantItem plant, float hitX, float hitY, float hitZ) {
        return this.getEmptySlotForPlant(world, x, y, z, player, plant);
    }

    protected boolean enoughSpaceAround(IBlockAccess blockAccess, int x, int y, int z, int slot, PlantItem plant) {
        int height = plant.getPlantHeight();
        boolean enough = true;
        for (int i = 0; i < height; ++i) {
            enough &= blockAccess.func_147437_c(x, y + 1 + i, z) || blockAccess.func_147439_a(x, y + 1 + i, z) instanceof IPlantProxy;
        }
        return enough;
    }

    protected boolean isPlantValidForSubstrate(ItemStack substrate, PlantItem plant) {
        return true;
    }

    public boolean isPlantValidForSlot(World world, int x, int y, int z, int slot, PlantItem plant) {
        if (plant == null) {
            return false;
        }
        if (plant.getPlantBlock() instanceof BlockContainer) {
            return false;
        }
        if (!this.slotProfile.isPlantValidForSlot((IBlockAccess)world, x, y, z, slot, plant)) {
            return false;
        }
        if (!this.enoughSpaceAround((IBlockAccess)world, x, y, z, slot, plant)) {
            return false;
        }
        if (!this.isPlantValidForSubstrate(this.getGardenSubstrate((IBlockAccess)world, x, y, z, slot), plant)) {
            return false;
        }
        return !this.canSustainPlantIndependently((IBlockAccess)world, x, y, z, plant);
    }

    public boolean applyHoe(World world, int x, int y, int z) {
        return false;
    }

    protected boolean applyPlantToGarden(World world, int x, int y, int z, EntityPlayer player, int slot, PlantItem plant) {
        if (!this.isPlantValidForSlot(world, x, y, z, slot, plant)) {
            return false;
        }
        TileEntityGarden garden = this.getTileEntity((IBlockAccess)world, x, y, z);
        garden.func_70299_a(slot, plant.getPlantSourceItem().func_77946_l());
        if (player != null && !player.field_71075_bZ.field_75098_d) {
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            if (--currentItem.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
        return true;
    }

    protected boolean applyTestKitToGarden(World world, int x, int y, int z, int slot, ItemStack testKit) {
        if (testKit == null || testKit.func_77973_b() != ModItems.usedSoilTestKit) {
            return false;
        }
        ItemStack substrateStack = this.getGardenSubstrate((IBlockAccess)world, x, y, z, slot);
        if (substrateStack == null || substrateStack.func_77973_b() == null) {
            return false;
        }
        TileEntityGarden tileEntity = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tileEntity == null) {
            return false;
        }
        tileEntity.setBiomeData(testKit.func_77960_j());
        world.func_147471_g(x, y, z);
        for (int i = 0; i < 5; ++i) {
            double d0 = world.field_73012_v.nextGaussian() * 0.02;
            double d1 = world.field_73012_v.nextGaussian() * 0.02;
            double d2 = world.field_73012_v.nextGaussian() * 0.02;
            world.func_72869_a("happyVillager", (double)((float)x + world.field_73012_v.nextFloat()), (double)((float)y + 0.5f + world.field_73012_v.nextFloat()), (double)((float)z + world.field_73012_v.nextFloat()), d0, d1, d2);
        }
        return true;
    }

    public TileEntityGarden getTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof TileEntityGarden ? (TileEntityGarden)te : null;
    }
}

