/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block;

import com.jaquadro.minecraft.gardencore.GardenCore;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityCompostBin;
import com.jaquadro.minecraft.gardencore.client.particle.EntitySteamFX;
import com.jaquadro.minecraft.gardencore.core.ClientProxy;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import com.jaquadro.minecraft.gardencore.core.handlers.GuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCompostBin
extends BlockContainer {
    private static final int ICON_SIDE = 0;
    private static final int ICON_TOP = 1;
    private static final int ICON_BOTTOM = 2;
    private static final int ICON_INNER = 3;
    @SideOnly(value=Side.CLIENT)
    IIcon[] icons;

    public BlockCompostBin(String name) {
        super(Material.field_151575_d);
        this.func_149663_c(name);
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149675_a(true);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149766_f);
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.compostBinRenderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float vx, float vy, float vz) {
        player.openGui((Object)GardenCore.instance, GuiHandler.compostBinGuiID, world, x, y, z);
        return true;
    }

    public static void updateBlockState(World world, int x, int y, int z) {
        TileEntityCompostBin te = (TileEntityCompostBin)world.func_147438_o(x, y, z);
        if (te == null) {
            return;
        }
        world.func_147471_g(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        TileEntityCompostBin te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            for (int i = 0; i < te.func_70302_i_(); ++i) {
                ItemStack item = te.func_70301_a(i);
                if (item == null) continue;
                this.func_149642_a(world, x, y, z, item);
            }
        }
        super.func_149749_a(world, x, y, z, block, data);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntityCompostBin te = (TileEntityCompostBin)world.func_147438_o(x, y, z);
        if (te == null) {
            return;
        }
        if (te.isDecomposing()) {
            float px = (float)x + 0.5f + random.nextFloat() * 0.6f - 0.3f;
            float py = (float)y + 0.5f + random.nextFloat() * 6.0f / 16.0f;
            float pz = (float)z + 0.5f + random.nextFloat() * 0.6f - 0.3f;
            EntitySteamFX.spawnParticle(world, px, py, pz);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (side) {
            case 0: {
                return this.icons[2];
            }
            case 1: {
                return this.icons[1];
            }
        }
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getInnerIcon() {
        return this.icons[3];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[4];
        this.icons[0] = register.func_94245_a("GardenCore:compost_bin_side");
        this.icons[1] = register.func_94245_a("GardenCore:compost_bin_top");
        this.icons[2] = register.func_94245_a("GardenCore:compost_bin_bottom");
        this.icons[3] = register.func_94245_a("GardenCore:compost_bin_inner");
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntityCompostBin();
    }

    public TileEntityCompostBin getTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof TileEntityCompostBin ? (TileEntityCompostBin)te : null;
    }
}

