/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.api;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;

public final class PlantUtil {
    private PlantUtil() {
    }

    public static IPlantable getPlantable(ItemStack plant) {
        Block itemBlock;
        if (plant == null || plant.func_77973_b() == null) {
            return null;
        }
        IPlantable plantable = null;
        Item item = plant.func_77973_b();
        if (item instanceof IPlantable) {
            plantable = (IPlantable)item;
        } else if (item instanceof ItemBlock && (itemBlock = Block.func_149634_a((Item)item)) instanceof IPlantable) {
            plantable = (IPlantable)itemBlock;
        }
        return plantable;
    }

    public static Block getPlantBlock(ItemStack plant) {
        return PlantUtil.getPlantBlock(PlantUtil.getPlantable(plant));
    }

    public static Block getPlantBlock(IPlantable plant) {
        try {
            return PlantUtil.getPlantBlock(null, 0, 0, 0, plant);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Block getPlantBlock(IBlockAccess world, int x, int y, int z, ItemStack plant) {
        return PlantUtil.getPlantBlock(world, x, y, z, PlantUtil.getPlantable(plant));
    }

    public static Block getPlantBlock(IBlockAccess world, int x, int y, int z, IPlantable plant) {
        if (plant == null) {
            return null;
        }
        Block itemBlock = plant.getPlant(world, x, y, z);
        if (itemBlock == null && plant instanceof Block) {
            itemBlock = (Block)plant;
        }
        return itemBlock;
    }

    public static int getPlantMetadata(ItemStack plant) {
        return PlantUtil.getPlantMetadata(PlantUtil.getPlantable(plant));
    }

    public static int getPlantMetadata(IPlantable plant) {
        try {
            return PlantUtil.getPlantMetadata(null, 0, 0, 0, plant);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getPlantMetadata(IBlockAccess world, int x, int y, int z, ItemStack plant) {
        if (plant == null) {
            return 0;
        }
        return PlantUtil.getPlantMetadata(world, x, y, z, PlantUtil.getPlantable(plant), plant.func_77960_j());
    }

    public static int getPlantMetadata(IBlockAccess world, int x, int y, int z, IPlantable plant) {
        return PlantUtil.getPlantMetadata(world, x, y, z, plant, 0);
    }

    private static int getPlantMetadata(IBlockAccess world, int x, int y, int z, IPlantable plant, int defaultMeta) {
        int plantMeta;
        if (plant == null) {
            return 0;
        }
        Block itemBlock = plant.getPlant(world, x, y, z);
        int itemMeta = defaultMeta;
        if (itemBlock != null && (plantMeta = plant.getPlantMetadata(world, x, y, z)) > 0) {
            itemMeta = plantMeta;
        }
        return itemMeta;
    }
}

