/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.api;

import com.jaquadro.minecraft.gardencore.api.IPlantMetaResolver;
import com.jaquadro.minecraft.gardencore.api.IPlantRenderer;
import com.jaquadro.minecraft.gardencore.api.plant.DefaultPlantInfo;
import com.jaquadro.minecraft.gardencore.api.plant.IPlantInfo;
import com.jaquadro.minecraft.gardencore.api.plant.PlantSize;
import com.jaquadro.minecraft.gardencore.api.plant.PlantType;
import com.jaquadro.minecraft.gardencore.api.plant.SimplePlantInfo;
import com.jaquadro.minecraft.gardencore.client.renderer.plant.CropsPlantRenderer;
import com.jaquadro.minecraft.gardencore.client.renderer.plant.CrossedSquaresPlantRenderer;
import com.jaquadro.minecraft.gardencore.client.renderer.plant.DoublePlantRenderer;
import com.jaquadro.minecraft.gardencore.client.renderer.plant.GroundCoverPlantRenderer;
import com.jaquadro.minecraft.gardencore.client.renderer.plant.SunflowerRenderer;
import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import com.jaquadro.minecraft.gardencore.integration.VanillaMetaResolver;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;

public final class PlantRegistry {
    private static final DefaultPlantInfo defaultPlantInfo = new DefaultPlantInfo();
    public static final IPlantRenderer CROPS_RENDERER = new CropsPlantRenderer();
    public static final IPlantRenderer CROSSED_SQUARES_RENDERER = new CrossedSquaresPlantRenderer();
    public static final IPlantRenderer DOUBLE_PLANT_RENDERER = new DoublePlantRenderer();
    public static final IPlantRenderer GROUND_COVER_RENDERER = new GroundCoverPlantRenderer();
    private UniqueMetaRegistry<IPlantRenderer> renderRegistry = new UniqueMetaRegistry();
    private Map<Integer, IPlantRenderer> renderIdRegistry = new HashMap<Integer, IPlantRenderer>();
    private UniqueMetaRegistry<IPlantMetaResolver> metaResolverRegistry = new UniqueMetaRegistry();
    private UniqueMetaRegistry<IPlantInfo> plantInfoRegistry = new UniqueMetaRegistry();
    private static PlantRegistry instance = new PlantRegistry();

    public static PlantRegistry instance() {
        return instance;
    }

    public boolean isPlantBlacklisted(ItemStack plant) {
        return false;
    }

    public boolean plantRespondsToBonemeal(ItemStack plant) {
        return false;
    }

    private PlantRegistry() {
        this.registerPlantRenderer(1, (IPlantRenderer)new CrossedSquaresPlantRenderer());
        this.registerPlantRenderer(40, (IPlantRenderer)new DoublePlantRenderer());
        this.registerPlantRenderer((Block)Blocks.field_150398_cm, 0, (IPlantRenderer)new SunflowerRenderer());
        VanillaMetaResolver vanillaResolver = new VanillaMetaResolver();
        this.registerPlantMetaResolver((Block)Blocks.field_150328_O, vanillaResolver);
        this.registerPlantMetaResolver((Block)Blocks.field_150327_N, vanillaResolver);
        this.registerPlantMetaResolver((Block)Blocks.field_150337_Q, vanillaResolver);
        this.registerPlantMetaResolver((Block)Blocks.field_150338_P, vanillaResolver);
        this.registerPlantMetaResolver((Block)Blocks.field_150329_H, vanillaResolver);
        this.registerPlantMetaResolver((Block)Blocks.field_150398_cm, vanillaResolver);
        for (int i : new int[]{0, 2, 3, 4, 5, 6, 7, 8}) {
            this.registerPlantInfo((Block)Blocks.field_150328_O, i, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.SMALL));
        }
        for (int i : new int[]{0}) {
            this.registerPlantInfo((Block)Blocks.field_150327_N, i, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.SMALL));
        }
        for (int i : new int[]{0, 1, 3, 4, 5}) {
            this.registerPlantInfo((Block)Blocks.field_150398_cm, i, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.MEDIUM, 2, 2, new int[]{i, i | 8}));
        }
        for (int i : new int[]{2}) {
            this.registerPlantInfo((Block)Blocks.field_150398_cm, i, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.LARGE, 2, 2, new int[]{i, i | 8}));
        }
        for (int i : new int[]{2}) {
            this.registerPlantInfo((Block)Blocks.field_150329_H, i, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.SMALL));
        }
        for (int i : new int[]{1}) {
            this.registerPlantInfo((Block)Blocks.field_150329_H, i, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.LARGE));
        }
        this.registerPlantInfo((Block)Blocks.field_150337_Q, 0, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.SMALL));
        this.registerPlantInfo((Block)Blocks.field_150338_P, 0, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.SMALL));
        this.registerPlantInfo(Blocks.field_150392_bi, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND_COVER, PlantSize.FULL));
        this.registerPlantInfo(Blocks.field_150464_aj, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.FULL));
        this.registerPlantInfo(Blocks.field_150459_bM, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.FULL));
        this.registerPlantInfo(Blocks.field_150469_bN, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.FULL));
        this.registerPlantInfo(Blocks.field_150388_bm, (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.FULL));
    }

    public void registerPlantRenderer(int renderId, IPlantRenderer renderer) {
        if (this.renderIdRegistry.containsKey(renderId)) {
            return;
        }
        this.renderIdRegistry.put(renderId, renderer);
    }

    public void registerPlantRenderer(Block block, IPlantRenderer renderer) {
        this.registerPlantRenderer(block, Short.MAX_VALUE, renderer);
    }

    public void registerPlantRenderer(Block block, int meta, IPlantRenderer renderer) {
        UniqueMetaIdentifier id = ModBlocks.getUniqueMetaID(block, meta);
        if (id != null) {
            this.renderRegistry.register(id, renderer);
        }
    }

    public void registerPlantRenderer(String modId, String block, IPlantRenderer renderer) {
        UniqueMetaIdentifier id = new UniqueMetaIdentifier(modId, block, Short.MAX_VALUE);
        this.renderRegistry.register(id, renderer);
    }

    public void registerPlantRenderer(String modId, String block, int meta, IPlantRenderer renderer) {
        UniqueMetaIdentifier id = new UniqueMetaIdentifier(modId, block, meta);
        this.renderRegistry.register(id, renderer);
    }

    public IPlantRenderer getPlantRenderer(Block block, int meta) {
        UniqueMetaIdentifier id = ModBlocks.getUniqueMetaID(block, meta);
        if (id == null) {
            return null;
        }
        IPlantRenderer renderer = this.renderRegistry.getEntry(id);
        if (renderer != null) {
            return renderer;
        }
        return this.renderIdRegistry.get(block.func_149645_b());
    }

    public void registerPlantMetaResolver(Block block, IPlantMetaResolver resolver) {
        this.registerPlantMetaResolver(block, Short.MAX_VALUE, resolver);
    }

    public void registerPlantMetaResolver(Block block, int meta, IPlantMetaResolver resolver) {
        UniqueMetaIdentifier id = ModBlocks.getUniqueMetaID(block, meta);
        if (id != null) {
            this.metaResolverRegistry.register(id, resolver);
        }
    }

    public void registerPlantMetaResolver(String modId, String block, IPlantMetaResolver resolver) {
        UniqueMetaIdentifier id = new UniqueMetaIdentifier(modId, block, Short.MAX_VALUE);
        this.metaResolverRegistry.register(id, resolver);
    }

    public void registerPlantMetaResolver(String modId, String block, int meta, IPlantMetaResolver resolver) {
        UniqueMetaIdentifier id = new UniqueMetaIdentifier(modId, block, meta);
        this.metaResolverRegistry.register(id, resolver);
    }

    public IPlantMetaResolver getPlantMetaResolver(Block block, int meta) {
        UniqueMetaIdentifier id = ModBlocks.getUniqueMetaID(block, meta);
        if (id == null) {
            return null;
        }
        return this.metaResolverRegistry.getEntry(id);
    }

    public void registerPlantInfo(Block block, IPlantInfo info) {
        this.registerPlantInfo(block, Short.MAX_VALUE, info);
    }

    public void registerPlantInfo(Block block, int meta, IPlantInfo info) {
        UniqueMetaIdentifier id = ModBlocks.getUniqueMetaID(block, meta);
        if (id != null) {
            this.plantInfoRegistry.register(id, info);
            this.metaResolverRegistry.register(id, info);
        }
    }

    public void registerPlantInfo(String modId, IPlantInfo info) {
        UniqueMetaIdentifier id = new UniqueMetaIdentifier(modId);
        this.plantInfoRegistry.register(id, info);
        this.metaResolverRegistry.register(id, info);
    }

    public void registerPlantInfo(String modId, String block, IPlantInfo info) {
        UniqueMetaIdentifier id = new UniqueMetaIdentifier(modId, block);
        this.plantInfoRegistry.register(id, info);
        this.metaResolverRegistry.register(id, info);
    }

    public void registerPlantInfo(String modId, String block, int meta, IPlantInfo info) {
        UniqueMetaIdentifier id = new UniqueMetaIdentifier(modId, block, meta);
        this.plantInfoRegistry.register(id, info);
        this.metaResolverRegistry.register(id, info);
    }

    public IPlantInfo getPlantInfo(Block block, int meta) {
        UniqueMetaIdentifier id = ModBlocks.getUniqueMetaID(block, meta);
        if (id == null) {
            return null;
        }
        return this.plantInfoRegistry.getEntry(id);
    }

    public IPlantInfo getPlantInfo(IBlockAccess world, IPlantable plant) {
        Block block = plant.getPlant(world, 0, 0, 0);
        int meta = plant.getPlantMetadata(world, 0, 0, 0);
        return this.getPlantInfo(block, meta);
    }

    public IPlantInfo getPlantInfoOrDefault(Block block, int meta) {
        IPlantInfo info = this.getPlantInfo(block, meta);
        if (info != null) {
            return info;
        }
        return defaultPlantInfo;
    }

    public boolean isValidPlantBlock(Block block) {
        if (block == null) {
            return false;
        }
        if (block instanceof IPlantable) {
            return true;
        }
        Item item = Item.func_150898_a((Block)block);
        return item instanceof IPlantable;
    }

    public static IPlantable getPlantable(ItemStack plantItemStack) {
        Block itemBlock;
        if (plantItemStack == null || plantItemStack.func_77973_b() == null) {
            return null;
        }
        IPlantable plantable = null;
        Item item = plantItemStack.func_77973_b();
        if (item instanceof IPlantable) {
            plantable = (IPlantable)item;
        } else if (item instanceof ItemBlock && (itemBlock = Block.func_149634_a((Item)item)) instanceof IPlantable) {
            plantable = (IPlantable)itemBlock;
        }
        return plantable;
    }
}

