/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.inventory;

import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityPotteryTable;
import com.jaquadro.minecraft.gardencontainers.core.ModBlocks;
import com.jaquadro.minecraft.gardencontainers.inventory.InventoryPottery;
import com.jaquadro.minecraft.gardencontainers.inventory.SlotPottery;
import com.jaquadro.minecraft.gardencontainers.item.crafting.PotteryManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ContainerPotteryTable
extends Container {
    private static final int InventoryX = 10;
    private static final int InventoryY = 140;
    private static final int HotbarY = 198;
    private static final int StorageX1 = 26;
    private static final int StorageY1 = 18;
    private static final int StorageX2 = 138;
    private static final int StorageY2 = 18;
    private IInventory tableInventory;
    private IInventory craftResult = new InventoryCraftResult();
    private Slot inputSlot1;
    private Slot inputSlot2;
    private Slot outputSlot;
    private List<Slot> storageSlots;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;

    public ContainerPotteryTable(InventoryPlayer inventory, TileEntityPotteryTable tileEntity) {
        int i;
        this.tableInventory = new InventoryPottery(tileEntity, this);
        this.inputSlot1 = this.func_75146_a(new Slot(this.tableInventory, 0, 50, 44));
        this.inputSlot2 = this.func_75146_a(new Slot(this.tableInventory, 1, 50, 80));
        this.outputSlot = this.func_75146_a(new SlotPottery(inventory.field_70458_d, this.tableInventory, this.craftResult, 2, 110, 62));
        this.storageSlots = new ArrayList<Slot>();
        for (i = 0; i < 6; ++i) {
            this.storageSlots.add(this.func_75146_a(new Slot(this.tableInventory, 3 + i, 26, 18 + i * 18)));
        }
        for (i = 0; i < 6; ++i) {
            this.storageSlots.add(this.func_75146_a(new Slot(this.tableInventory, 9 + i, 138, 18 + i * 18)));
        }
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, 10 + j * 18, 140 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.func_75146_a(new Slot((IInventory)inventory, i, 10 + i * 18, 198)));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tableInventory.func_70300_a(player);
    }

    public void func_75130_a(IInventory inventory) {
        ItemStack pattern = this.tableInventory.func_70301_a(0);
        ItemStack target = this.tableInventory.func_70301_a(1);
        if (target != null && target.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150435_aG)) {
            if (pattern == null) {
                this.craftResult.func_70299_a(0, new ItemStack((Block)ModBlocks.largePot, 1, 1));
                return;
            }
            if (PotteryManager.instance().isRegisteredPattern(pattern)) {
                target = new ItemStack((Block)ModBlocks.largePot, target.field_77994_a, 1);
            }
        }
        if (pattern != null && pattern.func_77973_b() == Items.field_151100_aR && target != null && target.func_77973_b() == Item.func_150898_a((Block)ModBlocks.largePot) && (target.func_77960_j() & 0xF) == 0) {
            this.craftResult.func_70299_a(0, new ItemStack((Block)ModBlocks.largePotColored, 1, target.func_77960_j() | pattern.func_77960_j()));
            return;
        }
        this.craftResult.func_70299_a(0, PotteryManager.instance().getStampResult(pattern, target));
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int inventoryStart = this.playerSlots.get((int)0).field_75222_d;
        int hotbarStart = this.hotbarSlots.get((int)0).field_75222_d;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).field_75222_d + 1;
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (slotIndex == this.outputSlot.field_75222_d) {
                if (!this.func_75135_a(slotStack, inventoryStart, hotbarEnd, true)) {
                    return null;
                }
                slot.func_75220_a(slotStack, itemStack);
            } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd ? (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.func_75135_a(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.func_75135_a(slotStack, inventoryStart, hotbarStart, false)) : !this.func_75135_a(slotStack, inventoryStart, hotbarEnd, false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.field_77994_a == itemStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, slotStack);
        }
        return itemStack;
    }
}

