/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.client.renderer;

import com.jaquadro.minecraft.gardencontainers.block.BlockMediumPot;
import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityMediumPot;
import com.jaquadro.minecraft.gardencontainers.core.ClientProxy;
import com.jaquadro.minecraft.gardencore.client.renderer.support.ModularBoxRenderer;
import com.jaquadro.minecraft.gardencore.util.RenderHelper;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class MediumPotRenderer
implements ISimpleBlockRenderingHandler {
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();
    private float[] colorScratch = new float[3];

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockMediumPot)) {
            return;
        }
        this.renderInventoryBlock((BlockMediumPot)block, metadata, modelId, renderer);
    }

    private void renderInventoryBlock(BlockMediumPot block, int metadata, int modelId, RenderBlocks renderer) {
        IIcon icon = renderer.func_147787_a((Block)block, 1, metadata & 0xF);
        boolean blendEnabled = GL11.glIsEnabled((int)3042);
        if (blendEnabled) {
            GL11.glDisable((int)3042);
        }
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setIcon(icon);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.boxRenderer.renderBox(null, (Block)block, 0.0, 0.0, 0.0, 0.125, 0.0, 0.125, 0.875, 0.75, 0.875, 0, 2);
        if (!blendEnabled) {
            GL11.glDisable((int)3042);
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockMediumPot)) {
            return false;
        }
        try {
            return this.renderWorldBlockPass0(world, x, y, z, (BlockMediumPot)block, modelId, renderer);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean renderWorldBlockPass0(IBlockAccess world, int x, int y, int z, BlockMediumPot block, int modelId, RenderBlocks renderer) {
        int metadata = world.func_72805_g(x, y, z);
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        for (int i = 0; i < 6; ++i) {
            this.boxRenderer.setIcon(renderer.func_147787_a((Block)block, i, metadata), i);
        }
        this.boxRenderer.renderBox(world, (Block)block, x, y, z, 0.125, 0.0, 0.125, 0.875, 0.75, 0.875, 0, 2);
        TileEntityMediumPot te = block.getTileEntity(world, x, y, z);
        if (te != null && te.getSubstrate() != null && te.getSubstrate().func_77973_b() instanceof ItemBlock) {
            Block substrate = Block.func_149634_a((Item)te.getSubstrate().func_77973_b());
            int substrateData = te.getSubstrate().func_77960_j();
            if (substrate != Blocks.field_150355_j) {
                IIcon substrateIcon = renderer.func_147787_a(substrate, 1, substrateData);
                int color = substrate.func_149720_d(world, x, y, z);
                if (color == Blocks.field_150349_c.func_149720_d(world, x, y, z)) {
                    color = ColorizerGrass.func_77480_a((double)te.getBiomeTemperature(), (double)te.getBiomeHumidity());
                }
                RenderHelper.calculateBaseColor(this.colorScratch, color);
                RenderHelper.instance.setRenderBounds(0.125, 0.0, 0.125, 0.875, 0.6875, 0.875);
                RenderHelper.instance.renderFace(1, world, (Block)block, x, y, z, substrateIcon, this.colorScratch[0], this.colorScratch[1], this.colorScratch[2]);
            }
        }
        return true;
    }

    private boolean renderWorldBlockPass1(IBlockAccess world, int x, int y, int z, BlockMediumPot block, int modelId, RenderBlocks renderer) {
        RenderHelper.instance.renderEmptyPlane(x, y, z);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.mediumPotRenderID;
    }
}

