/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.client.renderer;

import com.jaquadro.minecraft.gardencontainers.block.BlockDecorativePot;
import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityDecorativePot;
import com.jaquadro.minecraft.gardencontainers.core.ClientProxy;
import com.jaquadro.minecraft.gardencore.client.renderer.support.ModularBoxRenderer;
import com.jaquadro.minecraft.gardencore.util.RenderHelper;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class DecorativePotRenderer
implements ISimpleBlockRenderingHandler {
    private float[] baseColor = new float[3];
    private float[] activeSubstrateColor = new float[3];
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockDecorativePot)) {
            return;
        }
        this.renderInventoryBlock((BlockDecorativePot)block, metadata, modelId, renderer);
    }

    private void renderInventoryBlock(BlockDecorativePot block, int metadata, int modelId, RenderBlocks renderer) {
        IIcon icon = renderer.func_147787_a((Block)block, 1, metadata);
        float unit = 0.0625f;
        this.boxRenderer.setIcon(icon);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.boxRenderer.renderBox(null, (Block)block, 0.0, 0.0, 0.0, 0.0, 14.0f * unit, 0.0, 1.0, 1.0, 1.0, 0, 3);
        this.boxRenderer.renderBox(null, (Block)block, 0.0, 0.0, 0.0, 1.0f * unit, 8.0f * unit, 1.0f * unit, 15.0f * unit, 16.0f * unit, 15.0f * unit, 0, 2);
        this.boxRenderer.renderSolidBox(null, (Block)block, 0.0, 0.0, 0.0, 3.0f * unit, 6.0f * unit, 3.0f * unit, 13.0f * unit, 8.0f * unit, 13.0f * unit);
        this.boxRenderer.renderSolidBox(null, (Block)block, 0.0, 0.0, 0.0, 5.0f * unit, 3.0f * unit, 5.0f * unit, 11.0f * unit, 6.0f * unit, 11.0f * unit);
        this.boxRenderer.renderSolidBox(null, (Block)block, 0.0, 0.0, 0.0, 2.0f * unit, 0.0f * unit, 2.0f * unit, 14.0f * unit, 3.0f * unit, 14.0f * unit);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockDecorativePot)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockDecorativePot)block, modelId, renderer);
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockDecorativePot block, int modelId, RenderBlocks renderer) {
        int data = world.func_72805_g(x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        RenderHelper.calculateBaseColor(this.baseColor, block.func_149720_d(world, x, y, z));
        float unit = 0.0625f;
        for (int i = 0; i < 6; ++i) {
            this.boxRenderer.setIcon(renderer.func_147787_a((Block)block, i, data), i);
        }
        this.boxRenderer.setColor(this.baseColor);
        this.boxRenderer.renderBox(world, (Block)block, x, y, z, 0.0, 14.0f * unit, 0.0, 1.0, 1.0, 1.0, 0, 3);
        this.boxRenderer.setScaledColor(this.baseColor, 0.9375f);
        this.boxRenderer.renderBox(world, (Block)block, x, y, z, 1.0f * unit, 8.0f * unit, 1.0f * unit, 15.0f * unit, 16.0f * unit, 15.0f * unit, 0, 2);
        this.boxRenderer.setScaledExteriorColor(this.baseColor, 0.875f);
        this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, 3.0f * unit, 6.0f * unit, 3.0f * unit, 13.0f * unit, 8.0f * unit, 13.0f * unit);
        this.boxRenderer.setScaledExteriorColor(this.baseColor, 0.8125f);
        this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, 5.0f * unit, 3.0f * unit, 5.0f * unit, 11.0f * unit, 6.0f * unit, 11.0f * unit);
        this.boxRenderer.setScaledExteriorColor(this.baseColor, 0.9375f);
        this.boxRenderer.setScaledExteriorColor(this.baseColor, 0.75f, 1);
        this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, 2.0f * unit, 0.0f * unit, 2.0f * unit, 14.0f * unit, 3.0f * unit, 14.0f * unit);
        TileEntityDecorativePot te = block.getTileEntity(world, x, y, z);
        ItemStack substrateItem = block.getGardenSubstrate(world, x, y, z, 0);
        if (te != null && substrateItem != null && substrateItem.func_77973_b() instanceof ItemBlock) {
            Block substrate = Block.func_149634_a((Item)substrateItem.func_77973_b());
            IIcon substrateIcon = renderer.func_147787_a(substrate, 1, substrateItem.func_77960_j());
            int color = substrate.func_149720_d(world, x, y, z);
            if (color == Blocks.field_150349_c.func_149720_d(world, x, y, z)) {
                color = ColorizerGrass.func_77480_a((double)te.getBiomeTemperature(), (double)te.getBiomeHumidity());
            }
            RenderHelper.calculateBaseColor(this.activeSubstrateColor, color);
            RenderHelper.scaleColor(this.activeSubstrateColor, this.activeSubstrateColor, 0.8f);
            RenderHelper.instance.setRenderBounds(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);
            RenderHelper.instance.renderFace(1, world, (Block)block, x, y, z, substrateIcon, this.activeSubstrateColor[0], this.activeSubstrateColor[1], this.activeSubstrateColor[2]);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.decorativePotRenderID;
    }
}

