/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencommon.integration.mods;

import com.jaquadro.minecraft.gardencommon.integration.IntegrationModule;
import com.jaquadro.minecraft.gardencore.api.GardenCoreAPI;
import com.jaquadro.minecraft.gardencore.api.IBonemealHandler;
import com.jaquadro.minecraft.gardencore.api.IPlantRenderer;
import com.jaquadro.minecraft.gardencore.api.PlantRegistry;
import com.jaquadro.minecraft.gardencore.api.plant.DefaultPlantInfo;
import com.jaquadro.minecraft.gardencore.api.plant.IPlantInfo;
import com.jaquadro.minecraft.gardencore.api.plant.PlantItem;
import com.jaquadro.minecraft.gardencore.api.plant.PlantSize;
import com.jaquadro.minecraft.gardencore.api.plant.PlantType;
import com.jaquadro.minecraft.gardencore.api.plant.SimplePlantInfo;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import com.jaquadro.minecraft.gardencore.client.renderer.plant.DoublePlantRenderer;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Botania
extends IntegrationModule {
    public static final String MOD_ID = "Botania";
    private static Block flower1;
    private static Block flower2;

    @Override
    public String getModID() {
        return MOD_ID;
    }

    @Override
    public void init() throws Throwable {
        flower1 = GameRegistry.findBlock((String)MOD_ID, (String)"doubleFlower1");
        flower2 = GameRegistry.findBlock((String)MOD_ID, (String)"doubleFlower2");
        PlantRegistry plantReg = PlantRegistry.instance();
        DoubleFlowerRenderer doubleFlowerRender = new DoubleFlowerRenderer();
        plantReg.registerPlantRenderer(MOD_ID, "flower", PlantRegistry.CROSSED_SQUARES_RENDERER);
        plantReg.registerPlantRenderer(MOD_ID, "shinyFlower", PlantRegistry.CROSSED_SQUARES_RENDERER);
        plantReg.registerPlantRenderer(MOD_ID, "doubleFlower1", (IPlantRenderer)doubleFlowerRender);
        plantReg.registerPlantRenderer(MOD_ID, "doubleFlower2", (IPlantRenderer)doubleFlowerRender);
        DoubleFlowerPlantInfo doubleFlowerInfo = new DoubleFlowerPlantInfo();
        plantReg.registerPlantInfo(MOD_ID, "doubleFlower1", (IPlantInfo)doubleFlowerInfo);
        plantReg.registerPlantInfo(MOD_ID, "doubleFlower2", (IPlantInfo)doubleFlowerInfo);
        GardenCoreAPI.instance().registerBonemealHandler(new BonemealHandler());
        for (int i : new int[]{2, 3, 6, 9, 15}) {
            plantReg.registerPlantInfo(MOD_ID, "flower", i, new SimplePlantInfo(PlantType.GROUND, PlantSize.SMALL));
            plantReg.registerPlantInfo(MOD_ID, "shinyFlower", i, new SimplePlantInfo(PlantType.GROUND, PlantSize.SMALL));
        }
        for (int i : new int[]{4}) {
            plantReg.registerPlantInfo(MOD_ID, "flower", i, new SimplePlantInfo(PlantType.GROUND, PlantSize.LARGE));
            plantReg.registerPlantInfo(MOD_ID, "shinyFlower", i, new SimplePlantInfo(PlantType.GROUND, PlantSize.LARGE));
        }
        plantReg.registerPlantInfo(MOD_ID, "specialFlower", (IPlantInfo)new SimplePlantInfo(PlantType.INVALID, PlantSize.MEDIUM));
    }

    @Override
    public void postInit() throws Throwable {
    }

    private static class DoubleFlowerRenderer
    extends DoublePlantRenderer {
        private DoubleFlowerRenderer() {
        }

        @Override
        public IIcon getIcon(Block block, IBlockAccess blockAccess, int meta) {
            return block.func_149691_a(0, meta);
        }
    }

    private static class DoubleFlowerPlantInfo
    extends DefaultPlantInfo {
        private DoubleFlowerPlantInfo() {
        }

        @Override
        public int getPlantHeight(Block block, int meta) {
            if (block == flower1 || block == flower2) {
                return 2;
            }
            return 1;
        }

        @Override
        public int getPlantSectionMeta(Block block, int meta, int section) {
            if (block == flower1 || block == flower2) {
                switch (section) {
                    case 2: {
                        return meta & 7;
                    }
                    case 1: {
                        return meta | 8;
                    }
                }
            }
            return meta;
        }
    }

    private static class BonemealHandler
    implements IBonemealHandler {
        private BonemealHandler() {
        }

        @Override
        public boolean applyBonemeal(World world, int x, int y, int z, BlockGarden hostBlock, int slot) {
            TileEntityGarden te = hostBlock.getTileEntity((IBlockAccess)world, x, y, z);
            Block block = hostBlock.getPlantBlockFromSlot((IBlockAccess)world, x, y, z, slot);
            int meta = hostBlock.getPlantMetaFromSlot((IBlockAccess)world, x, y, z, slot);
            Block flower = GameRegistry.findBlock((String)Botania.MOD_ID, (String)"flower");
            if (block == flower) {
                ItemStack upgrade;
                ItemStack itemStack = upgrade = (meta & 8) == 0 ? new ItemStack(flower1, 1, meta) : new ItemStack(flower2, 1, meta & 7);
                if (hostBlock.isPlantValidForSlot(world, x, y, z, slot, PlantItem.getForItem(upgrade))) {
                    te.func_70299_a(slot, upgrade);
                    return true;
                }
            }
            return false;
        }
    }
}

