/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencommon.integration;

import com.jaquadro.minecraft.gardencommon.integration.IntegrationModule;
import com.jaquadro.minecraft.gardencommon.integration.mods.AgriCraft;
import com.jaquadro.minecraft.gardencommon.integration.mods.BiomesOPlenty;
import com.jaquadro.minecraft.gardencommon.integration.mods.Botania;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;

public class IntegrationRegistry {
    private static IntegrationRegistry instance;
    private List<IntegrationModule> registry = new ArrayList<IntegrationModule>();

    private IntegrationRegistry() {
    }

    public static IntegrationRegistry instance() {
        if (instance == null) {
            instance = new IntegrationRegistry();
        }
        return instance;
    }

    public void add(IntegrationModule module) {
        this.registry.add(module);
    }

    public void init() {
        for (int i = 0; i < this.registry.size(); ++i) {
            IntegrationModule module = this.registry.get(i);
            if (module.getModID() != null && !Loader.isModLoaded((String)module.getModID())) {
                this.registry.remove(i--);
                continue;
            }
            try {
                module.init();
                continue;
            }
            catch (Throwable t) {
                this.registry.remove(i--);
                FMLLog.log((String)"GardenStuff", (Level)Level.INFO, (String)("Could not load integration module: " + module.getClass().getName() + " (init)"), (Object[])new Object[0]);
            }
        }
    }

    public void postInit() {
        for (int i = 0; i < this.registry.size(); ++i) {
            IntegrationModule module = this.registry.get(i);
            try {
                module.postInit();
                continue;
            }
            catch (Throwable t) {
                this.registry.remove(i--);
                FMLLog.log((String)"GardenStuff", (Level)Level.INFO, (String)("Could not load integration module: " + module.getClass().getName() + " (post-init)"), (Object[])new Object[0]);
            }
        }
    }

    static {
        IntegrationRegistry reg = IntegrationRegistry.instance();
        if (Loader.isModLoaded((String)"AgriCraft")) {
            reg.add(new AgriCraft());
        }
        if (Loader.isModLoaded((String)"BiomesOPlenty")) {
            reg.add(new BiomesOPlenty());
        }
        if (Loader.isModLoaded((String)"Botania")) {
            reg.add(new Botania());
        }
    }
}

