/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.CoFHCore;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.container.IAugmentableContainer;
import cofh.lib.gui.element.TabBase;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TabAugment
extends TabBase {
    public static boolean enable;
    public static int defaultSide;
    public static int defaultHeaderColor;
    public static int defaultSubHeaderColor;
    public static int defaultTextColor;
    public static int defaultBackgroundColor;
    public static ResourceLocation GRID_TEXTURE;
    IAugmentableContainer myContainer;
    int numAugments = 0;
    int slotsBorderX1 = 18;
    int slotsBorderX2 = this.slotsBorderX1 + 60;
    int slotsBorderY1 = 20;
    int slotsBorderY2 = this.slotsBorderY1 + 42;

    public static void initialize() {
        String string = "Tab.Augment";
        defaultSide = MathHelper.clamp(CoFHCore.configClient.get(string, "Side", defaultSide), 0, 1);
        defaultHeaderColor = MathHelper.clamp(CoFHCore.configClient.get(string, "ColorHeader", defaultHeaderColor), 0, 0xFFFFFF);
        defaultSubHeaderColor = MathHelper.clamp(CoFHCore.configClient.get(string, "ColorSubHeader", defaultSubHeaderColor), 0, 0xFFFFFF);
        defaultTextColor = MathHelper.clamp(CoFHCore.configClient.get(string, "ColorText", defaultTextColor), 0, 0xFFFFFF);
        defaultBackgroundColor = MathHelper.clamp(CoFHCore.configClient.get(string, "ColorBackground", defaultBackgroundColor), 0, 0xFFFFFF);
        CoFHCore.configClient.save();
    }

    public TabAugment(GuiBase guiBase, IAugmentableContainer iAugmentableContainer) {
        this(guiBase, defaultSide, iAugmentableContainer);
    }

    public TabAugment(GuiBase guiBase, int n, IAugmentableContainer iAugmentableContainer) {
        super(guiBase, n);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.myContainer = iAugmentableContainer;
        this.numAugments = this.myContainer.getAugmentSlots().length;
        for (int i = 0; i < this.numAugments; ++i) {
            this.myContainer.getAugmentSlots()[i].field_75223_e = -guiBase.getGuiLeft() - 16;
            this.myContainer.getAugmentSlots()[i].field_75221_f = -guiBase.getGuiTop() - 16;
        }
        this.myContainer.setAugmentLock(true);
        switch (this.numAugments) {
            case 4: {
                this.slotsBorderX1 += 9;
            }
            case 5: 
            case 6: {
                break;
            }
            default: {
                this.slotsBorderX1 += 9 * (3 - this.numAugments);
                this.slotsBorderX2 = this.slotsBorderX1 + 18 * this.numAugments + 6;
                this.slotsBorderY1 += 9;
                this.slotsBorderY2 -= 9;
            }
        }
        this.myContainer.setAugmentLock(true);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize("info.cofh.augmentation"));
        }
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (this.side == 0) {
            n += this.currentWidth;
        }
        return (n -= this.currentShiftX) >= this.slotsBorderX1 + this.sideOffset() && n < this.slotsBorderX2 + this.sideOffset() && (n2 -= this.currentShiftY) >= this.slotsBorderY1 && n2 < this.slotsBorderY2;
    }

    @Override
    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float f = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float f2 = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float f3 = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GL11.glColor4f((float)f, (float)f2, (float)f3, (float)1.0f);
        if (this.numAugments > 3) {
            this.gui.func_73729_b(this.posXOffset() + this.slotsBorderX1, this.posY + this.slotsBorderY1, 16, 20, (this.numAugments > 4 ? 54 : 36) + 6, 42);
        } else {
            this.gui.func_73729_b(this.posXOffset() + this.slotsBorderX1, this.posY + this.slotsBorderY1, 16, 20, 18 * this.numAugments + 6, 24);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.bindTexture(GRID_TEXTURE);
        switch (this.numAugments) {
            case 4: {
                this.drawSlots(0, 0, 2);
                this.drawSlots(0, 1, 2);
                break;
            }
            case 5: {
                this.drawSlots(0, 0, 3);
                this.drawSlots(1, 1, 2);
                break;
            }
            case 6: {
                this.drawSlots(0, 0, 3);
                this.drawSlots(0, 1, 3);
                break;
            }
            default: {
                this.drawSlots(0, 0, this.numAugments);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void drawForeground() {
        this.drawTabIcon("IconAugment");
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_78261_a(StringHelper.localize("info.cofh.augmentation"), this.posXOffset() + 18, this.posY + 6, this.headerColor);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void setFullyOpen() {
        super.setFullyOpen();
        switch (this.numAugments) {
            case 4: {
                for (int i = 0; i < this.numAugments; ++i) {
                    this.myContainer.getAugmentSlots()[i].field_75223_e = this.posXOffset() + this.slotsBorderX1 + 4 + 18 * (i % 2);
                    this.myContainer.getAugmentSlots()[i].field_75221_f = this.posY + this.slotsBorderY1 + 4 + 18 * (i / 2);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.numAugments; ++i) {
                    this.myContainer.getAugmentSlots()[i].field_75223_e = this.posXOffset() + this.slotsBorderX1 + 4 + 18 * (i % 3) + 9 * (i / 3);
                    this.myContainer.getAugmentSlots()[i].field_75221_f = this.posY + this.slotsBorderY1 + 4 + 18 * (i / 3);
                }
                break;
            }
            default: {
                for (int i = 0; i < this.numAugments; ++i) {
                    this.myContainer.getAugmentSlots()[i].field_75223_e = this.posXOffset() + this.slotsBorderX1 + 4 + 18 * (i % 3);
                    this.myContainer.getAugmentSlots()[i].field_75221_f = this.posY + this.slotsBorderY1 + 4 + 18 * (i / 3);
                }
            }
        }
        this.myContainer.setAugmentLock(false);
    }

    @Override
    public void toggleOpen() {
        if (this.open) {
            for (int i = 0; i < this.numAugments; ++i) {
                this.myContainer.getAugmentSlots()[i].field_75223_e = -this.gui.getGuiLeft() - 16;
                this.myContainer.getAugmentSlots()[i].field_75221_f = -this.gui.getGuiTop() - 16;
            }
            this.myContainer.setAugmentLock(true);
        }
        super.toggleOpen();
    }

    private void drawSlots(int n, int n2, int n3) {
        this.gui.drawSizedTexturedModalRect(this.posXOffset() + this.slotsBorderX1 + 3 + 9 * n, this.posY + this.slotsBorderY1 + 3 + 18 * n2, 0, 0, 18 * n3, 18, 96.0f, 32.0f);
    }

    static {
        defaultSide = 1;
        defaultHeaderColor = 14797103;
        defaultSubHeaderColor = 11186104;
        defaultTextColor = 0;
        defaultBackgroundColor = 564812;
        GRID_TEXTURE = new ResourceLocation("cofh:textures/gui/elements/Slot_Grid_Augment.png");
    }
}

