/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.asm.CoFHAccessTransformer;
import cofh.asm.CoFHClassTransformer;
import cofh.mod.ChildMod;
import cofh.mod.ChildModContainer;
import cofh.repack.codechicken.lib.asm.ASMInit;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModContainerFactory;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.Side;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.Type;

@IFMLLoadingPlugin.TransformerExclusions(value={"cofh.asm."})
@IFMLLoadingPlugin.SortingIndex(value=1001)
public class LoadingPlugin
implements IFMLLoadingPlugin {
    public static final String MC_VERSION = "[1.7.10]";
    public static ArrayList<String> transformersList = new ArrayList();
    public static boolean runtimeDeobfEnabled = false;
    public static ASMDataTable ASM_DATA = null;
    public static LaunchClassLoader loader = null;
    public static final String currentMcVersion;
    public static final File minecraftDir;
    public static final boolean obfuscated;
    public File myLocation;

    public static void versionCheck(String string, String string2) {
        String string3 = currentMcVersion;
        if (!VersionParser.parseRange((String)string).containsVersion((ArtifactVersion)new DefaultArtifactVersion(string3))) {
            String string4 = "This version of " + string2 + " does not support Minecraft version " + string3;
            System.err.println(string4);
            JEditorPane jEditorPane = new JEditorPane("text/html", "<html>" + string4 + "<br>Remove it from your mods folder and check <a href=\"http://teamcofh.com/\">here</a> for updates" + "</html>");
            jEditorPane.setEditable(false);
            jEditorPane.setOpaque(false);
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    try {
                        if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(hyperlinkEvent.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, jEditorPane, "Fatal error", 0);
            System.exit(1);
        }
        if (obfuscated && System.getProperty("java.specification.version").compareTo("1.8") < 0) {
            if (FMLLaunchHandler.side() == Side.SERVER) {
                FMLLog.log((Level)Level.WARN, (String)"*************************************************************************", (Object[])new Object[0]);
                for (int i = 0; i < 5; ++i) {
                    FMLLog.log((Level)Level.WARN, (String)"*************************************************************************", (Object[])new Object[0]);
                    FMLLog.log((Level)Level.WARN, (String)"* You are using an old Java version, and should update to 1.8 or newer. *", (Object[])new Object[0]);
                    FMLLog.log((Level)Level.WARN, (String)"*************************************************************************", (Object[])new Object[0]);
                }
                FMLLog.log((Level)Level.WARN, (String)"*************************************************************************", (Object[])new Object[0]);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPane jEditorPane = new JEditorPane("text/html", "<html>You are using an old Java version, and should update to 1.8 or newer.</html>");
                        jEditorPane.setEditable(false);
                        jEditorPane.setOpaque(false);
                        JFrame jFrame = new JFrame();
                        jFrame.setFocusable(false);
                        jFrame.setUndecorated(true);
                        jFrame.setAlwaysOnTop(true);
                        Rectangle rectangle = jFrame.getRootPane().getGraphicsConfiguration().getBounds();
                        jFrame.setLocation((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
                        jFrame.setTitle("Warning");
                        jFrame.setVisible(true);
                        JOptionPane.showMessageDialog(jFrame, jEditorPane, "Warning", 2);
                        jFrame.setVisible(false);
                    }
                }, "Message Thread").start();
            }
        }
    }

    public static void attemptClassLoad(String string, String string2) {
        try {
            Class.forName(string, false, LoadingPlugin.class.getClassLoader());
            transformersList.add(string);
        }
        catch (Throwable throwable) {
            FMLLog.warning((String)string2, (Object[])new Object[0]);
        }
    }

    public String getAccessTransformerClass() {
        return CoFHAccessTransformer.class.getName();
    }

    public String[] getASMTransformerClass() {
        return transformersList.toArray(new String[1]);
    }

    public String getModContainerClass() {
        return CoFHDummyContainer.class.getName();
    }

    public String getSetupClass() {
        return CoFHDummyContainer.class.getName();
    }

    public void injectData(Map<String, Object> map) {
        runtimeDeobfEnabled = (Boolean)map.get("runtimeDeobfuscationEnabled");
        if (map.containsKey("coremodLocation")) {
            this.myLocation = (File)map.get("coremodLocation");
        }
    }

    static {
        boolean bl = true;
        try {
            bl = Launch.classLoader.getClassBytes("net.minecraft.world.World") == null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        obfuscated = bl;
        if (!obfuscated) {
            try {
                CoFHAccessTransformer.initForDeobf();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        currentMcVersion = (String)FMLInjectionData.data()[4];
        LoadingPlugin.versionCheck(MC_VERSION, "CoFHCore");
        minecraftDir = (File)FMLInjectionData.data()[6];
        loader = Launch.classLoader;
        LoadingPlugin.attemptClassLoad("cofh.asm.CoFHClassTransformer", "Failed to find Class Transformer! Critical Issue!");
        ASMInit.init();
    }

    public static class CoFHDummyContainer
    extends DummyModContainer
    implements IFMLCallHook {
        public CoFHDummyContainer() {
            super(new ModMetadata());
            ModMetadata modMetadata = this.getMetadata();
            modMetadata.autogenerated = true;
            modMetadata.modId = "<CoFH ASM>";
            modMetadata.description = "CoFH ASM";
            modMetadata.name = "CoFH ASM";
            modMetadata.parent = "CoFHCore";
            modMetadata.version = "000";
        }

        public boolean registerBus(EventBus eventBus, LoadController loadController) {
            eventBus.register((Object)this);
            return true;
        }

        @Subscribe
        public void construction(FMLConstructionEvent fMLConstructionEvent) {
            ASM_DATA = fMLConstructionEvent.getASMHarvestedData();
            CoFHClassTransformer.scrapeData(ASM_DATA);
        }

        public void injectData(Map<String, Object> map) {
            loader = (LaunchClassLoader)map.get("classLoader");
        }

        public Void call() throws Exception {
            this.scanMods();
            ModContainerFactory.instance().registerContainerType(Type.getType(ChildMod.class), ChildModContainer.class);
            return null;
        }

        private void scanMods() {
            File file = new File(minecraftDir, "mods");
            for (File file2 : file.listFiles()) {
                this.scanMod(file2);
            }
            File file3 = new File(minecraftDir, "mods/" + currentMcVersion);
            if (file3.exists()) {
                for (File file4 : file3.listFiles()) {
                    this.scanMod(file4);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanMod(File file) {
            Object object = file.getName().toLowerCase();
            if (file.isDirectory() || !((String)object).endsWith(".jar") && !((String)object).endsWith(".zip")) {
                return;
            }
            try {
                object = new JarFile(file);
                try {
                    Manifest manifest = ((JarFile)object).getManifest();
                    if (manifest == null) {
                    } else {
                        Attributes attributes = manifest.getMainAttributes();
                        if (attributes == null) {
                        } else {
                            String string = attributes.getValue("CoFHAT");
                            if (string != null) {
                                for (String string2 : string.split(" ")) {
                                    ZipEntry zipEntry = ((JarFile)object).getEntry("META-INF/" + string2);
                                    if (zipEntry == null) continue;
                                    FMLLog.log((String)"CoFHASM", (Level)Level.DEBUG, (String)("Adding CoFHAT: " + string2 + " from: " + file.getName()), (Object[])new Object[0]);
                                    CoFHAccessTransformer.processATFile(new InputStreamReader(((JarFile)object).getInputStream(zipEntry)));
                                }
                            }
                        }
                    }
                }
                finally {
                    ((ZipFile)object).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

