/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.data.IAEStack;
import appeng.me.storage.MEInventoryHandler;
import net.minecraft.item.ItemStack;

public class DriveWatcher<T extends IAEStack<T>>
extends MEInventoryHandler<T> {
    final int oldStatus = 0;
    final ItemStack is;
    final ICellHandler handler;
    final IChestOrDrive cord;

    public DriveWatcher(IMEInventory<T> i, ItemStack is, ICellHandler han, IChestOrDrive cod) {
        super(i, i.getChannel());
        this.is = is;
        this.handler = han;
        this.cord = cod;
    }

    @Override
    public T injectItems(T input, Actionable type, BaseActionSource src) {
        int newStatus;
        long size = input.getStackSize();
        T a = super.injectItems(input, type, src);
        if ((a == null || a.getStackSize() != size) && (newStatus = this.handler.getStatusForCell(this.is, this.getInternal())) != this.oldStatus) {
            this.cord.blinkCell(this.getSlot());
        }
        return a;
    }

    @Override
    public T extractItems(T request, Actionable type, BaseActionSource src) {
        int newStatus;
        T a = super.extractItems(request, type, src);
        if (a != null && (newStatus = this.handler.getStatusForCell(this.is, this.getInternal())) != this.oldStatus) {
            this.cord.blinkCell(this.getSlot());
        }
        return a;
    }
}

