/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.util.AEColor;
import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseItemBlock;
import appeng.block.networking.BlockCableBus;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BlockRenderInfo;
import appeng.client.render.WorldRender;
import appeng.client.texture.FlippableIcon;
import appeng.client.texture.MissingIcon;
import appeng.core.features.AEBlockFeatureHandler;
import appeng.core.features.AEFeature;
import appeng.core.features.FeatureNameExtractor;
import appeng.core.features.IAEFeature;
import appeng.core.features.IFeatureHandler;
import appeng.core.features.ItemStackSrc;
import appeng.helpers.AEGlassMaterial;
import appeng.helpers.ICustomCollision;
import appeng.tile.AEBaseTile;
import appeng.tile.networking.TileCableBus;
import appeng.tile.storage.TileSkyChest;
import appeng.util.LookDirection;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IResource;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AEBaseBlock
extends BlockContainer
implements IAEFeature {
    private final String featureFullName;
    private final Optional<String> featureSubName;
    @SideOnly(value=Side.CLIENT)
    public IIcon renderIcon;
    protected boolean isOpaque = true;
    protected boolean isFullSize = true;
    protected boolean hasSubtypes = false;
    protected boolean isInventory = false;
    @SideOnly(value=Side.CLIENT)
    BlockRenderInfo renderInfo;
    private IFeatureHandler handler;
    @Nullable
    private Class<? extends TileEntity> tileEntityType = null;

    protected AEBaseBlock(Class<? extends AEBaseBlock> c, Material mat) {
        this(c, mat, (Optional<String>)Optional.absent());
        this.func_149713_g(255);
        this.func_149715_a(0.0f);
        this.func_149711_c(2.2f);
        this.setTileProvider(false);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected AEBaseBlock(Class<?> c, Material mat, Optional<String> subName) {
        super(mat);
        if (mat == AEGlassMaterial.INSTANCE || mat == Material.field_151592_s) {
            this.func_149672_a(Block.field_149778_k);
        } else if (mat == Material.field_151576_e) {
            this.func_149672_a(Block.field_149769_e);
        } else if (mat == Material.field_151575_d) {
            this.func_149672_a(Block.field_149766_f);
        } else {
            this.func_149672_a(Block.field_149777_j);
        }
        this.featureFullName = new FeatureNameExtractor(c, subName).get();
        this.featureSubName = subName;
    }

    private void setTileProvider(boolean b) {
        ReflectionHelper.setPrivateValue(Block.class, (Object)this, (Object)b, (String[])new String[]{"isTileProvider"});
    }

    public String toString() {
        return this.featureFullName;
    }

    public void registerNoIcons() {
        BlockRenderInfo info = this.getRendererInstance();
        FlippableIcon i = new FlippableIcon(new MissingIcon(this));
        info.updateIcons(i, i, i, i, i, i);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderInfo getRendererInstance() {
        if (this.renderInfo != null) {
            return this.renderInfo;
        }
        try {
            BaseBlockRender renderer = this.getRenderer().newInstance();
            this.renderInfo = new BlockRenderInfo(renderer);
            return this.renderInfo;
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to create a new instance of an illegal class " + this.getRenderer(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to create a new instance of " + this.getRenderer() + " because of permissions.", e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected Class<? extends BaseBlockRender> getRenderer() {
        return BaseBlockRender.class;
    }

    public IIcon unmappedGetIcon(IBlockAccess w, int x, int y, int z, int s) {
        return super.func_149673_e(w, x, y, z, s);
    }

    protected void setTileEntity(Class<? extends TileEntity> c) {
        this.tileEntityType = c;
        AEBaseTile.registerTileItem(c, new ItemStackSrc((Block)this, 0));
        GameRegistry.registerTileEntity(this.tileEntityType, (String)this.featureFullName);
        this.isInventory = IInventory.class.isAssignableFrom(c);
        this.setTileProvider(this.hasBlockTileEntity());
    }

    public boolean hasBlockTileEntity() {
        return this.tileEntityType != null;
    }

    protected void setFeature(EnumSet<AEFeature> f) {
        this.handler = new AEBlockFeatureHandler(f, this, this.featureSubName);
    }

    @Override
    public final IFeatureHandler handler() {
        return this.handler;
    }

    @Override
    public void postInit() {
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public boolean func_149686_d() {
        return this.isFullSize && this.isOpaque;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return WorldRender.INSTANCE.getRenderId();
    }

    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int s) {
        return this.func_149691_a(this.mapRotation(w, x, y, z, s), w.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int direction, int metadata) {
        if (this.renderIcon != null) {
            return this.renderIcon;
        }
        return this.getRendererInstance().getTexture(ForgeDirection.getOrientation((int)direction));
    }

    public void func_149743_a(World w, int x, int y, int z, AxisAlignedBB bb, List out, Entity e) {
        ICustomCollision collisionHandler = null;
        if (this instanceof ICustomCollision) {
            collisionHandler = (ICustomCollision)((Object)this);
        } else {
            AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
            if (te instanceof ICustomCollision) {
                collisionHandler = (ICustomCollision)((Object)te);
            }
        }
        if (collisionHandler != null && bb != null) {
            ArrayList<AxisAlignedBB> tmp = new ArrayList<AxisAlignedBB>();
            collisionHandler.addCollidingBlockToList(w, x, y, z, bb, tmp, e);
            for (AxisAlignedBB b : tmp) {
                b.field_72340_a += (double)x;
                b.field_72338_b += (double)y;
                b.field_72339_c += (double)z;
                b.field_72336_d += (double)x;
                b.field_72337_e += (double)y;
                b.field_72334_f += (double)z;
                if (!bb.func_72326_a(b)) continue;
                out.add(b);
            }
        } else {
            super.func_149743_a(w, x, y, z, bb, out, e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final AxisAlignedBB func_149633_g(World w, int x, int y, int z) {
        ICustomCollision collisionHandler = null;
        AxisAlignedBB b = null;
        if (this instanceof ICustomCollision) {
            collisionHandler = (ICustomCollision)((Object)this);
        } else {
            AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
            if (te instanceof ICustomCollision) {
                collisionHandler = (ICustomCollision)((Object)te);
            }
        }
        if (collisionHandler != null) {
            if (Platform.isClient()) {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                LookDirection ld = Platform.getPlayerRay((EntityPlayer)player, Platform.getEyeOffset((EntityPlayer)player));
                Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, (Entity)Minecraft.func_71410_x().field_71439_g, true);
                AxisAlignedBB br = null;
                double lastDist = 0.0;
                for (AxisAlignedBB bb : bbs) {
                    this.func_149676_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
                    MovingObjectPosition r = super.func_149731_a(w, x, y, z, ld.a, ld.b);
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    if (r == null) continue;
                    double xLen = ld.a.field_72450_a - r.field_72307_f.field_72450_a;
                    double yLen = ld.a.field_72448_b - r.field_72307_f.field_72448_b;
                    double zLen = ld.a.field_72449_c - r.field_72307_f.field_72449_c;
                    double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                    if (br != null && !(lastDist > thisDist)) continue;
                    lastDist = thisDist;
                    br = bb;
                }
                if (br != null) {
                    br.func_72324_b(br.field_72340_a + (double)x, br.field_72338_b + (double)y, br.field_72339_c + (double)z, br.field_72336_d + (double)x, br.field_72337_e + (double)y, br.field_72334_f + (double)z);
                    return br;
                }
            }
            for (AxisAlignedBB bx : collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, null, false)) {
                if (b == null) {
                    b = bx;
                    continue;
                }
                double minX = Math.min(b.field_72340_a, bx.field_72340_a);
                double minY = Math.min(b.field_72338_b, bx.field_72338_b);
                double minZ = Math.min(b.field_72339_c, bx.field_72339_c);
                double maxX = Math.max(b.field_72336_d, bx.field_72336_d);
                double maxY = Math.max(b.field_72337_e, bx.field_72337_e);
                double maxZ = Math.max(b.field_72334_f, bx.field_72334_f);
                b.func_72324_b(minX, minY, minZ, maxX, maxY, maxZ);
            }
            b.func_72324_b(b.field_72340_a + (double)x, b.field_72338_b + (double)y, b.field_72339_c + (double)z, b.field_72336_d + (double)x, b.field_72337_e + (double)y, b.field_72334_f + (double)z);
        } else {
            b = super.func_149633_g(w, x, y, z);
        }
        return b;
    }

    public final boolean func_149662_c() {
        return this.isOpaque;
    }

    public MovingObjectPosition func_149731_a(World w, int x, int y, int z, Vec3 a, Vec3 b) {
        ICustomCollision collisionHandler = null;
        if (this instanceof ICustomCollision) {
            collisionHandler = (ICustomCollision)((Object)this);
        } else {
            AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
            if (te instanceof ICustomCollision) {
                collisionHandler = (ICustomCollision)((Object)te);
            }
        }
        if (collisionHandler != null) {
            Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, null, true);
            MovingObjectPosition br = null;
            double lastDist = 0.0;
            for (AxisAlignedBB bb : bbs) {
                this.func_149676_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
                MovingObjectPosition r = super.func_149731_a(w, x, y, z, a, b);
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                if (r == null) continue;
                double xLen = a.field_72450_a - r.field_72307_f.field_72450_a;
                double yLen = a.field_72448_b - r.field_72307_f.field_72448_b;
                double zLen = a.field_72449_c - r.field_72307_f.field_72449_c;
                double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                if (br != null && !(lastDist > thisDist)) continue;
                lastDist = thisDist;
                br = r;
            }
            if (br != null) {
                return br;
            }
            return null;
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.func_149731_a(w, x, y, z, a, b);
    }

    public final boolean func_149727_a(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack is;
        if (player != null && (is = player.field_71071_by.func_70448_g()) != null) {
            if (Platform.isWrench(player, is, x, y, z) && player.func_70093_af()) {
                Block id = w.func_147439_a(x, y, z);
                if (id != null) {
                    AEBaseTile tile = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
                    Object[] drops = Platform.getBlockDrops(w, x, y, z);
                    if (tile == null) {
                        return false;
                    }
                    if (tile instanceof TileCableBus || tile instanceof TileSkyChest) {
                        return false;
                    }
                    ItemStack op = new ItemStack((Block)this);
                    for (ItemStack itemStack : drops) {
                        NBTTagCompound tag;
                        if (!Platform.isSameItemType(itemStack, op) || (tag = tile.downloadSettings(SettingsFrom.DISMANTLE_ITEM)) == null) continue;
                        itemStack.func_77982_d(tag);
                    }
                    if (id.removedByPlayer(w, player, x, y, z, false)) {
                        ArrayList l = Lists.newArrayList((Object[])drops);
                        Platform.spawnDrops(w, x, y, z, l);
                        w.func_147468_f(x, y, z);
                    }
                }
                return false;
            }
            if (is.func_77973_b() instanceof IMemoryCard && !(this instanceof BlockCableBus)) {
                IMemoryCard memoryCard = (IMemoryCard)is.func_77973_b();
                if (player.func_70093_af()) {
                    AEBaseTile t = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
                    if (t != null) {
                        String name = this.func_149739_a();
                        NBTTagCompound data = t.downloadSettings(SettingsFrom.MEMORY_CARD);
                        if (data != null) {
                            memoryCard.setMemoryCardContents(is, name, data);
                            memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                            return true;
                        }
                    }
                } else {
                    String name = memoryCard.getSettingsName(is);
                    NBTTagCompound data = memoryCard.getData(is);
                    if (this.func_149739_a().equals(name)) {
                        AEBaseTile t = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
                        t.uploadSettings(SettingsFrom.MEMORY_CARD, data);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                    } else {
                        memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                    }
                    return false;
                }
            }
        }
        return this.onActivated(w, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public boolean onActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase player, ItemStack is) {
        Object te;
        if (is.func_82837_s() && (te = this.getTileEntity((IBlockAccess)w, x, y, z)) instanceof AEBaseTile) {
            ((AEBaseTile)w.func_147438_o(x, y, z)).setName(is.func_82833_r());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149666_a(Item item, CreativeTabs tabs, List itemStacks) {
        this.getCheckedSubBlocks(item, tabs, itemStacks);
    }

    public boolean func_149740_M() {
        return this.isInventory;
    }

    public int func_149736_g(World w, int x, int y, int z, int s) {
        Object te = this.getTileEntity((IBlockAccess)w, x, y, z);
        if (te instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)te));
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegistry) {
        BlockRenderInfo info = this.getRendererInstance();
        FlippableIcon topIcon = this.optionalIcon(iconRegistry, this.func_149641_N(), null);
        this.field_149761_L = topIcon;
        FlippableIcon bottomIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "Bottom", topIcon);
        FlippableIcon sideIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "Side", topIcon);
        FlippableIcon eastIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "East", sideIcon);
        FlippableIcon westIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "West", sideIcon);
        FlippableIcon southIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "Front", sideIcon);
        FlippableIcon northIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "Back", sideIcon);
        info.updateIcons(bottomIcon, topIcon, northIcon, southIcon, eastIcon, westIcon);
    }

    public final boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return this.isFullSize;
    }

    public final boolean rotateBlock(World w, int x, int y, int z, ForgeDirection axis) {
        IOrientable rotatable = null;
        if (this.hasBlockTileEntity()) {
            rotatable = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        } else if (this instanceof IOrientableBlock) {
            rotatable = ((IOrientableBlock)((Object)this)).getOrientable((IBlockAccess)w, x, y, z);
        }
        if (rotatable != null && rotatable.canBeRotated()) {
            if (this.hasCustomRotation()) {
                this.customRotateBlock(rotatable, axis);
                return true;
            }
            ForgeDirection forward = rotatable.getForward();
            ForgeDirection up = rotatable.getUp();
            for (int rs = 0; rs < 4; ++rs) {
                if (!this.isValidOrientation(w, x, y, z, forward = Platform.rotateAround(forward, axis), up = Platform.rotateAround(up, axis))) continue;
                rotatable.setOrientation(forward, up);
                return true;
            }
        }
        return super.rotateBlock(w, x, y, z, axis);
    }

    protected boolean hasCustomRotation() {
        return false;
    }

    protected void customRotateBlock(IOrientable rotatable, ForgeDirection axis) {
    }

    public boolean isValidOrientation(World w, int x, int y, int z, ForgeDirection forward, ForgeDirection up) {
        return true;
    }

    public final ForgeDirection[] getValidRotations(World w, int x, int y, int z) {
        AEBaseTile obj;
        if (this.hasBlockTileEntity() && (obj = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z)) != null && obj.canBeRotated()) {
            return ForgeDirection.VALID_DIRECTIONS;
        }
        return new ForgeDirection[0];
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        Object te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te instanceof IColorableTile) {
            AEColor newColor;
            IColorableTile ct = (IColorableTile)te;
            AEColor c = ct.getColor();
            if (c != (newColor = AEColor.values()[colour])) {
                ct.recolourBlock(side, newColor, null);
                return true;
            }
            return false;
        }
        return super.recolourBlock(world, x, y, z, side, colour);
    }

    @SideOnly(value=Side.CLIENT)
    private FlippableIcon optionalIcon(IIconRegister ir, String Name, IIcon substitute) {
        while (substitute instanceof FlippableIcon) {
            substitute = ((FlippableIcon)substitute).getOriginal();
        }
        if (substitute != null) {
            try {
                ResourceLocation resLoc = new ResourceLocation(Name);
                resLoc = new ResourceLocation(resLoc.func_110624_b(), String.format("%s/%s%s", "textures/blocks", resLoc.func_110623_a(), ".png"));
                IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resLoc);
                if (res != null) {
                    return new FlippableIcon(ir.func_94245_a(Name));
                }
            }
            catch (Throwable e) {
                return new FlippableIcon(substitute);
            }
        }
        return new FlippableIcon(ir.func_94245_a(Name));
    }

    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        super.func_149666_a(item, tabs, itemStacks);
    }

    int mapRotation(IBlockAccess w, int x, int y, int z, int s) {
        IOrientable ori = null;
        if (this.hasBlockTileEntity()) {
            ori = (AEBaseTile)this.getTileEntity(w, x, y, z);
        } else if (this instanceof IOrientableBlock) {
            ori = ((IOrientableBlock)((Object)this)).getOrientable(w, x, y, z);
        }
        if (ori != null && ori.canBeRotated()) {
            return this.mapRotation(ori, ForgeDirection.getOrientation((int)s)).ordinal();
        }
        return s;
    }

    @Nullable
    public <T extends TileEntity> T getTileEntity(IBlockAccess w, int x, int y, int z) {
        if (!this.hasBlockTileEntity()) {
            return null;
        }
        TileEntity te = w.func_147438_o(x, y, z);
        if (this.tileEntityType.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    public ForgeDirection mapRotation(IOrientable ori, ForgeDirection dir) {
        ForgeDirection forward = ori.getForward();
        ForgeDirection up = ori.getUp();
        ForgeDirection west = ForgeDirection.UNKNOWN;
        if (forward == null || up == null) {
            return dir;
        }
        int west_x = forward.offsetY * up.offsetZ - forward.offsetZ * up.offsetY;
        int west_y = forward.offsetZ * up.offsetX - forward.offsetX * up.offsetZ;
        int west_z = forward.offsetX * up.offsetY - forward.offsetY * up.offsetX;
        for (ForgeDirection dx : ForgeDirection.VALID_DIRECTIONS) {
            if (dx.offsetX != west_x || dx.offsetY != west_y || dx.offsetZ != west_z) continue;
            west = dx;
        }
        if (dir == forward) {
            return ForgeDirection.SOUTH;
        }
        if (dir == forward.getOpposite()) {
            return ForgeDirection.NORTH;
        }
        if (dir == up) {
            return ForgeDirection.UP;
        }
        if (dir == up.getOpposite()) {
            return ForgeDirection.DOWN;
        }
        if (dir == west) {
            return ForgeDirection.WEST;
        }
        if (dir == west.getOpposite()) {
            return ForgeDirection.EAST;
        }
        return ForgeDirection.UNKNOWN;
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return this.tileEntityType;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRenderStateByMeta(int itemDamage) {
    }

    public final TileEntity func_149915_a(World var1, int var2) {
        if (this.hasBlockTileEntity()) {
            try {
                return this.tileEntityType.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Failed to create a new instance of an illegal class " + this.tileEntityType, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to create a new instance of " + this.tileEntityType + ", because lack of permissions", e);
            }
        }
        return null;
    }

    public void func_149749_a(World w, int x, int y, int z, Block a, int b) {
        AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (te != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (te.dropItems()) {
                te.getDrops(w, x, y, z, drops);
            } else {
                te.getNoDrops(w, x, y, z, drops);
            }
            Platform.spawnDrops(w, x, y, z, drops);
        }
        super.func_149749_a(w, x, y, z, a, b);
        if (te != null) {
            w.func_147455_a(x, y, z, null);
        }
    }

    public String getUnlocalizedName(ItemStack is) {
        return this.func_149739_a();
    }

    public void addInformation(ItemStack is, EntityPlayer player, List<String> lines, boolean advancedItemTooltips) {
    }

    public Class<? extends AEBaseItemBlock> getItemBlockClass() {
        return AEBaseItemBlock.class;
    }

    public boolean hasSubtypes() {
        return this.hasSubtypes;
    }
}

