/*
 * Decompiled with CFR 0.152.
 */
package myrathi.flatsigns.util;

import java.io.File;
import myrathi.flatsigns.FlatSigns;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class Config {
    private static final Config _instance = new Config();
    protected Configuration _cfg;
    protected boolean _recipeSpongeBottles = true;
    protected boolean _recipeSpongeBucket = true;

    private Config() {
    }

    public static boolean allowRecipeSpongeBottles() {
        return Config._instance._recipeSpongeBottles;
    }

    public static boolean allowRecipeSpongeBucket() {
        return Config._instance._recipeSpongeBucket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(File configFile) {
        String cfgPath;
        Configuration cfg = Config._instance._cfg = new Configuration(configFile);
        boolean hasEntries = false;
        try {
            cfg.load();
            Property prop = cfg.get("recipes_sponge", "enableWaterBucket", Config._instance._recipeSpongeBucket);
            hasEntries |= prop.wasRead();
            Config._instance._recipeSpongeBucket = prop.getBoolean(Config._instance._recipeSpongeBucket);
            prop = cfg.get("recipes_sponge", "enableWaterBottles", Config._instance._recipeSpongeBottles);
            hasEntries |= prop.wasRead();
            Config._instance._recipeSpongeBottles = prop.getBoolean(Config._instance._recipeSpongeBottles);
        }
        catch (Exception e) {
            try {
                FlatSigns.log.log(Level.ERROR, e, "Unable to load configuration file!", new Object[0]);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                String cfgPath2;
                try {
                    cfgPath2 = configFile.getCanonicalPath();
                }
                catch (Exception e2) {
                    cfgPath2 = configFile.getAbsolutePath();
                }
                if (cfg.hasChanged()) {
                    cfg.save();
                }
                String chgType = cfg.hasChanged() ? (hasEntries ? "updated" : "created") : "loaded from";
                FlatSigns.log.info("Config %s: %s", chgType, cfgPath2);
                throw throwable;
            }
        }
        try {
            cfgPath = configFile.getCanonicalPath();
        }
        catch (Exception e) {
            cfgPath = configFile.getAbsolutePath();
        }
        if (cfg.hasChanged()) {
            cfg.save();
        }
        String chgType = cfg.hasChanged() ? (hasEntries ? "updated" : "created") : "loaded from";
        FlatSigns.log.info("Config %s: %s", chgType, cfgPath);
    }
}

