import mods.hitwithaxe.Chopping;
import crafttweaker.item.IItemStack;
import mods.gregtech.recipe.RecipeMap;

//Oak
Chopping.addRecipe("minecraft:log", 0, "hitwithaxe:debarked_oak", 1, <hitwithaxe:bark:15>); //Y Axis
Chopping.addRecipe("minecraft:log", 4, "hitwithaxe:debarked_oak", 0, <hitwithaxe:bark:15>); //X Axis
Chopping.addRecipe("minecraft:log", 8, "hitwithaxe:debarked_oak", 2, <hitwithaxe:bark:15>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_oak", 32767, <minecraft:planks>);

//Birch
Chopping.addRecipe("minecraft:log", 2, "hitwithaxe:debarked_birch", 1, <hitwithaxe:bark:2>); //Y Axis
Chopping.addRecipe("minecraft:log", 6, "hitwithaxe:debarked_birch", 0, <hitwithaxe:bark:2>); //X Axis
Chopping.addRecipe("minecraft:log", 10, "hitwithaxe:debarked_birch", 2, <hitwithaxe:bark:2>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_birch", 32767, <minecraft:planks:2>);

//Spruce
Chopping.addRecipe("minecraft:log", 1, "hitwithaxe:debarked_spruce", 1, <hitwithaxe:bark:20>); //Y Axis
Chopping.addRecipe("minecraft:log", 5, "hitwithaxe:debarked_spruce", 0, <hitwithaxe:bark:20>); //X Axis
Chopping.addRecipe("minecraft:log", 9, "hitwithaxe:debarked_spruce", 2, <hitwithaxe:bark:20>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_spruce", 32767, <minecraft:planks:1>);

//Jungle
Chopping.addRecipe("minecraft:log", 3, "hitwithaxe:debarked_jungle", 1, <hitwithaxe:bark:12>); //Y Axis
Chopping.addRecipe("minecraft:log", 7, "hitwithaxe:debarked_jungle", 0, <hitwithaxe:bark:12>); //X Axis
Chopping.addRecipe("minecraft:log", 11, "hitwithaxe:debarked_jungle", 2, <hitwithaxe:bark:12>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_jungle", 32767, <minecraft:planks:3>);

//Dark Oak
Chopping.addRecipe("minecraft:log2", 1, "hitwithaxe:debarked_dark_oak", 1, <hitwithaxe:bark:8>); //Y Axis
Chopping.addRecipe("minecraft:log2", 5, "hitwithaxe:debarked_dark_oak", 0, <hitwithaxe:bark:8>); //X Axis
Chopping.addRecipe("minecraft:log2", 9, "hitwithaxe:debarked_dark_oak", 2, <hitwithaxe:bark:8>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_dark_oak", 32767, <minecraft:planks:5>);

//Acacia
Chopping.addRecipe("minecraft:log2", 0, "hitwithaxe:debarked_acacia", 1, <hitwithaxe:bark>); //Y Axis
Chopping.addRecipe("minecraft:log2", 4, "hitwithaxe:debarked_acacia", 0, <hitwithaxe:bark>); //X Axis
Chopping.addRecipe("minecraft:log2", 8, "hitwithaxe:debarked_acacia", 2, <hitwithaxe:bark>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_acacia", 32767, <minecraft:planks:4>);

//Ashen
Chopping.addRecipe("plants2:nether_log", 5, "hitwithaxe:debarked_ash", 1, <hitwithaxe:bark:1>); //Y Axis
Chopping.addRecipe("plants2:nether_log", 0, "hitwithaxe:debarked_ash", 0, <hitwithaxe:bark:1>); //X Axis
Chopping.addRecipe("plants2:nether_log", 10, "hitwithaxe:debarked_ash", 2, <hitwithaxe:bark:1>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_ash", 32767, <plants2:planks>);

//Blazing
Chopping.addRecipe("plants2:nether_log", 6, "hitwithaxe:debarked_blaze", 1, <hitwithaxe:bark:4>); //Y Axis
Chopping.addRecipe("plants2:nether_log", 1, "hitwithaxe:debarked_blaze", 0, <hitwithaxe:bark:4>); //X Axis
Chopping.addRecipe("plants2:nether_log", 11, "hitwithaxe:debarked_blaze", 2, <hitwithaxe:bark:4>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_blaze", 32767, <plants2:planks:1>);

//Black Kauri
Chopping.addRecipe("plants2:log_0", 5, "hitwithaxe:debarked_black_kauri", 1, <hitwithaxe:bark:3>); //Y Axis
Chopping.addRecipe("plants2:log_0", 0, "hitwithaxe:debarked_black_kauri", 0, <hitwithaxe:bark:3>); //X Axis
Chopping.addRecipe("plants2:log_0", 10, "hitwithaxe:debarked_black_kauri", 2, <hitwithaxe:bark:3>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_black_kauri", 32767, <plants2:planks:2>);

//Brazillian Pine
Chopping.addRecipe("plants2:log_0", 6, "hitwithaxe:debarked_brazillian_pine", 1, <hitwithaxe:bark:5>); //Y Axis
Chopping.addRecipe("plants2:log_0", 1, "hitwithaxe:debarked_brazillian_pine", 0, <hitwithaxe:bark:5>); //X Axis
Chopping.addRecipe("plants2:log_0", 11, "hitwithaxe:debarked_brazillian_pine", 2, <hitwithaxe:bark:5>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_brazillian_pine", 32767, <plants2:planks:3>);

//Incense Cedar
Chopping.addRecipe("plants2:log_0", 7, "hitwithaxe:debarked_incense_cedar", 1, <hitwithaxe:bark:11>); //Y Axis
Chopping.addRecipe("plants2:log_0", 2, "hitwithaxe:debarked_incense_cedar", 0, <hitwithaxe:bark:11>); //X Axis
Chopping.addRecipe("plants2:log_0", 12, "hitwithaxe:debarked_incense_cedar", 2, <hitwithaxe:bark:11>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_incense_cedar", 32767, <plants2:planks:4>);

//Murray Pine
Chopping.addRecipe("plants2:log_0", 8, "hitwithaxe:debarked_murray_pine", 1, <hitwithaxe:bark:14>); //Y Axis
Chopping.addRecipe("plants2:log_0", 3, "hitwithaxe:debarked_murray_pine", 0, <hitwithaxe:bark:14>); //X Axis
Chopping.addRecipe("plants2:log_0", 13, "hitwithaxe:debarked_murray_pine", 2, <hitwithaxe:bark:14>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_murray_pine", 32767, <plants2:planks:5>);

//Crystal
Chopping.addRecipe("plants2:crystal_log", 5, "hitwithaxe:debarked_crystal", 1, <hitwithaxe:bark:6>); //Y Axis
Chopping.addRecipe("plants2:crystal_log", 0, "hitwithaxe:debarked_crystal", 0, <hitwithaxe:bark:6>); //X Axis
Chopping.addRecipe("plants2:crystal_log", 10, "hitwithaxe:debarked_crystal", 2, <hitwithaxe:bark:6>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_crystal", 32767, <plants2:crystal_planks>);

//Dark Crystal
Chopping.addRecipe("plants2:crystal_log", 6, "hitwithaxe:debarked_dark_crystal", 1, <hitwithaxe:bark:7>); //Y Axis
Chopping.addRecipe("plants2:crystal_log", 1, "hitwithaxe:debarked_dark_crystal", 0, <hitwithaxe:bark:7>); //X Axis
Chopping.addRecipe("plants2:crystal_log", 11, "hitwithaxe:debarked_dark_crystal", 2, <hitwithaxe:bark:7>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_dark_crystal", 32767, <plants2:crystal_planks:1>);

//Menril
Chopping.addRecipe("integrateddynamics:menril_log", 1, "hitwithaxe:debarked_menril", 1, <hitwithaxe:bark:13>); //Y Axis
Chopping.addRecipe("integrateddynamics:menril_log", 0, "hitwithaxe:debarked_menril", 0, <hitwithaxe:bark:13>); //X Axis
Chopping.addRecipe("integrateddynamics:menril_log", 2, "hitwithaxe:debarked_menril", 2, <hitwithaxe:bark:13>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_menril", 32767, <integrateddynamics:menril_planks>);

//Silverwood
Chopping.addRecipe("thaumcraft:log_silverwood", 1, "hitwithaxe:debarked_silverwood", 1, <hitwithaxe:bark:18>); //Y Axis
Chopping.addRecipe("thaumcraft:log_silverwood", 0, "hitwithaxe:debarked_silverwood", 0, <hitwithaxe:bark:18>); //X Axis
Chopping.addRecipe("thaumcraft:log_silverwood", 2, "hitwithaxe:debarked_silverwood", 2, <hitwithaxe:bark:18>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_silverwood", 32767, <thaumcraft:plank_silverwood>);

//Greatwood
Chopping.addRecipe("thaumcraft:log_greatwood", 1, "hitwithaxe:debarked_greatwood", 1, <hitwithaxe:bark:10>); //Y Axis
Chopping.addRecipe("thaumcraft:log_greatwood", 0, "hitwithaxe:debarked_greatwood", 0, <hitwithaxe:bark:10>); //X Axis
Chopping.addRecipe("thaumcraft:log_greatwood", 2, "hitwithaxe:debarked_greatwood", 2, <hitwithaxe:bark:10>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_greatwood", 32767, <thaumcraft:plank_greatwood>);

//Fir
Chopping.addRecipe("traverse:fir_log", 1, "hitwithaxe:debarked_fir", 1, <hitwithaxe:bark:9>); //Y Axis
Chopping.addRecipe("traverse:fir_log", 0, "hitwithaxe:debarked_fir", 0, <hitwithaxe:bark:9>); //X Axis
Chopping.addRecipe("traverse:fir_log", 2, "hitwithaxe:debarked_fir", 2, <hitwithaxe:bark:9>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_fir", 32767, <traverse:fir_planks>);

//Spectre
Chopping.addRecipe("randomthings:spectrelog", 1, "hitwithaxe:debarked_spectre", 1, <hitwithaxe:bark:19>); //Y Axis
Chopping.addRecipe("randomthings:spectrelog", 0, "hitwithaxe:debarked_spectre", 0, <hitwithaxe:bark:19>); //X Axis
Chopping.addRecipe("randomthings:spectrelog", 2, "hitwithaxe:debarked_spectre", 2, <hitwithaxe:bark:19>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_spectre", 32767, <randomthings:spectreplank>);


//Olive
Chopping.addRecipe("rustic:log", 0, "hitwithaxe:debarked_oak", 1, <hitwithaxe:bark:19>); //Y Axis
Chopping.addRecipe("rustic:log", 4, "hitwithaxe:debarked_oak", 0, <hitwithaxe:bark:19>); //X Axis
Chopping.addRecipe("rustic:log", 8, "hitwithaxe:debarked_oak", 2, <hitwithaxe:bark:19>); //Z Axis
Chopping.addRecipe("hitwithaxe:debarked_oak", 32767, <rustic:planks>);

//Plank -> Stick
Chopping.addRecipe("minecraft:planks", 32767, <minecraft:stick> * 2);
Chopping.addRecipe("plants2:planks", 32767, <minecraft:stick> * 2);
Chopping.addRecipe("plants2:crystal_planks", 32767, <minecraft:stick> * 2);
Chopping.addRecipe("integrateddynamics:menril_planks", 32767, <minecraft:stick> * 2);
Chopping.addRecipe("thaumcraft:plank_silverwood", 32767, <minecraft:stick> * 2);
Chopping.addRecipe("thaumcraft:plank_greatwood", 32767, <minecraft:stick> * 2);
Chopping.addRecipe("traverse:fir_planks", 32767, <minecraft:stick> * 2);
Chopping.addRecipe("randomthings:spectreplank", 32767, <minecraft:stick> * 2);

var woodMap as IItemStack[][IItemStack] = {
	<minecraft:log2> : [
		<hitwithaxe:debarked_acacia>,
		<minecraft:planks:4>,
		<hitwithaxe:bark>
	],
	<plants2:nether_log> : [
		<hitwithaxe:debarked_ash>,
		<plants2:planks>,
		<hitwithaxe:bark:1>
	],
	<minecraft:log:2> : [
		<hitwithaxe:debarked_birch>,
		<minecraft:planks:2>,
		<hitwithaxe:bark:2>
	],
	<plants2:log_0> : [
		<hitwithaxe:debarked_black_kauri>,
		<plants2:planks:2>,
		<hitwithaxe:bark:3>
	],
	<plants2:nether_log:1> : [
		<hitwithaxe:debarked_blaze>,
		<plants2:planks:1>,
		<hitwithaxe:bark:4>
	],
	<plants2:log_0:1> : [
		<hitwithaxe:debarked_brazillian_pine>,
		<plants2:planks:3>,
		<hitwithaxe:bark:5>
	],
	<plants2:crystal_log> : [
		<hitwithaxe:debarked_crystal>,
		<plants2:crystal_planks>,
		<hitwithaxe:bark:6>
	],
	<plants2:crystal_log:1> : [
		<hitwithaxe:debarked_dark_crystal>,
		<plants2:crystal_planks:1>,
		<hitwithaxe:bark:7>
	],
	<minecraft:log2:1> : [
		<hitwithaxe:debarked_dark_oak>,
		<minecraft:planks:5>,
		<hitwithaxe:bark:8>
	],
	<minecraft:log:3> : [
		<hitwithaxe:debarked_jungle>,
		<minecraft:planks:3>,
		<hitwithaxe:bark:12>
	],
	<integrateddynamics:menril_log> : [
		<hitwithaxe:debarked_menril>,
		<integrateddynamics:menril_planks>,
		<hitwithaxe:bark:13>
	],
	<plants2:log_0:3> : [
		<hitwithaxe:debarked_murray_pine>,
		<plants2:planks:5>,
		<hitwithaxe:bark:14>
	],
	<minecraft:log> : [
		<hitwithaxe:debarked_oak>,
		<minecraft:planks>,
		<hitwithaxe:bark:15>
	],
	<thaumcraft:log_silverwood> : [
		<hitwithaxe:debarked_silverwood>,
		<thaumcraft:plank_silverwood>,
		<hitwithaxe:bark:18>
	],
	<randomthings:spectrelog> : [
		<hitwithaxe:debarked_spectre>,
		<randomthings:spectreplank>,
		<hitwithaxe:bark:19>
	],
	<minecraft:log:1> : [
		<hitwithaxe:debarked_spruce>,
		<minecraft:planks:1>,
		<hitwithaxe:bark:20>
	],
	<rustic:log:1> : [
		<hitwithaxe:debarked_ironwood>,
		<rustic:planks:1>,
		<hitwithaxe:bark:25>
	],
	<rustic:log> : [
		<hitwithaxe:debarked_olive>,
		<rustic:planks>,
		<hitwithaxe:bark:27>
	]
};

for inputLog, outputs in woodMap {
	var debarkedLog = outputs[0];
	var planks = outputs[1];
	var bark = outputs[2];

	mods.gregtech.recipe.RecipeMap.getByName("cutting_saw").recipeBuilder()
		.inputs(inputLog)
		.fluidInputs(<liquid:water> * 50)
		.outputs([debarkedLog, bark * 2])
		.duration(400)
		.EUt(7)
		.buildAndRegister();

	mods.gregtech.recipe.RecipeMap.getByName("cutting_saw").recipeBuilder()
		.inputs(debarkedLog)
		.fluidInputs(<liquid:water> * 50)
		.outputs(planks * 6)
		.duration(400)
		.EUt(7)
		.buildAndRegister();
}














