/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.DoubleElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropSpawnParticles
extends BaseResourceProperty
implements IResourceEffect {
    EnumParticleTypes type;
    Vec3d offset = new Vec3d(0.0, 0.0, 0.0);
    double speed;
    int count;
    int[] args;

    public PropSpawnParticles(JsonObject obj) {
        super(obj, "spawn_particles");
        this.type = EnumParticleTypes.func_186831_a((String)obj.get("name").getAsString());
        if (this.type == null) {
            throw new RuntimeException("Partical type is not allowed");
        }
        this.count = JsonUtil.getOrDefault(obj, "amount", 0);
        double x = JsonUtil.getOrDefault(obj, "xOffset", 0.0);
        double y = JsonUtil.getOrDefault(obj, "yOffset", 0.0);
        double z = JsonUtil.getOrDefault(obj, "zOffset", 0.0);
        this.offset.func_72441_c(x, y, z);
        this.speed = JsonUtil.getOrDefault(obj, "speed", 1.0);
        this.args = new int[this.type.func_179345_d()];
        if (obj.has("partical_args")) {
            JsonArray array = obj.getAsJsonArray("partical_args");
            for (int i = 0; i < array.size() && i < this.args.length; ++i) {
                this.args[i] = array.get(i).getAsInt();
            }
        }
        this.setJEIInfo("Spawns Particals");
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (world instanceof WorldServer) {
            ((WorldServer)world).func_175739_a(this.type, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.count, this.offset.field_72450_a, this.offset.field_72448_b, this.offset.field_72449_c, this.speed, this.args);
        }
        return false;
    }

    public static class SpawnParticleFactory
    extends BaseResourceFactory {
        public SpawnParticleFactory() {
            super("spawn_particles", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropSpawnParticles(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", EnumParticleTypes.BLOCK_DUST.func_179346_b());
            obj.addProperty("amount", (Number)25);
            obj.addProperty("xOffset", (Number)0.0);
            obj.addProperty("yOffset", (Number)0.0);
            obj.addProperty("zOffset", (Number)0.0);
            obj.addProperty("speed", (Number)20.0);
            JsonArray array = new JsonArray();
            obj.add("partical_args", (JsonElement)array);
            array.add((JsonElement)new JsonPrimitive((Number)Block.func_176210_f((IBlockState)Blocks.field_150484_ah.func_176223_P())));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("name", "").setDescription("The Partical that should be spawned"));
            map.addElement(new IntElement("amount", 0, "How many should be spawned. 0 = No Random movement but only 1 partical"));
            map.addElement(new DoubleElement("xOffset", 0.0, "The Offset and motion multiplier for the X Position"));
            map.addElement(new DoubleElement("yOffset", 0.0, "The Offset and motion multiplier for the Y Position"));
            map.addElement(new DoubleElement("zOffset", 0.0, "The Offset and motion multiplier for the Z Position"));
            map.addElement(new DoubleElement("speed", 1.0, "The Speed that the Particals should move at"));
            map.addElement(new ArrayElement("partical_args", new IntElement("", 0)).setDescription("Custom Partical Arguments. These are the same as the Command one"));
            return map;
        }
    }
}

