/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.ScavengeAPI;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropInsideStructure
extends BaseResourceProperty
implements IResourceCondition {
    String id;
    boolean required;

    public PropInsideStructure(JsonObject obj) {
        super(obj, "require_structure");
        this.addSelfIncompat();
        this.id = obj.get("name").getAsString();
        this.required = JsonUtil.getOrDefault(obj, "required", true);
        if (this.required) {
            this.setJEIInfo("Block has to be inside [" + this.id + "] Structure");
        } else {
            this.setJEIInfo("Block is not allowed inside [" + this.id + "] Structure");
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        if (client) {
            return true;
        }
        return this.required == ScavengeAPI.INSTANCE.getWorldRegistry().isInsideStructure(world, this.id, pos);
    }

    public static class InsideStructureFactory
    extends BaseResourceFactory {
        public InsideStructureFactory() {
            super("require_structure", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropInsideStructure(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("name", "").setDescription("The Structure Type that should be checkt for"));
            map.addElement(new BooleanElement("required", true, "If the Structure is required or not"));
            map.setDescription("Allows to check if the Block is inside of a Structure");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "Village");
            obj.addProperty("required", Boolean.valueOf(true));
        }
    }
}

