/*
 * Decompiled with CFR 0.152.
 */
package scavenge.tileentity.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;
import scavenge.api.utils.StackObject;

public class PropConsumeTileEntityItems
extends BaseResourceProperty
implements IResourceEffect {
    List<StackObject> items = new ArrayList<StackObject>();
    EnumFacing side;

    public PropConsumeTileEntityItems(JsonObject obj) {
        super(obj, "consume_tile_items");
        this.side = EnumFacing.func_176739_a((String)JsonUtil.getOrDefault(obj, "side", null));
        JsonUtil.convertToObject(obj.get("items"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                StackObject stack = JsonUtil.createStackObject(t);
                if (stack == null) {
                    throw new RuntimeException("Stack from Object[" + t + "] is null thats not allowed");
                }
                PropConsumeTileEntityItems.this.items.add(stack);
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Block TileEntity Items get Consumed");
        for (StackObject obj : this.items) {
            collector.addInfo(obj.getStackize() + "x " + obj.getName());
        }
        collector.finishLayer();
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return false;
        }
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        ArrayList<StackObject> list = new ArrayList<StackObject>(this.items.size());
        for (StackObject obj : this.items) {
            list.add(obj.copy());
        }
        int removed = 0;
        int count = handler.getSlots();
        for (int i = 0; i < count; ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (LootUtil.isStackEmpty(stack)) continue;
            int stackSize = LootUtil.getStackSize(stack);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                StackObject obj = (StackObject)iter.next();
                if (!obj.matches(stack)) continue;
                if (obj.getStackize() <= stackSize) {
                    int amount = obj.getStackize();
                    stackSize -= amount;
                    handler.extractItem(i, amount, false);
                    iter.remove();
                    removed += amount;
                } else {
                    obj.decreaseStackSize(stackSize);
                    handler.extractItem(i, stackSize, false);
                    removed += stackSize;
                    stackSize = 0;
                }
                if (stackSize > 0) continue;
                break;
            }
            if (list.isEmpty()) break;
        }
        return removed > 0;
    }

    public static class ConsumeTileEntityItemsFactory
    extends BaseResourceFactory {
        public ConsumeTileEntityItemsFactory() {
            super("consume_tile_items", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropConsumeTileEntityItems(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject object = new JsonObject();
            object.addProperty("name", "minecraft:stick");
            object.addProperty("amount", (Number)32);
            JsonArray array = new JsonArray();
            array.add((JsonElement)object);
            obj.add("items", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement base = new MapElement("");
            base.addElement(new TextElement("name", "").setDescription("The Item that should be consumed"));
            base.addElement(new IntElement("meta", Short.MAX_VALUE, "The Metadata of the item that should be consumed 32767 = any meta"));
            base.addElement(new IntElement("amount", 1, "How many items should be consumed"));
            base.addElement(new TextElement("nbt", "null", "The NBTData the item should have that should be consumed"));
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("side", "Null", "Which side the items should be taken from"));
            map.addElement(new OptionalArrayElement("items", base));
            map.setDescription("Allows to consume items from a TileEntities inventory");
            return map;
        }
    }
}

