/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.effects;

import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.loot.impl.BasePassiveLootProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;

public class PropSetStacksize
extends BasePassiveLootProperty {
    int value;

    public PropSetStacksize(JsonObject obj) {
        super("set_size");
        this.value = JsonUtil.getOrDefault(obj, "value", 1);
    }

    @Override
    public ItemStack applyPassiveEffect(ItemStack stack) {
        LootUtil.setStackSize(stack, this.value);
        return stack;
    }

    @Override
    public ItemStack applyInfoEffect(ItemStack stack) {
        LootUtil.setStackSize(stack, this.value);
        return stack;
    }

    public static class SetSizeFactory
    extends BaseLootFactory {
        public SetSizeFactory() {
            super("set_size", false);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropSetStacksize(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.setDescription("Allows to modify the Stacksize of the loot drop");
            map.addElement(new IntElement("value", 1, "the amount the Stackize should be"));
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("value", (Number)32);
        }
    }
}

