/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math.operation;

import com.google.gson.JsonObject;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.math.IMathOperation;
import scavenge.api.math.impl.BaseMathOperation;
import scavenge.api.math.impl.BaseOperationFactory;
import scavenge.api.utils.CompatState;

public class NotInRangeOperation
extends BaseMathOperation {
    long min;
    long max;

    public NotInRangeOperation(JsonObject obj) {
        this(obj.get("minValue").getAsLong(), obj.get("maxValue").getAsLong());
        if (obj.has("modifiers")) {
            this.addMathModifiers(obj.get("modifiers"));
        }
    }

    public NotInRangeOperation(long minValue, long maxValue) {
        super("notInRange");
        this.min = minValue;
        this.max = maxValue;
    }

    @Override
    public boolean matches(long value) {
        return (value = this.getValue(value)) < this.min || value > this.max;
    }

    public static class NotInRangeFactory
    extends BaseOperationFactory {
        public NotInRangeFactory() {
            super("notInRange");
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IMathOperation createObject(JsonObject obj) {
            return new NotInRangeOperation(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new LongElement("minValue", 0L).setDescription("The Minimum Value the Operation should compare with"));
            map.addElement(new LongElement("maxValue", 0L).setDescription("The Maximum Value the Operation should compare with"));
            map.setDescription("Checks if the Input Value is outside of the Range of the Selected Values");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("minValue", (Number)10);
            obj.addProperty("maxValue", (Number)100);
        }
    }
}

