/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.loaders;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scavenge.api.ScavengeAPI;
import scavenge.api.plugin.ScavengeLoaded;
import scavenge.api.plugin.ScavengePlugin;

public class PluginLoader {
    static final Logger pluginLogger = LogManager.getLogger((String)"ScavengePluginLoader");
    List<ScavengePlugin> plugins = new LinkedList<ScavengePlugin>();

    public void loadPlugins(ASMDataTable table, Configuration config) {
        Set set = table.getAll(ScavengeLoaded.class.getCanonicalName());
        if (set == null) {
            return;
        }
        for (ASMDataTable.ASMData entry : set) {
            String currentlyLoading = "";
            try {
                ScavengePlugin plugin;
                Class<?> clz = Class.forName(entry.getClassName());
                Map map = entry.getAnnotationInfo();
                currentlyLoading = "[" + map.get("name") + "]";
                pluginLogger.info("Loading " + currentlyLoading + " Version [" + map.getOrDefault("version", "1.0") + "]");
                if (clz != null) {
                    plugin = (ScavengePlugin)clz.newInstance();
                    if (!plugin.shouldLoad(config)) {
                        pluginLogger.info("Didn't load " + currentlyLoading + " because requirements not met!");
                        continue;
                    }
                } else {
                    pluginLogger.warn("Couldn't load " + currentlyLoading + " because the class is null");
                    continue;
                }
                this.plugins.add(plugin);
                pluginLogger.info("Successfully Loaded " + currentlyLoading);
            }
            catch (Exception e) {
                pluginLogger.warn("Failed to load " + currentlyLoading + " Because of this Crash!");
                e.printStackTrace();
            }
        }
    }

    public void loadPlugins() {
        for (ScavengePlugin plugin : this.plugins) {
            plugin.loadPlugin(ScavengeAPI.INSTANCE);
        }
    }

    public void postLoadPlugin() {
        for (ScavengePlugin plugin : this.plugins) {
            plugin.postLoadPlugin(ScavengeAPI.INSTANCE);
        }
    }
}

