/*
 * Decompiled with CFR 0.152.
 */
package scavenge.api.autodoc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.BaseElement;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.DoubleElement;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;

public class JsonConverter {
    public static MapElement createFromJson(JsonObject element) {
        MapElement base = new MapElement("");
        for (Map.Entry entry : element.entrySet()) {
            BaseElement el = JsonConverter.createObject((String)entry.getKey(), (JsonElement)entry.getValue());
            if (el == null) continue;
            return base.addElement(el);
        }
        return base;
    }

    public static BaseElement createObject(String id, JsonElement element) {
        if (element.isJsonArray()) {
            ArrayElement array = new ArrayElement(id);
            for (JsonElement el : element.getAsJsonArray()) {
                BaseElement base = JsonConverter.createObject("", el);
                if (base == null) continue;
                array.addElement(base);
            }
            return array;
        }
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            MapElement map = new MapElement(id);
            for (Map.Entry entry : obj.entrySet()) {
                BaseElement base = JsonConverter.createObject((String)entry.getKey(), (JsonElement)entry.getValue());
                if (base == null) continue;
                map.addElement(base);
            }
            return map;
        }
        if (element.isJsonNull()) {
            return null;
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return new BooleanElement(id, primitive.getAsBoolean());
        }
        if (primitive.isNumber()) {
            double d = primitive.getAsDouble();
            if (Math.floor(d) != d) {
                return new LongElement(id, primitive.getAsLong());
            }
            return new DoubleElement(id, d);
        }
        if (primitive.isString()) {
            return new TextElement(id, primitive.getAsString());
        }
        return null;
    }
}

