/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers;

import com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers.CTLogHelper;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import gnu.trove.set.hash.TCharHashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CTInputHelper {
    public static boolean isABlock(IItemStack block) {
        return CTInputHelper.isABlock(CTInputHelper.toStack(block));
    }

    public static <T> T[][] getMultiDimensionalArray(Class<T> clazz, T[] array, int height, int width) {
        Object[][] multiDim = (Object[][])Array.newInstance(clazz, height, width);
        for (int y = 0; y < height; ++y) {
            System.arraycopy(array, y * width, multiDim[y], 0, width);
        }
        return multiDim;
    }

    public static IItemStack[] toStacks(IIngredient[] ingredients) {
        ArrayList stacks = new ArrayList();
        for (IIngredient ingredient : ingredients) {
            stacks.addAll(ingredient.getItems());
        }
        return stacks.toArray(new IItemStack[stacks.size()]);
    }

    public static boolean isABlock(ItemStack block) {
        return block.func_77973_b() instanceof ItemBlock;
    }

    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = iStack.getInternal();
        if (!(internal instanceof ItemStack)) {
            CTLogHelper.logError("Not a valid item stack: " + iStack);
        }
        return (ItemStack)internal;
    }

    public static IIngredient toIngredient(ItemStack stack) {
        return CTInputHelper.toIItemStack(stack);
    }

    public static IIngredient toIngredient(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return new MCLiquidStack(stack);
    }

    public static IItemStack toIItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return new MCItemStack(stack);
    }

    public static ILiquidStack toILiquidStack(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return new MCLiquidStack(stack);
    }

    public static ItemStack[] toStacks(IItemStack[] iStack) {
        if (iStack == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[iStack.length];
        for (int i = 0; i < iStack.length; ++i) {
            output[i] = CTInputHelper.toStack(iStack[i]);
        }
        return output;
    }

    public static Object toObject(IIngredient iStack) {
        if (iStack == null) {
            return null;
        }
        if (iStack instanceof IOreDictEntry) {
            return CTInputHelper.toString((IOreDictEntry)iStack);
        }
        if (iStack instanceof IItemStack) {
            return CTInputHelper.toStack((IItemStack)iStack);
        }
        if (iStack instanceof IngredientStack) {
            return iStack.getItems();
        }
        return null;
    }

    public static Object[] toObjects(IIngredient[] ingredient) {
        if (ingredient == null) {
            return null;
        }
        Object[] output = new Object[ingredient.length];
        for (int i = 0; i < ingredient.length; ++i) {
            output[i] = ingredient[i] != null ? CTInputHelper.toObject(ingredient[i]) : "";
        }
        return output;
    }

    public static String toString(IOreDictEntry entry) {
        return entry.getName();
    }

    public static FluidStack toFluid(ILiquidStack iStack) {
        if (iStack == null) {
            return null;
        }
        return FluidRegistry.getFluidStack((String)iStack.getName(), (int)iStack.getAmount());
    }

    public static Fluid getFluid(ILiquidStack iStack) {
        if (iStack == null) {
            return null;
        }
        return FluidRegistry.getFluid((String)iStack.getName());
    }

    public static FluidStack[] toFluids(ILiquidStack[] iStack) {
        FluidStack[] stack = new FluidStack[iStack.length];
        for (int i = 0; i < stack.length; ++i) {
            stack[i] = CTInputHelper.toFluid(iStack[i]);
        }
        return stack;
    }

    public static Object[] toShapedObjects(IIngredient[][] ingredients) {
        if (ingredients == null) {
            return null;
        }
        ArrayList<Object> prep = new ArrayList<Object>();
        TCharHashSet usedCharSet = new TCharHashSet();
        prep.add("abc");
        prep.add("def");
        prep.add("ghi");
        char[][] map = new char[][]{{'a', 'b', 'c'}, {'d', 'e', 'f'}, {'g', 'h', 'i'}};
        for (int x = 0; x < ingredients.length; ++x) {
            if (ingredients[x] == null) continue;
            for (int y = 0; y < ingredients[x].length; ++y) {
                if (ingredients[x][y] == null || x >= map.length || y >= map[x].length) continue;
                prep.add(Character.valueOf(map[x][y]));
                usedCharSet.add(map[x][y]);
                prep.add(CTInputHelper.toObject(ingredients[x][y]));
            }
        }
        for (int i = 0; i < 3; ++i) {
            StringBuilder sb = new StringBuilder();
            if (!(prep.get(i) instanceof String)) continue;
            String s = (String)prep.get(i);
            for (int j = 0; j < 3; ++j) {
                char c = s.charAt(j);
                if (usedCharSet.contains(c)) {
                    sb.append(c);
                    continue;
                }
                sb.append(" ");
            }
            prep.set(i, sb.toString());
        }
        return prep.toArray();
    }

    public static <R> NonNullList<R> toNonNullList(R[] items) {
        NonNullList nonNullList = NonNullList.func_191196_a();
        Collections.addAll(nonNullList, items);
        return nonNullList;
    }

    public static Ingredient toIngredient(@Nullable IIngredient ingredient) {
        if (ingredient == null) {
            return Ingredient.field_193370_a;
        }
        return new IngredientWrapper(ingredient);
    }

    public static Ingredient[][] toIngredientMatrix(IIngredient[][] ingredients) {
        Ingredient[][] result = new Ingredient[ingredients.length][];
        for (int row = 0; row < ingredients.length; ++row) {
            result[row] = new Ingredient[ingredients[row].length];
            for (int col = 0; col < ingredients[row].length; ++col) {
                result[row][col] = CTInputHelper.toIngredient(ingredients[row][col]);
            }
        }
        return result;
    }

    public static Ingredient[] toIngredientArray(IIngredient[] ingredients) {
        Ingredient[] result = new Ingredient[ingredients.length];
        for (int i = 0; i < ingredients.length; ++i) {
            result[i] = CTInputHelper.toIngredient(ingredients[i]);
        }
        return result;
    }

    public static List<ItemStack> getMatchingStacks(List<ItemStack> itemStackList, int amount, List<ItemStack> result) {
        NonNullList internalList = NonNullList.func_191196_a();
        for (ItemStack itemStack : itemStackList) {
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77960_j() == Short.MAX_VALUE) {
                itemStack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, internalList);
                continue;
            }
            internalList.add((Object)itemStack);
        }
        for (ItemStack itemStack : internalList) {
            itemStack.func_190920_e(amount);
        }
        result.addAll((Collection<ItemStack>)internalList);
        return result;
    }

    public static List<ItemStack> getMatchingStacks(IIngredient ingredient, List<ItemStack> result) {
        if (ingredient == null) {
            return result;
        }
        if (ingredient instanceof IOreDictEntry) {
            NonNullList ores = OreDictionary.getOres((String)((IOreDictEntry)ingredient).getName());
            CTInputHelper.getMatchingStacks((List<ItemStack>)ores, ingredient.getAmount(), result);
        } else if (ingredient instanceof IItemStack) {
            ItemStack itemStack = CTInputHelper.toStack((IItemStack)ingredient);
            itemStack.func_190920_e(ingredient.getAmount());
            result.add(itemStack);
        } else {
            List items = ingredient.getItems();
            for (IItemStack item : items) {
                ItemStack itemStack = CTInputHelper.toStack(item);
                CTInputHelper.getMatchingStacks(Collections.singletonList(itemStack), ingredient.getAmount(), result);
            }
        }
        return result;
    }

    public static class IngredientWrapper
    extends Ingredient {
        private IIngredient ingredient;

        public IngredientWrapper(@Nullable IIngredient ingredient) {
            super(new ItemStack[0]);
            this.ingredient = ingredient;
        }

        public int getAmount() {
            if (this.ingredient == null) {
                return 0;
            }
            return this.ingredient.getAmount();
        }

        @Nonnull
        public ItemStack[] func_193365_a() {
            List<ItemStack> matchingStacks = CTInputHelper.getMatchingStacks(this.ingredient, new ArrayList<ItemStack>());
            return matchingStacks.toArray(new ItemStack[matchingStacks.size()]);
        }

        public boolean apply(@Nullable ItemStack itemStack) {
            if (this.ingredient == null) {
                return itemStack == null || itemStack.func_190926_b();
            }
            if (itemStack == null || itemStack.func_190926_b()) {
                return this.ingredient == null;
            }
            return this.ingredient.matches(CTInputHelper.toIItemStack(itemStack));
        }
    }
}

