/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile.multiblock.hatch;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import zmaster587.libVulpes.cap.FluidCapability;
import zmaster587.libVulpes.gui.CommonResources;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleLiquidIndicator;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.tile.TilePointer;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.FluidUtils;
import zmaster587.libVulpes.util.IFluidHandlerInternal;
import zmaster587.libVulpes.util.IconResource;

public class TileFluidHatch
extends TilePointer
implements IFluidHandlerInternal,
IModularInventory,
ISidedInventory {
    protected FluidTank fluidTank;
    private EmbeddedInventory inventory;
    private boolean outputOnly;

    public TileFluidHatch() {
        this.fluidTank = new FluidTank(16000);
        this.inventory = new EmbeddedInventory(2);
    }

    public TileFluidHatch(int capacity) {
        this.fluidTank = new FluidTank(capacity);
        this.inventory = new EmbeddedInventory(2);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidCapability(this);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public TileFluidHatch(boolean outputOnly) {
        this();
        this.outputOnly = outputOnly;
    }

    public boolean isOutputOnly() {
        return this.outputOnly;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.outputOnly) {
            return 0;
        }
        return this.fillInternal(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource.isFluidEqual(this.fluidTank.getFluid())) {
            FluidStack fluidStack = this.fluidTank.drain(resource.amount, doDrain);
            while (this.useBucket(0, this.func_70301_a(0))) {
            }
            return fluidStack;
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.fluidTank.drain(maxDrain, doDrain);
    }

    @Override
    public FluidStack drainInternal(FluidStack maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    @Override
    public int fillInternal(FluidStack resource, boolean doFill) {
        int fillAmt = this.fluidTank.fill(resource, doFill);
        while (this.useBucket(0, this.func_70301_a(0))) {
        }
        if (doFill && this.hasMaster() && this.getMasterBlock() instanceof TileMultiBlock) {
            ((TileMultiBlock)this.getMasterBlock()).onInventoryUpdated();
        }
        return fillAmt;
    }

    @Override
    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.fluidTank.getTankProperties();
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        ArrayList<ModuleBase> list = new ArrayList<ModuleBase>();
        list.add(new ModuleSlotArray(45, 18, (IInventory)this, 0, 1));
        list.add(new ModuleSlotArray(45, 54, (IInventory)this, 1, 2));
        if (this.field_145850_b.field_72995_K) {
            list.add(new ModuleImage(44, 35, new IconResource(194, 0, 18, 18, CommonResources.genericBackground)));
        }
        list.add(new ModuleLiquidIndicator(27, 18, this));
        return list;
    }

    @Override
    public String getModularInventoryName() {
        return "tile.liquidHatch.name";
    }

    @Override
    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amt) {
        return this.inventory.func_70298_a(slot, amt);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
        while (this.useBucket(0, this.func_70301_a(0))) {
        }
        if (this.hasMaster() && this.getMasterBlock() instanceof TileMultiBlock) {
            ((TileMultiBlock)this.getMasterBlock()).onInventoryUpdated();
        }
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("outputOnly", this.outputOnly);
        this.inventory.writeToNBT(nbt);
        nbt.func_74768_a("capacity", this.fluidTank.getCapacity());
        this.fluidTank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.outputOnly = nbt.func_74767_n("outputOnly");
        this.inventory.readFromNBT(nbt);
        this.fluidTank = new FluidTank(nbt.func_74762_e("capacity"));
        this.fluidTank.readFromNBT(nbt);
    }

    protected boolean useBucket(int slot, ItemStack stack) {
        return FluidUtils.attemptDrainContainerIInv(this.inventory, (IFluidTank)this.fluidTank, stack, 0, 1);
    }

    public String func_70005_c_() {
        return this.getModularInventoryName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0 && this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }
}

