/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.recipe.composer;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import yuudaari.soulus.common.block.composer.ComposerTileEntity;
import yuudaari.soulus.common.recipe.Recipe;
import yuudaari.soulus.common.recipe.RecipeUtils;
import yuudaari.soulus.common.recipe.composer.IRecipeComposer;
import yuudaari.soulus.common.util.JSON;

public class RecipeComposerShapeless
extends Recipe
implements IRecipeComposer {
    protected final ItemStack output;
    protected final NonNullList<Ingredient> input = NonNullList.func_191196_a();
    protected final float time;
    protected final Map<String, Integer> mobsRequired = new HashMap<String, Integer>();
    protected final Set<String> mobWhitelist = new HashSet<String>();
    protected final Set<String> mobBlacklist = new HashSet<String>();

    public RecipeComposerShapeless(ItemStack result, float time, Map<String, Integer> mobsRequired, Set<String> mobWhitelist, Set<String> mobBlacklist, Object ... recipe) {
        this.output = result.func_77946_l();
        this.time = time;
        if (mobsRequired != null) {
            this.mobsRequired.putAll(mobsRequired);
        }
        if (mobWhitelist != null) {
            this.mobWhitelist.addAll(mobWhitelist);
        }
        if (mobBlacklist != null) {
            this.mobBlacklist.addAll(mobBlacklist);
        }
        Arrays.stream(recipe).map(in -> CraftingHelper.getIngredient((Object)in)).forEach(ing -> {
            if (ing == null) {
                throw new RuntimeException("Invalid shapeless ore recipe: " + Arrays.stream(recipe).map(obj -> obj.toString()).collect(Collectors.joining(", ")));
            }
            this.input.add(ing);
        });
    }

    @Override
    public float getTime() {
        return this.time;
    }

    @Override
    public Map<String, Integer> getMobsRequired() {
        return this.mobsRequired;
    }

    @Override
    public Set<String> getMobBlacklist() {
        return this.mobBlacklist;
    }

    @Override
    public Set<String> getMobWhitelist() {
        return this.mobWhitelist;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.output;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting var1, @Nonnull World world) {
        if (!(var1 instanceof ComposerTileEntity.ComposerContainer.CraftingMatrix)) {
            return false;
        }
        NonNullList required = NonNullList.func_191196_a();
        required.addAll(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot.func_190926_b()) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                if (!((Ingredient)req.next()).apply(slot)) continue;
                inRecipe = true;
                req.remove();
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.input;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    @Override
    public boolean func_194133_a(int width, int height) {
        return width * height >= this.input.size();
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            Object[] ingredients = Streams.stream((Iterable)JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")).map(ing -> CraftingHelper.getIngredient((JsonElement)ing, (JsonContext)context)).toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack output = RecipeUtils.getOutput(json.get("result"), context);
            float time = JsonUtils.func_151221_a((JsonObject)json, (String)"time", (float)1.0f);
            JsonObject mobs = JsonUtils.func_151218_a((JsonObject)json, (String)"mobs_required", null);
            Map<String, Integer> requiredMobs = mobs == null ? null : mobs.getAsJsonObject().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonElement)entry.getValue()).getAsInt()));
            Set<String> whitelist = JSON.getStringSet(json, "mob_whitelist");
            Set<String> blacklist = JSON.getStringSet(json, "mob_blacklist");
            return new RecipeComposerShapeless(output, time, requiredMobs, whitelist, blacklist, ingredients);
        }
    }
}

