/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config.creature;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import yuudaari.soulus.common.config.ConfigFile;
import yuudaari.soulus.common.config.ConfigProfile;
import yuudaari.soulus.common.config.creature.ConfigCreature;
import yuudaari.soulus.common.config.creature.ConfigCreatureBiome;
import yuudaari.soulus.common.config.creature.ConfigCreatureDimension;
import yuudaari.soulus.common.util.serializer.DefaultMapSerializer;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@ConfigFile(file="creatures/creatures", id="soulus", profile="no_creatures_no_drops")
@Serializable
public class ConfigCreatures {
    @ConfigProfile
    public static ConfigCreatures noCreaturesNoDrops = new ConfigCreatures().addCreatureConfig("minecraft:*", new ConfigCreature(0.0).setWhitelistedDrops("summoned", "*")).addCreatureConfig("minecraft:skeleton", new ConfigCreature(0.0).setBlacklistedDrops("all", "minecraft:bone").setBlacklistedDrops("spawned", "*")).addCreatureConfig("minecraft:wither_skeleton", new ConfigCreature(0.0).setBlacklistedDrops("all", "minecraft:bone").setBlacklistedDrops("spawned", "*")).addCreatureConfig("minecraft:stray", new ConfigCreature(0.0).setBlacklistedDrops("all", "minecraft:bone").setBlacklistedDrops("spawned", "*")).addCreatureConfig("minecraft:wither", new ConfigCreature(1.0).setWhitelistedDrops("all", "*")).addCreatureConfig("minecraft:ender_dragon", new ConfigCreature(1.0).setWhitelistedDrops("all", "*"));
    @ConfigProfile
    public static ConfigCreatures noCreaturesYesDrops = new ConfigCreatures().addCreatureConfig("minecraft:*", new ConfigCreature(0.0).setWhitelistedDrops("all", "*")).addCreatureConfig("minecraft:skeleton", new ConfigCreature(0.0).setBlacklistedDrops("all", "minecraft:bone")).addCreatureConfig("minecraft:wither_skeleton", new ConfigCreature(0.0).setBlacklistedDrops("all", "minecraft:bone")).addCreatureConfig("minecraft:stray", new ConfigCreature(0.0).setBlacklistedDrops("all", "minecraft:bone")).addCreatureConfig("minecraft:wither", new ConfigCreature(1.0)).addCreatureConfig("minecraft:ender_dragon", new ConfigCreature(1.0));
    @ConfigProfile
    public static ConfigCreatures noCreaturesNoDropsAllMods = new ConfigCreatures().addCreatureConfig("*", new ConfigCreature(0.0).setWhitelistedDrops("summoned", "*")).addCreatureConfig("minecraft:skeleton", new ConfigCreature(0.0).setBlacklistedDrops("all", "minecraft:bone").setBlacklistedDrops("spawned", "*")).addCreatureConfig("minecraft:wither_skeleton", new ConfigCreature(0.0).setBlacklistedDrops("all", "minecraft:bone").setBlacklistedDrops("spawned", "*")).addCreatureConfig("minecraft:stray", new ConfigCreature(0.0).setBlacklistedDrops("all", "minecraft:bone").setBlacklistedDrops("spawned", "*")).addCreatureConfig("minecraft:wither", new ConfigCreature(1.0).setWhitelistedDrops("all", "*")).addCreatureConfig("minecraft:ender_dragon", new ConfigCreature(1.0).setWhitelistedDrops("all", "*"));
    @ConfigProfile
    public static ConfigCreatures yesCreaturesNoDrops = new ConfigCreatures().addCreatureConfig("minecraft:*", new ConfigCreature(1.0).setBlacklistedDrops("spawned", "*")).addCreatureConfig("minecraft:skeleton", new ConfigCreature(1.0).setBlacklistedDrops("summoned", "minecraft:bone")).addCreatureConfig("minecraft:wither_skeleton", new ConfigCreature(1.0).setBlacklistedDrops("summoned", "minecraft:bone")).addCreatureConfig("minecraft:stray", new ConfigCreature(1.0).setBlacklistedDrops("summoned", "minecraft:bone")).addCreatureConfig("minecraft:wither", new ConfigCreature(1.0).setWhitelistedDrops("all", "*")).addCreatureConfig("minecraft:ender_dragon", new ConfigCreature(1.0).setWhitelistedDrops("all", "*"));
    @ConfigProfile
    public static ConfigCreatures yesCreaturesNoDropsAllMods = new ConfigCreatures().addCreatureConfig("*", new ConfigCreature(1.0).setBlacklistedDrops("spawned", "*")).addCreatureConfig("minecraft:skeleton", new ConfigCreature(1.0).setBlacklistedDrops("summoned", "minecraft:bone")).addCreatureConfig("minecraft:wither_skeleton", new ConfigCreature(1.0).setBlacklistedDrops("summoned", "minecraft:bone")).addCreatureConfig("minecraft:stray", new ConfigCreature(1.0).setBlacklistedDrops("summoned", "minecraft:bone")).addCreatureConfig("minecraft:wither", new ConfigCreature(1.0).setWhitelistedDrops("all", "*")).addCreatureConfig("minecraft:ender_dragon", new ConfigCreature(1.0).setWhitelistedDrops("all", "*"));
    @ConfigProfile
    public static ConfigCreatures yesCreaturesYesDrops = new ConfigCreatures().addCreatureConfig("*", new ConfigCreature(1.0).setWhitelistedDrops("all", "*")).addCreatureConfig("minecraft:skeleton", new ConfigCreature(1.0).setBlacklistedDrops("all", "minecraft:bone")).addCreatureConfig("minecraft:wither_skeleton", new ConfigCreature(1.0).setBlacklistedDrops("all", "minecraft:bone")).addCreatureConfig("minecraft:stray", new ConfigCreature(1.0).setBlacklistedDrops("all", "minecraft:bone"));
    @Serialized(value=DimensionMapSerializer.class, topLevel=true)
    public Map<String, ConfigCreatureDimension> dimensionConfigs = new HashMap<String, ConfigCreatureDimension>();

    public ConfigCreatures addDimensionConfig(String dimension, ConfigCreatureDimension config) {
        this.dimensionConfigs.put(dimension, config);
        config.dimensionId = dimension;
        return this;
    }

    public ConfigCreatures addBiomeConfig(String biome, ConfigCreatureBiome config) {
        this.addDimensionConfig("*", new ConfigCreatureDimension(biome, config));
        return this;
    }

    public ConfigCreatures addCreatureConfig(String creature, ConfigCreature config) {
        ConfigCreatureBiome biomeConfig = this.getBiomeConfig("*");
        if (biomeConfig == null) {
            biomeConfig = new ConfigCreatureBiome(creature, config);
            this.addBiomeConfig("*", biomeConfig);
        } else {
            biomeConfig.creatureConfigs.put(creature, config);
        }
        return this;
    }

    public ConfigCreatureBiome getBiomeConfig(String biome) {
        ConfigCreatureDimension dimensionConfig = this.dimensionConfigs.get("*");
        if (dimensionConfig == null) {
            return null;
        }
        return dimensionConfig.biomeConfigs.get(biome);
    }

    public static class DimensionMapSerializer
    extends DefaultMapSerializer<ConfigCreatureDimension> {
        @Override
        public Class<ConfigCreatureDimension> getValueClass() {
            return ConfigCreatureDimension.class;
        }

        @Override
        public Map<String, ConfigCreatureDimension> deserialize(Class<?> requestedType, JsonElement json) {
            Object result = super.deserialize((Class)requestedType, json);
            if (result == null) {
                return result;
            }
            for (Map.Entry entry : result.entrySet()) {
                ((ConfigCreatureDimension)entry.getValue()).dimensionId = (String)entry.getKey();
            }
            return result;
        }
    }
}

