/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.composer;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import yuudaari.soulus.Soulus;
import yuudaari.soulus.client.util.ParticleType;
import yuudaari.soulus.common.advancement.Advancements;
import yuudaari.soulus.common.block.composer.Composer;
import yuudaari.soulus.common.block.composer.ComposerCell;
import yuudaari.soulus.common.block.composer.ComposerCellTileEntity;
import yuudaari.soulus.common.block.composer.HasRenderItemTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigComposer;
import yuudaari.soulus.common.network.SoulsPacketHandler;
import yuudaari.soulus.common.network.packet.client.MobPoof;
import yuudaari.soulus.common.recipe.composer.IRecipeComposer;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.util.Range;

@ConfigInjected(value="soulus")
public class ComposerTileEntity
extends HasRenderItemTileEntity {
    private boolean isConnected = false;
    private float timeTillCraft = 5.0f;
    private float lastTimeTillCraft = 10.0f;
    private int activatingRange;
    private Range spawnDelay;
    private int signalStrength;
    private double activationAmount = 0.0;
    private float poofChance = 0.0f;
    @Nullable
    private UUID owner;
    public final Map<String, Integer> mobsRequired = new HashMap<String, Integer>();
    public final Map<String, Integer> remainingMobs = new HashMap<String, Integer>();
    public Set<String> mobWhitelist = null;
    public Set<String> mobBlacklist = null;
    @ConfigInjected.Inject
    public static ConfigComposer CONFIG;
    private int timeTillNextMajorUpdate = 0;
    private Map<BlockPos, Byte> cellMap = new HashMap<BlockPos, Byte>();
    private double itemRotation = 0.0;
    private double prevItemRotation = 0.0;
    private double timeTillParticle = 0.0;
    private ItemStack renderItem;
    private UUID uuid;
    private FakePlayer fakePlayer;
    private ComposerContainer container;
    private boolean needsRecipeRefresh = true;
    private boolean isInitialRecipeRefresh = false;

    public Composer getBlock() {
        return BlockRegistry.COMPOSER;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean hasValidRecipe() {
        ItemStack storedItem = this.getStoredItem();
        return storedItem != null && !storedItem.func_190926_b();
    }

    public int getSignalStrength() {
        return this.signalStrength;
    }

    public double getActivationAmount() {
        return this.activationAmount;
    }

    public double getPoofChance() {
        return this.poofChance;
    }

    public void setOwner(EntityPlayer owner) {
        this.owner = owner.func_110124_au();
    }

    @Nullable
    public EntityPlayer getOwner() {
        return this.owner == null ? null : this.field_145850_b.func_152378_a(this.owner);
    }

    private void resetTimer() {
        this.resetTimer(true);
    }

    private void resetTimer(boolean update) {
        if (this.spawnDelay == null) {
            return;
        }
        this.lastTimeTillCraft = this.timeTillCraft = (float)this.spawnDelay.getInt(this.field_145850_b.field_73012_v) * (this.container == null ? 1.0f : this.container.time);
        this.remainingMobs.clear();
        this.remainingMobs.putAll(this.mobsRequired);
        if (update) {
            this.blockUpdate();
        }
    }

    public void updateActivationAmount() {
        this.activationAmount = 0.0;
        if (!this.isConnected) {
            return;
        }
        if (this.field_145850_b.func_175687_A(this.field_174879_c) != 0) {
            return;
        }
        if (!this.hasValidRecipe()) {
            return;
        }
        double poofChance = ComposerTileEntity.CONFIG.poofChance.get((double)((Integer)this.upgrades.get(Composer.Upgrade.EFFICIENCY)).intValue() / (double)Composer.Upgrade.EFFICIENCY.getMaxQuantity());
        this.poofChance = (float)((double)this.poofChance + poofChance);
        for (EntityLivingBase entity : this.getConsumableEntities().values()) {
            this.activationAmount += 1.0;
            if (this.field_145850_b.field_72995_K || !this.isConnected || !this.hasValidRecipe() || !((double)this.poofChance > this.field_145850_b.field_73012_v.nextDouble())) continue;
            this.poofChance = 0.0f;
            this.poofEntity(entity);
        }
    }

    private Map<String, EntityLivingBase> getConsumableEntities() {
        HashMap<String, EntityLivingBase> consumableEntities = new HashMap<String, EntityLivingBase>();
        EnumFacing facing = ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)Composer.FACING)).func_176734_d();
        AxisAlignedBB activationBox = new AxisAlignedBB(this.field_174879_c.func_177967_a(facing, 3)).func_186662_g((double)this.activatingRange);
        for (EntityLivingBase entity : this.field_145850_b.func_72872_a(EntityLivingBase.class, activationBox)) {
            int whitelistLevel;
            ResourceLocation entityType;
            boolean blacklistAll;
            boolean whitelistAll = this.mobWhitelist == null ? false : this.mobWhitelist.contains("*");
            boolean bl = blacklistAll = this.mobBlacklist == null ? false : this.mobBlacklist.contains("*");
            if (entity instanceof EntityPlayer || consumableEntities.containsKey((entityType = EntityList.func_191301_a((Entity)entity)).toString()) || (whitelistLevel = (whitelistAll ? 1 : 0) + (this.mobWhitelist != null && this.mobWhitelist.contains(entityType.func_110624_b() + ":*") ? 2 : 0) + (this.mobWhitelist != null && this.mobWhitelist.contains(entityType.toString()) ? 4 : 0) - (blacklistAll ? 1 : 0) - (this.mobBlacklist != null && this.mobBlacklist.contains(entityType.func_110624_b() + ":*") ? 2 : 0) - (this.mobBlacklist != null && this.mobBlacklist.contains(entityType.toString()) ? 4 : 0)) < 0) continue;
            consumableEntities.put(entityType.toString(), entity);
        }
        return consumableEntities;
    }

    private void poofEntity(EntityLivingBase entity) {
        entity.func_70106_y();
        ComposerTileEntity.mobPoofParticles(this.field_145850_b, this.field_174879_c);
        ComposerTileEntity.mobPoofParticles(this.field_145850_b, entity.func_180425_c());
        this.field_145850_b.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187515_aE, SoundCategory.NEUTRAL, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.6f);
        String entityType = EntityList.func_191301_a((Entity)entity).toString();
        if (this.remainingMobs.containsKey(entityType)) {
            int count = this.remainingMobs.get(entityType) - 1;
            if (count <= 0) {
                this.remainingMobs.remove(entityType);
            } else {
                this.remainingMobs.put(entityType, count);
            }
            this.blockUpdate();
        }
    }

    public void func_73660_a() {
        if (this.timeTillNextMajorUpdate-- < 0) {
            this.timeTillNextMajorUpdate = 20;
            this.validateStructure();
            this.updateActivationAmount();
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateRenderer(this.activationAmount);
        } else {
            if (this.needsRecipeRefresh) {
                this.refreshRecipe();
            }
            this.updateSignalStrength(this.activationAmount);
        }
        this.timeTillCraft = (float)((double)this.timeTillCraft - this.activationAmount);
        if (this.timeTillCraft <= 0.0f) {
            if (this.hasValidRecipe()) {
                if (!this.processRequiredMobs()) {
                    this.timeTillCraft += 20.0f;
                    return;
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.completeCraft();
                }
            }
            this.resetTimer();
        }
    }

    private boolean processRequiredMobs() {
        if (this.remainingMobs.size() == 0) {
            return true;
        }
        Map<String, EntityLivingBase> consumableEntities = this.getConsumableEntities();
        for (Map.Entry<String, Integer> requiredEntity : this.remainingMobs.entrySet()) {
            EntityLivingBase entity = consumableEntities.get(requiredEntity.getKey());
            if (entity == null) continue;
            this.poofEntity(entity);
            break;
        }
        return this.remainingMobs.size() == 0;
    }

    private void updateSignalStrength(double activationAmount) {
        int signalStrength;
        int n = signalStrength = activationAmount > 0.0 ? (int)Math.floor(15.0f * this.getCompositionPercent()) + 1 : 0;
        if (signalStrength != this.signalStrength) {
            this.signalStrength = signalStrength;
            this.func_70296_d();
        }
    }

    public void validateStructure() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing currentDirection = (EnumFacing)state.func_177229_b((IProperty)Composer.FACING);
        EnumFacing direction = this.getBlock().validateStructure(this.field_145850_b, this.field_174879_c, currentDirection);
        if (this.isConnected != (direction != null)) {
            this.isConnected = direction != null;
            this.needsRecipeRefresh = true;
        }
        boolean changedState = false;
        if (this.isConnected && currentDirection != direction) {
            state = state.func_177226_a((IProperty)Composer.FACING, (Comparable)direction);
            currentDirection = direction;
            changedState = true;
        }
        if ((Boolean)state.func_177229_b((IProperty)Composer.CONNECTED) != this.isConnected) {
            state = state.func_177226_a((IProperty)Composer.CONNECTED, (Comparable)Boolean.valueOf(this.isConnected));
            changedState = true;
            if (this.isConnected) {
                this.connectCells(direction, state);
                Advancements.CONSTRUCT.trigger(this.getOwner(), this.getBlock());
            } else {
                this.disconnectCells(currentDirection);
            }
            this.needsRecipeRefresh = true;
        }
        if (changedState) {
            this.field_145850_b.func_180501_a(this.field_174879_c, state, 3);
        }
    }

    private void disconnectCells(EnumFacing direction) {
        this.getBlock().structure.loopBlocks(this.field_145850_b, this.field_174879_c, direction, (cellPos, validator) -> {
            IBlockState cellState = this.field_145850_b.func_180495_p(cellPos);
            if (cellState.func_177230_c() == BlockRegistry.COMPOSER_CELL) {
                ComposerCellTileEntity ccte = (ComposerCellTileEntity)this.field_145850_b.func_175625_s(cellPos);
                cellState = cellState.func_177226_a(ComposerCell.CELL_STATE, (Comparable)((Object)ComposerCell.CellState.DISCONNECTED));
                this.field_145850_b.func_180501_a(cellPos, cellState, 3);
                ccte.composerLocation = null;
                ccte.changeComposerCooldown = 20;
                ccte.slot = (byte)-1;
                ccte.blockUpdate();
                ccte.onChangeItem(null);
            }
            return null;
        });
        this.cellMap.clear();
    }

    private void connectCells(EnumFacing direction, IBlockState state) {
        BlockPos center = direction == null ? null : this.field_174879_c.func_177967_a(direction, -3);
        BlockPos x = direction == null ? null : BlockPos.field_177992_a.func_177967_a(direction, 1);
        BlockPos z = direction == null ? null : BlockPos.field_177992_a.func_177967_a(direction.func_176746_e(), 1);
        BlockPos topLeft = direction == null ? null : this.offset(this.offset(this.field_174879_c, x, -4.0), z, -1.0);
        this.cellMap.clear();
        for (int iz = 0; iz < 3; ++iz) {
            for (int ix = 0; ix < 3; ++ix) {
                BlockPos cellPos2 = this.offset(this.offset(topLeft, x, ix), z, iz);
                this.cellMap.put(cellPos2, (byte)(ix + iz * 3));
            }
        }
        if (direction == EnumFacing.UP || direction == EnumFacing.DOWN) {
            return;
        }
        this.getBlock().structure.loopBlocks(this.field_145850_b, this.field_174879_c, direction, (cellPos, validator) -> {
            IBlockState cellBlockState = this.field_145850_b.func_180495_p(cellPos);
            if (cellBlockState.func_177230_c() == BlockRegistry.COMPOSER_CELL) {
                ComposerCellTileEntity ccte = (ComposerCellTileEntity)this.field_145850_b.func_175625_s(cellPos);
                ComposerCell.CellState cellState = cellPos.equals((Object)center) ? ComposerCell.CellState.CONNECTED_CENTER : ComposerCell.CellState.CONNECTED_EDGE;
                this.field_145850_b.func_180501_a(cellPos, cellBlockState.func_177226_a(ComposerCell.CELL_STATE, (Comparable)((Object)cellState)), 3);
                ccte.composerLocation = this.field_174879_c;
                ccte.changeComposerCooldown = 20;
                ccte.slot = this.cellMap.get(cellPos);
                ccte.blockUpdate();
                ccte.onChangeItem(this::updateCCTEItem);
            }
            return null;
        });
    }

    private BlockPos offset(BlockPos a, BlockPos b, double amt) {
        return a.func_177963_a((double)b.func_177958_n() * amt, (double)b.func_177956_o() * amt, (double)b.func_177952_p() * amt);
    }

    public float getCompositionPercent() {
        return (this.lastTimeTillCraft - this.timeTillCraft) / this.lastTimeTillCraft;
    }

    public boolean loopComposerCells(ComposerCellHandler handler) {
        for (Map.Entry<BlockPos, Byte> composerCell : this.cellMap.entrySet()) {
            TileEntity te = this.field_145850_b.func_175625_s(composerCell.getKey());
            if (te == null || !(te instanceof ComposerCellTileEntity)) {
                return false;
            }
            ComposerCellTileEntity ccte = (ComposerCellTileEntity)te;
            Boolean result = handler.handle(ccte);
            if (result == null) continue;
            return result;
        }
        return true;
    }

    public void completeCraft() {
        if (!this.loopComposerCells(ccte -> null)) {
            this.validateStructure();
            if (!this.isConnected) {
                return;
            }
        }
        ItemStack result = this.getStoredItem();
        ComposerTileEntity.dispenseItem(result.func_77946_l(), this.field_145850_b, this.field_174879_c, (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)Composer.FACING));
        Advancements.COMPOSE.trigger(this.getOwner(), this.container.lastRecipe.getRegistryName().toString());
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187704_k, SoundCategory.NEUTRAL, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.6f);
        this.loopComposerCells(ccte -> {
            if (ccte.storedItem == null) {
                return null;
            }
            --ccte.storedQuantity;
            Item storedItem = ccte.storedItem.func_77973_b();
            if (storedItem.hasContainerItem(ccte.storedItem)) {
                ItemStack containerItem = storedItem.getContainerItem(ccte.storedItem);
                ComposerTileEntity.dispenseItem(containerItem, this.field_145850_b, ccte.func_174877_v(), EnumFacing.DOWN);
            }
            if (ccte.storedQuantity <= 0) {
                ccte.storedQuantity = 0;
                ccte.storedItem = null;
                if (this.container == null || this.container.craftingMatrix == null) {
                    this.refreshContainer();
                }
                this.container.craftingMatrix.func_70299_a((int)ccte.slot, ItemStack.field_190927_a);
            }
            ccte.blockUpdate();
            return null;
        });
    }

    private void onUpdateUpgrades() {
        this.onUpdateUpgrades(false);
    }

    @Override
    public void onUpdateUpgrades(boolean readFromNBT) {
        if (this.func_145837_r()) {
            Soulus.removeConfigReloadHandler(this::onUpdateUpgrades);
            return;
        }
        Soulus.onConfigReload(this::onUpdateUpgrades);
        int delayUpgrades = (Integer)this.upgrades.get(Composer.Upgrade.DELAY);
        this.spawnDelay = new Range(ComposerTileEntity.CONFIG.nonUpgradedDelay.min / (1.0 + (double)delayUpgrades * ComposerTileEntity.CONFIG.upgradeDelayEffectiveness.min), ComposerTileEntity.CONFIG.nonUpgradedDelay.max / (1.0 + (double)delayUpgrades * ComposerTileEntity.CONFIG.upgradeDelayEffectiveness.max));
        int rangeUpgrades = (Integer)this.upgrades.get(Composer.Upgrade.RANGE);
        this.activatingRange = ComposerTileEntity.CONFIG.nonUpgradedRange + rangeUpgrades * ComposerTileEntity.CONFIG.upgradeRangeEffectiveness;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!readFromNBT) {
                this.resetTimer(false);
            }
            this.blockUpdate();
        }
    }

    @Override
    public void onWriteToNBT(NBTTagCompound compound) {
        String recipe;
        compound.func_74757_a("connected", this.isConnected);
        compound.func_74776_a("delay", this.timeTillCraft);
        compound.func_74776_a("delay_last", this.lastTimeTillCraft);
        compound.func_74776_a("poof_chance", this.poofChance);
        if (this.owner != null) {
            compound.func_74778_a("owner", this.owner.toString());
        }
        NBTTagCompound cellTag = new NBTTagCompound();
        for (Map.Entry<BlockPos, Byte> cell : this.cellMap.entrySet()) {
            NBTTagCompound posTag = new NBTTagCompound();
            posTag.func_74768_a("x", cell.getKey().func_177958_n());
            posTag.func_74768_a("y", cell.getKey().func_177956_o());
            posTag.func_74768_a("z", cell.getKey().func_177952_p());
            cellTag.func_74782_a(cell.getValue().toString(), (NBTBase)posTag);
        }
        compound.func_74782_a("cell_map", (NBTBase)cellTag);
        NBTTagCompound mobsTag = new NBTTagCompound();
        this.remainingMobs.entrySet().forEach(requiredMob -> mobsTag.func_74768_a((String)requiredMob.getKey(), ((Integer)requiredMob.getValue()).intValue()));
        compound.func_74782_a("required_mobs", (NBTBase)mobsTag);
        String string = recipe = this.container == null || this.container.lastRecipe == null ? null : this.container.lastRecipe.getRegistryName().toString();
        if (recipe != null) {
            compound.func_74778_a("recipe", recipe);
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            compound.func_74782_a("crafting_item", (NBTBase)this.getStoredItem().func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void onReadFromNBT(NBTTagCompound compound) {
        IRecipe recipe;
        this.isConnected = compound.func_74767_n("connected");
        this.timeTillCraft = compound.func_74760_g("delay");
        this.lastTimeTillCraft = compound.func_74760_g("delay_last");
        this.poofChance = compound.func_74760_g("poof_chance");
        String ownerString = compound.func_74779_i("owner");
        this.owner = ownerString == "" ? null : UUID.fromString(ownerString);
        NBTTagCompound cellTag = compound.func_74775_l("cell_map");
        Integer slot = 0;
        while (slot < 9) {
            Object posTag = cellTag.func_74775_l(slot.toString());
            this.cellMap.put(new BlockPos(posTag.func_74762_e("x"), posTag.func_74762_e("y"), posTag.func_74762_e("z")), (byte)slot.intValue());
            posTag = slot;
            Integer n = slot = Integer.valueOf(slot + 1);
        }
        this.remainingMobs.clear();
        NBTTagCompound mobsTag = compound.func_74775_l("required_mobs");
        mobsTag.func_150296_c().forEach(key -> this.remainingMobs.put((String)key, mobsTag.func_74762_e(key)));
        if (compound.func_150297_b("recipe", 8) && (recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(new ResourceLocation(compound.func_74779_i("recipe")))) != null && recipe instanceof IRecipeComposer) {
            IRecipeComposer composerRecipe = (IRecipeComposer)recipe;
            this.mobWhitelist = composerRecipe.getMobWhitelist();
            this.mobBlacklist = composerRecipe.getMobBlacklist();
        }
        this.needsRecipeRefresh = true;
        this.isInitialRecipeRefresh = true;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.renderItem = new ItemStack(compound.func_74775_l("crafting_item"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isPlayerInRangeForEffects() {
        return this.field_145850_b.func_175636_b((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRenderer(double activationAmount) {
        double diff = this.itemRotation - this.prevItemRotation;
        this.prevItemRotation = this.itemRotation;
        this.itemRotation += activationAmount <= 0.0 ? diff * 0.9 : (double)(1.0f * this.getCompositionPercent()) + diff * 0.8;
        if (!this.hasValidRecipe() || !this.isPlayerInRangeForEffects() || activationAmount == 0.0) {
            return;
        }
        double particleCount = ComposerTileEntity.CONFIG.particleCountActivated * Math.max(1.0, Math.min((double)ComposerTileEntity.CONFIG.particleCountMax, activationAmount)) * (0.5 + (double)(this.getCompositionPercent() / 2.0f));
        if (particleCount < 1.0) {
            this.timeTillParticle += 0.01 + particleCount;
            if (this.timeTillParticle < 1.0) {
                return;
            }
        }
        this.timeTillParticle = 0.0;
        int i = 0;
        while ((double)i < ComposerTileEntity.CONFIG.particleCountActivated) {
            double d3 = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
            double d4 = (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
            double d5 = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
            this.field_145850_b.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, d3 - (double)this.field_174879_c.func_177958_n() - 0.5, -0.3, d5 - (double)this.field_174879_c.func_177952_p() - 0.5, new int[0]);
            ++i;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double getItemRotation() {
        return this.itemRotation;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double getPrevItemRotation() {
        return this.prevItemRotation;
    }

    @Override
    public ItemStack getStoredItem() {
        if (this.renderItem != null) {
            return this.renderItem;
        }
        if (this.container == null) {
            return ItemStack.field_190927_a;
        }
        return this.container.craftResult.func_70301_a(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldComplexRotate() {
        return true;
    }

    public static void mobPoofParticles(World world, BlockPos pos) {
        if (world.field_72995_K) {
            ComposerTileEntity.particles(pos);
        } else {
            SoulsPacketHandler.INSTANCE.sendToAllAround((IMessage)new MobPoof(pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 128.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void particles(BlockPos pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Random rand = world.field_73012_v;
        for (int i = 0; i < ComposerTileEntity.CONFIG.particleCountMobPoof; ++i) {
            double d3 = (float)pos.func_177958_n() - 0.5f + rand.nextFloat();
            double d4 = (float)pos.func_177956_o() + rand.nextFloat();
            double d5 = (float)pos.func_177952_p() - 0.5f + rand.nextFloat();
            double d3o = (d3 - (double)pos.func_177958_n()) / 4.0;
            double d4o = (d4 - (double)pos.func_177956_o()) / 5.0;
            double d5o = (d5 - (double)pos.func_177952_p()) / 4.0;
            world.func_175720_a(ParticleType.MOB_POOF.getId(), false, d3 + 0.5, d4, d5 + 0.5, d3o, d4o, d5o, new int[]{1});
        }
    }

    public void refreshRecipe() {
        this.needsRecipeRefresh = false;
        if (this.container == null) {
            this.refreshContainer();
        }
        if (this.isConnected) {
            this.loopComposerCells(ccte -> this.updateCCTEItem(ccte, false));
        } else {
            this.container.craftResult.func_174888_l();
        }
        this.isInitialRecipeRefresh = false;
        this.blockUpdate();
    }

    public void refreshContainer() {
        this.uuid = UUID.randomUUID();
        this.fakePlayer = new FakePlayer((WorldServer)this.field_145850_b, new GameProfile(this.uuid, "composer_tile_entity"));
        this.container = new ComposerContainer(this.field_145850_b, (EntityPlayer)this.fakePlayer);
        this.container.onRecipeChanged(recipe -> {
            this.mobsRequired.clear();
            this.mobWhitelist = ComposerTileEntity.CONFIG.whitelistedCreatures;
            this.mobBlacklist = ComposerTileEntity.CONFIG.blacklistedCreatures;
            if (recipe instanceof IRecipeComposer) {
                IRecipeComposer composerRecipe = (IRecipeComposer)recipe;
                Map<String, Integer> mobsRequired = composerRecipe.getMobsRequired();
                if (mobsRequired != null) {
                    this.mobsRequired.putAll(mobsRequired);
                }
                this.mobWhitelist = composerRecipe.getMobWhitelist();
                this.mobBlacklist = composerRecipe.getMobBlacklist();
            }
            if (!this.isInitialRecipeRefresh) {
                this.resetTimer();
            }
        });
    }

    public Boolean updateCCTEItem(ComposerCellTileEntity ccte, boolean blockUpdate) {
        ccte.onChangeItem(this::updateCCTEItem);
        this.container.craftingMatrix.func_70299_a((int)ccte.slot, ccte.storedItem == null ? ItemStack.field_190927_a : ccte.storedItem);
        if (blockUpdate) {
            this.blockUpdate();
        }
        return null;
    }

    public Boolean updateCCTEItem(ComposerCellTileEntity ccte) {
        return this.updateCCTEItem(ccte, true);
    }

    public static class ComposerContainer
    extends Container {
        public InventoryCrafting craftingMatrix;
        public InventoryCraftResult craftResult;
        public float time = 1.0f;
        private final World world;
        private final EntityPlayer player;
        private RecipeChangedHandler recipeChangedHandler;
        private IRecipe lastRecipe;

        public ComposerContainer(World world, EntityPlayer player) {
            this.world = world;
            this.player = player;
            this.craftingMatrix = new CraftingMatrix(this, 3, 3);
            this.craftResult = new InventoryCraftResult();
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }

        public void func_75130_a(IInventory inventoryIn) {
            this.func_192389_a(this.world, this.player, this.craftingMatrix, this.craftResult);
        }

        protected void func_192389_a(World world, EntityPlayer player, InventoryCrafting craftingMatrix, InventoryCraftResult craftResult) {
            if (!world.field_72995_K) {
                ItemStack stack = ItemStack.field_190927_a;
                IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)craftingMatrix, (World)world);
                if (recipe != null) {
                    craftResult.func_193056_a(recipe);
                    this.time = 1.0f;
                    if (recipe instanceof IRecipeComposer) {
                        this.time = ((IRecipeComposer)recipe).getTime();
                    }
                    stack = recipe.func_77572_b(craftingMatrix);
                    if (recipe != this.lastRecipe && this.recipeChangedHandler != null) {
                        this.recipeChangedHandler.handle(recipe);
                    }
                }
                this.lastRecipe = recipe;
                craftResult.func_70299_a(0, stack);
            }
        }

        public void onRecipeChanged(RecipeChangedHandler handler) {
            this.recipeChangedHandler = handler;
        }

        public static interface RecipeChangedHandler {
            public void handle(IRecipe var1);
        }

        public static class CraftingMatrix
        extends InventoryCrafting {
            public CraftingMatrix(ComposerContainer c, int width, int height) {
                super((Container)c, width, height);
            }
        }
    }

    public static interface ComposerCellHandler {
        public Boolean handle(ComposerCellTileEntity var1);
    }
}

