/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.entity;

import com.setycz.chickens.block.TileEntityHenhouse;
import com.setycz.chickens.handler.SpawnType;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EntityChickensChicken
extends EntityChicken {
    private static final DataParameter<String> CHICKEN_TYPE = EntityDataManager.func_187226_a(EntityChickensChicken.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> CHICKEN_STATS_ANALYZED = EntityDataManager.func_187226_a(EntityChickensChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CHICKEN_GROWTH = EntityDataManager.func_187226_a(EntityChickensChicken.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CHICKEN_GAIN = EntityDataManager.func_187226_a(EntityChickensChicken.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CHICKEN_STRENGTH = EntityDataManager.func_187226_a(EntityChickensChicken.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LAY_PROGRESS = EntityDataManager.func_187226_a(EntityChickensChicken.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final String TYPE_NBT = "Type";
    private static final String CHICKEN_STATS_ANALYZED_NBT = "Analyzed";
    private static final String CHICKEN_GROWTH_NBT = "Growth";
    private static final String CHICKEN_GAIN_NBT = "Gain";
    private static final String CHICKEN_STRENGTH_NBT = "Strength";

    public EntityChickensChicken(World worldIn) {
        super(worldIn);
    }

    public boolean getStatsAnalyzed() {
        return (Boolean)this.field_70180_af.func_187225_a(CHICKEN_STATS_ANALYZED);
    }

    public void setStatsAnalyzed(boolean statsAnalyzed) {
        this.field_70180_af.func_187227_b(CHICKEN_STATS_ANALYZED, (Object)statsAnalyzed);
    }

    public int getGain() {
        return (Integer)this.field_70180_af.func_187225_a(CHICKEN_GAIN);
    }

    private void setGain(int gain) {
        this.field_70180_af.func_187227_b(CHICKEN_GAIN, (Object)gain);
    }

    public int getGrowth() {
        return (Integer)this.field_70180_af.func_187225_a(CHICKEN_GROWTH);
    }

    private void setGrowth(int growth) {
        this.field_70180_af.func_187227_b(CHICKEN_GROWTH, (Object)growth);
    }

    public int getStrength() {
        return (Integer)this.field_70180_af.func_187225_a(CHICKEN_STRENGTH);
    }

    private void setStrength(int strength) {
        this.field_70180_af.func_187227_b(CHICKEN_STRENGTH, (Object)strength);
    }

    public ResourceLocation getTexture() {
        ChickensRegistryItem chickenDescription = this.getChickenDescription();
        return chickenDescription.getTexture();
    }

    private ChickensRegistryItem getChickenDescription() {
        ChickensRegistryItem description = ChickensRegistry.getByRegistryName(this.getChickenTypeInternal());
        if (!(description != null && description.isEnabled() || (description = ChickensRegistry.getByResourceLocation(ChickensRegistry.SMART_CHICKEN_ID)).isEnabled())) {
            this.func_70623_bb();
        }
        return description;
    }

    public int getTier() {
        return this.getChickenDescription().getTier();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        ChickensRegistryItem chickenDescription = this.getChickenDescription();
        return I18n.func_74838_a((String)("entity." + chickenDescription.getEntityName() + ".name"));
    }

    public EntityChicken func_90011_a(EntityAgeable ageable) {
        boolean mutatingStats;
        ChickensRegistryItem mateChickenDescription;
        EntityChickensChicken mateChicken = (EntityChickensChicken)ageable;
        ChickensRegistryItem chickenDescription = this.getChickenDescription();
        ChickensRegistryItem childToBeBorn = ChickensRegistry.getRandomChild(chickenDescription, mateChickenDescription = mateChicken.getChickenDescription());
        if (childToBeBorn == null) {
            return null;
        }
        EntityChickensChicken newChicken = new EntityChickensChicken(this.field_70170_p);
        newChicken.setChickenType(childToBeBorn.getRegistryName().toString());
        boolean bl = mutatingStats = chickenDescription.getRegistryName() == mateChickenDescription.getRegistryName() && childToBeBorn.getRegistryName() == chickenDescription.getRegistryName();
        if (mutatingStats) {
            EntityChickensChicken.increaseStats(newChicken, this, mateChicken, this.field_70146_Z);
        } else if (chickenDescription.getRegistryName() == childToBeBorn.getRegistryName()) {
            EntityChickensChicken.inheritStats(newChicken, this);
        } else if (mateChickenDescription.getRegistryName() == childToBeBorn.getRegistryName()) {
            EntityChickensChicken.inheritStats(newChicken, mateChicken);
        }
        return newChicken;
    }

    private static void inheritStats(EntityChickensChicken newChicken, EntityChickensChicken parent) {
        newChicken.setGrowth(parent.getGrowth());
        newChicken.setGain(parent.getGain());
        newChicken.setStrength(parent.getStrength());
    }

    private static void increaseStats(EntityChickensChicken newChicken, EntityChickensChicken parent1, EntityChickensChicken parent2, Random rand) {
        int parent1Strength = parent1.getStrength();
        int parent2Strength = parent2.getStrength();
        newChicken.setGrowth(EntityChickensChicken.calculateNewStat(parent1Strength, parent2Strength, parent1.getGrowth(), parent2.getGrowth(), rand));
        newChicken.setGain(EntityChickensChicken.calculateNewStat(parent1Strength, parent2Strength, parent2.getGain(), parent2.getGain(), rand));
        newChicken.setStrength(EntityChickensChicken.calculateNewStat(parent1Strength, parent2Strength, parent1Strength, parent2Strength, rand));
    }

    private static int calculateNewStat(int thisStrength, int mateStrength, int stat1, int stat2, Random rand) {
        int mutation = rand.nextInt(2) + 1;
        int newStatValue = (stat1 * thisStrength + stat2 * mateStrength) / (thisStrength + mateStrength) + mutation;
        if (newStatValue <= 1) {
            return 1;
        }
        if (newStatValue >= 10) {
            return 10;
        }
        return newStatValue;
    }

    public void func_70636_d() {
        if (!(this.field_70170_p.field_72995_K || this.func_70631_g_() || this.func_152116_bZ())) {
            int newTimeUntilNextEgg = this.field_70887_j - 1;
            this.setTimeUntilNextEgg(newTimeUntilNextEgg);
            if (newTimeUntilNextEgg <= 1) {
                ChickensRegistryItem chickenDescription = this.getChickenDescription();
                ItemStack itemToLay = chickenDescription.createLayItem();
                int gain = this.getGain();
                if (gain >= 5) {
                    itemToLay.func_190917_f(chickenDescription.createLayItem().func_190916_E());
                }
                if (gain >= 10) {
                    itemToLay.func_190917_f(chickenDescription.createLayItem().func_190916_E());
                }
                if (!(itemToLay = TileEntityHenhouse.pushItemStack(itemToLay, this.field_70170_p, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))).func_190926_b()) {
                    this.func_70099_a(chickenDescription.createLayItem(), 0.0f);
                    this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                this.resetTimeUntilNextEgg();
            }
        }
        super.func_70636_d();
    }

    private void setTimeUntilNextEgg(int value) {
        this.field_70887_j = value;
        this.updateLayProgress();
    }

    public int getLayProgress() {
        return (Integer)this.field_70180_af.func_187225_a(LAY_PROGRESS);
    }

    private void updateLayProgress() {
        this.field_70180_af.func_187227_b(LAY_PROGRESS, (Object)(this.field_70887_j / 60 / 20 / 2));
    }

    private void resetTimeUntilNextEgg() {
        ChickensRegistryItem chickenDescription = this.getChickenDescription();
        int newBaseTimeUntilNextEgg = chickenDescription.getMinLayTime() + this.field_70146_Z.nextInt(chickenDescription.getMaxLayTime() - chickenDescription.getMinLayTime());
        int newTimeUntilNextEgg = (int)Math.max(1.0f, (float)newBaseTimeUntilNextEgg * (10.0f - (float)this.getGrowth() + 1.0f) / 10.0f);
        this.setTimeUntilNextEgg(newTimeUntilNextEgg * 2);
    }

    public boolean func_70601_bi() {
        boolean anyInNether = ChickensRegistry.isAnyIn(SpawnType.HELL);
        boolean anyInOverworld = ChickensRegistry.isAnyIn(SpawnType.NORMAL) || ChickensRegistry.isAnyIn(SpawnType.SNOW);
        Biome biome = this.field_70170_p.getBiomeForCoordsBody(this.func_180425_c());
        return anyInNether && biome == Biomes.field_76778_j || anyInOverworld && super.func_70601_bi();
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        if ((livingData = super.func_180482_a(difficulty, livingData)) instanceof GroupData) {
            GroupData groupData = (GroupData)livingData;
            this.setChickenType(groupData.getType());
        } else {
            SpawnType spawnType = this.getSpawnType();
            List<ChickensRegistryItem> possibleChickens = ChickensRegistry.getPossibleChickensToSpawn(spawnType);
            if (possibleChickens.size() > 0) {
                ChickensRegistryItem chickenToSpawn = possibleChickens.get(this.field_70146_Z.nextInt(possibleChickens.size()));
                String type = chickenToSpawn.getRegistryName().toString();
                this.setChickenType(type);
                livingData = new GroupData(type);
            }
        }
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70873_a(-24000);
        }
        return livingData;
    }

    private SpawnType getSpawnType() {
        Biome biome = this.field_70170_p.getBiomeForCoordsBody(this.func_180425_c());
        return ChickensRegistry.getSpawnType(biome);
    }

    public void setChickenType(String registryName) {
        this.setChickenTypeInternal(registryName);
        this.field_70178_ae = this.getChickenDescription().isImmuneToFire();
        this.resetTimeUntilNextEgg();
    }

    private void setChickenTypeInternal(String registryName) {
        this.field_70180_af.func_187227_b(CHICKEN_TYPE, (Object)registryName);
    }

    private String getChickenTypeInternal() {
        return (String)this.field_70180_af.func_187225_a(CHICKEN_TYPE);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHICKEN_TYPE, (Object)"");
        this.field_70180_af.func_187214_a(CHICKEN_GROWTH, (Object)1);
        this.field_70180_af.func_187214_a(CHICKEN_GAIN, (Object)1);
        this.field_70180_af.func_187214_a(CHICKEN_STRENGTH, (Object)1);
        this.field_70180_af.func_187214_a(LAY_PROGRESS, (Object)0);
        this.field_70180_af.func_187214_a(CHICKEN_STATS_ANALYZED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74778_a(TYPE_NBT, this.getChickenTypeInternal());
        tagCompound.func_74757_a(CHICKEN_STATS_ANALYZED_NBT, this.getStatsAnalyzed());
        tagCompound.func_74768_a(CHICKEN_GROWTH_NBT, this.getGrowth());
        tagCompound.func_74768_a(CHICKEN_GAIN_NBT, this.getGain());
        tagCompound.func_74768_a(CHICKEN_STRENGTH_NBT, this.getStrength());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setChickenTypeInternal(tagCompound.func_74779_i(TYPE_NBT));
        this.setStatsAnalyzed(tagCompound.func_74767_n(CHICKEN_STATS_ANALYZED_NBT));
        this.setGrowth(this.getStatusValue(tagCompound, CHICKEN_GROWTH_NBT));
        this.setGain(this.getStatusValue(tagCompound, CHICKEN_GAIN_NBT));
        this.setStrength(this.getStatusValue(tagCompound, CHICKEN_STRENGTH_NBT));
        this.updateLayProgress();
    }

    private int getStatusValue(NBTTagCompound compound, String statusName) {
        return compound.func_74764_b(statusName) ? compound.func_74762_e(statusName) : 1;
    }

    public int func_70627_aG() {
        return 1200;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if ((double)this.field_70146_Z.nextFloat() > 0.1) {
            return;
        }
        super.func_180429_a(pos, blockIn);
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        ItemStack itemsToDrop = this.getChickenDescription().createDropItem();
        int count = 1 + this.field_70146_Z.nextInt(1 + lootingModifier);
        itemsToDrop.func_190920_e(itemsToDrop.func_190916_E() * count);
        this.func_70099_a(itemsToDrop, 0.0f);
        if (this.func_70027_ad()) {
            this.func_145779_a(Items.field_151077_bg, 1);
        } else {
            this.func_145779_a(Items.field_151076_bf, 1);
        }
    }

    public void func_70873_a(int age) {
        int loveAge;
        boolean resetLoveAfterBreeding;
        boolean resetToChild;
        int childAge = -24000;
        boolean bl = resetToChild = age == childAge;
        if (resetToChild) {
            age = Math.min(-1, childAge * (10 - this.getGrowth() + 1) / 10);
        }
        boolean bl2 = resetLoveAfterBreeding = age == (loveAge = 6000);
        if (resetLoveAfterBreeding) {
            age = Math.max(1, loveAge * (10 - this.getGrowth() + 1) / 10);
        }
        super.func_70873_a(age);
    }

    private static class GroupData
    implements IEntityLivingData {
        private final String type;

        public GroupData(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

