/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.config;

import com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.config.ConfigManager;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;

public class CommandConfigReload
extends CommandBase {
    private final String name;
    private final Class<?> configClass;
    private final ConfigReloader reloader;
    private final boolean isClient;
    private final String successMessage;

    public CommandConfigReload(String name, Class<?> configClass, Side side) {
        this(name, configClass, side, null);
    }

    public CommandConfigReload(String name, Class<?> configClass, Side side, String successMessage) {
        this(name, configClass, null, side, successMessage);
    }

    public CommandConfigReload(String name, Class<?> configClass, ConfigReloader reloader, Side side) {
        this(name, configClass, reloader, side, null);
    }

    public CommandConfigReload(String name, Class<?> configClass, ConfigReloader reloader, Side side, String successMessage) {
        this.name = name;
        this.configClass = configClass;
        this.reloader = reloader;
        this.isClient = side.isClient();
        this.successMessage = successMessage;
    }

    public String func_71517_b() {
        return this.name;
    }

    public String func_71518_a(ICommandSender sender) {
        return this.successMessage == null || this.isClient ? "commands." + this.name + ".usage" : "/" + this.name;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (this.reloader != null) {
            this.reloader.reload(ReloadPhase.PRE, (ICommand)this, sender);
        }
        ConfigManager.reloadFromDisk(this.configClass);
        if (this.reloader != null) {
            this.reloader.reload(ReloadPhase.POST, (ICommand)this, sender);
        }
        if (this.successMessage != null && server != null && server.func_71262_S()) {
            CommandConfigReload.func_152373_a((ICommandSender)sender, (ICommand)this, (String)this.successMessage, (Object[])new Object[0]);
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands." + this.name + ".success", new Object[0]));
        }
    }

    public int func_82362_a() {
        return this.isClient ? 0 : 4;
    }

    @FunctionalInterface
    public static interface ConfigReloader {
        public void reload(ReloadPhase var1, ICommand var2, ICommandSender var3);
    }

    public static enum ReloadPhase {
        PRE,
        POST;

    }
}

