/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.therandomlabs.randomtweaks.RandomTweaks;
import com.therandomlabs.randomtweaks.config.RTConfig;
import com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.TRLUtils;
import java.lang.reflect.Method;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class SleepHandler {
    public static final Method SET_SIZE = TRLUtils.findMethod(Entity.class, "setSize", "func_70105_a", Float.TYPE, Float.TYPE);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSleep(PlayerSleepInBedEvent event) {
        IBlockState state;
        if (!RTConfig.Misc.allowSleepNearMobsWithCustomNames && !RTConfig.Misc.disableBedProximityRequirement) {
            return;
        }
        EntityPlayer.SleepResult result = event.getResultStatus();
        if (result == EntityPlayer.SleepResult.OTHER_PROBLEM || result == EntityPlayer.SleepResult.OK) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        EnumFacing facing = null;
        try {
            IBlockState iBlockState = state = world.func_175667_e(pos) ? world.func_180495_p(pos) : null;
            if (state != null) {
                ResourceLocation name = state.func_177230_c().getRegistryName();
                if (name != null && name.toString().startsWith("comforts:hammock")) {
                    return;
                }
                facing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            }
        }
        catch (IllegalArgumentException ex) {
            state = null;
            facing = null;
        }
        if (player.func_70608_bn() || !player.func_70089_S()) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
            return;
        }
        if (!world.field_73011_w.func_76569_d()) {
            event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_HERE);
            return;
        }
        if (world.func_72935_r()) {
            event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_NOW);
            return;
        }
        if (!RTConfig.Misc.disableBedProximityRequirement && !player.func_190774_a(pos, facing)) {
            event.setResult(EntityPlayer.SleepResult.TOO_FAR_AWAY);
            return;
        }
        if (SleepHandler.isMobInRange(player, world, pos)) {
            event.setResult(EntityPlayer.SleepResult.NOT_SAFE);
            return;
        }
        player.func_192030_dh();
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        try {
            SET_SIZE.invoke((Object)player, Float.valueOf(0.2f), Float.valueOf(0.2f));
        }
        catch (Exception ex) {
            RandomTweaks.LOGGER.error("Error while setting player size", (Throwable)ex);
        }
        if (state != null && state.func_177230_c().isBed(state, (IBlockAccess)world, pos, (Entity)player)) {
            player.func_175139_a(facing);
            float x = 0.5f + (float)facing.func_82601_c() * 0.4f;
            float z = 0.5f + (float)facing.func_82599_e() * 0.4f;
            player.func_70107_b((double)((float)event.getPos().func_177958_n() + x), (double)((float)event.getPos().func_177956_o() + 0.6875f), (double)((float)event.getPos().func_177952_p() + z));
        } else {
            player.func_70107_b((double)((float)event.getPos().func_177958_n() + 0.5f), (double)((float)event.getPos().func_177956_o() + 0.6875f), (double)((float)event.getPos().func_177952_p() + 0.5f));
        }
        player.field_71083_bS = true;
        player.field_71076_b = 0;
        player.field_71081_bT = event.getPos();
        player.field_70159_w = 0.0;
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
        world.func_72854_c();
        event.setResult(EntityPlayer.SleepResult.OK);
    }

    public static boolean isMobInRange(EntityPlayer player, World world, BlockPos position) {
        return !world.func_175647_a(EntityMob.class, new AxisAlignedBB((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p()).func_72314_b(8.0, 5.0, 8.0), mob -> mob.func_191990_c(player) && (!RTConfig.Misc.allowSleepNearMobsWithCustomNames || !mob.func_145818_k_())).isEmpty();
    }
}

