/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects.bounce;

import java.util.IdentityHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class BounceHandler {
    private static final IdentityHashMap<Entity, BounceHandler> bouncingEntities = new IdentityHashMap();
    public final EntityLivingBase entityLiving;
    private int timer;
    private boolean wasInAir;
    private double bounce;
    private int bounceTick;
    private double lastMovX;
    private double lastMovZ;

    private BounceHandler(EntityLivingBase entityLiving, double bounce) {
        this.entityLiving = entityLiving;
        this.timer = 0;
        this.wasInAir = false;
        this.bounce = bounce;
        this.bounceTick = bounce != 0.0 ? entityLiving.field_70173_aa : 0;
        bouncingEntities.put((Entity)entityLiving, this);
    }

    public static void addBounceHandler(EntityLivingBase entity, double bounce) {
        if (!(entity instanceof EntityPlayer) || entity instanceof FakePlayer) {
            return;
        }
        BounceHandler handler = bouncingEntities.get(entity);
        if (handler == null) {
            MinecraftForge.EVENT_BUS.register((Object)new BounceHandler(entity, bounce));
        } else if (bounce != 0.0) {
            handler.bounce = bounce;
            handler.bounceTick = entity.field_70173_aa;
        }
    }

    @SubscribeEvent
    public void playerTickPost(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player == this.entityLiving && !event.player.func_184613_cA()) {
            if (event.player.field_70173_aa == this.bounceTick) {
                event.player.field_70181_x = this.bounce;
                this.bounceTick = 0;
            }
            if (!(this.entityLiving.field_70122_E || this.entityLiving.field_70173_aa == this.bounceTick || this.lastMovX == this.entityLiving.field_70159_w && this.lastMovZ == this.entityLiving.field_70179_y)) {
                double f = 0.935;
                this.entityLiving.field_70159_w /= f;
                this.entityLiving.field_70179_y /= f;
                this.entityLiving.field_70160_al = true;
                this.lastMovX = this.entityLiving.field_70159_w;
                this.lastMovZ = this.entityLiving.field_70179_y;
            }
            if (this.wasInAir && this.entityLiving.field_70122_E) {
                if (this.timer == 0) {
                    this.timer = this.entityLiving.field_70173_aa;
                } else if (this.entityLiving.field_70173_aa - this.timer > 5) {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                    bouncingEntities.remove(this.entityLiving);
                }
            } else {
                this.timer = 0;
                this.wasInAir = true;
            }
        }
    }
}

