/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.entity.angel.zachriel;

import com.teamwizardry.librarianlib.features.base.entity.EntityMod;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.saving.Save;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.common.entity.angel.zachriel.EntityZachriel;
import com.teamwizardry.wizardry.init.ModPotions;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCorruptionArea
extends EntityMod {
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(EntityCorruptionArea.class, (DataSerializer)DataSerializers.field_187193_c);
    @Save
    public final HashMap<Entity, Integer> reapplicationDelayMap = new HashMap();
    @Save
    public final int reapplicationDelay;
    @Save
    public int duration = 600;
    @Save
    public float radiusPerTick;

    public EntityCorruptionArea(World world) {
        super(world);
        this.reapplicationDelay = 20;
        this.field_70145_X = true;
        this.func_189654_d(true);
        this.func_184224_h(true);
        this.field_70178_ae = true;
    }

    public EntityCorruptionArea(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityCorruptionArea(World world, float radius) {
        this(world);
        this.setRadius(radius);
    }

    public EntityCorruptionArea(World world, float radius, double x, double y, double z) {
        this(world, x, y, z);
        this.setRadius(radius);
    }

    public void func_70107_b(double x, double y, double z) {
        while (y > 0.0 && this.field_70170_p.func_175623_d(new BlockPos(x, y - 1.0, z))) {
            y -= 1.0;
        }
        super.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(RADIUS, (Object)Float.valueOf(3.0f));
        this.func_70105_a(this.getRadius() * 2.0f, 1.0f);
    }

    public float getRadius() {
        return ((Float)this.func_184212_Q().func_187225_a(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        if (radius < 0.0f) {
            radius = 0.0f;
        }
        this.func_70105_a(radius * 2.0f, 0.5f);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(radius));
        }
        this.func_70105_a(radius * 2.0f, 1.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float radius = this.getRadius();
        if (this.duration < 0) {
            this.func_70106_y();
        }
        --this.duration;
        ClientRunnable.run((ClientRunnable)new ClientRunnable(){

            @SideOnly(value=Side.CLIENT)
            public void runIfClient() {
                ParticleBuilder glitter = new ParticleBuilder(RandUtil.nextInt(30, 50));
                glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
                glitter.enableMotionCalculation();
                glitter.setCollision(true);
                glitter.setCanBounce(true);
                glitter.setAcceleration(new Vec3d(0.0, -0.035, 0.0));
                glitter.setColor(new Color(255, 0, 206));
                glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 0.0f));
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)EntityCorruptionArea.this.field_70170_p, (InterpFunction)new StaticInterp((Object)EntityCorruptionArea.this.func_174791_d()), (int)1, (int)1, (i, build) -> {
                    double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                    double r = EntityCorruptionArea.this.getRadius() * RandUtil.nextFloat();
                    double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                    double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                    build.setPositionOffset(new Vec3d(x, 0.0, z));
                    build.addMotion(new Vec3d(0.0, RandUtil.nextDouble(0.01, 0.15), 0.0));
                });
            }
        });
        this.setRadius(radius += this.radiusPerTick);
        Iterator<Map.Entry<Entity, Integer>> iter = this.reapplicationDelayMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Entity, Integer> entry = iter.next();
            int timeLeft = entry.getValue();
            if (timeLeft > 0) {
                entry.setValue(timeLeft - 1);
                continue;
            }
            iter.remove();
        }
        List entityList = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ());
        for (EntityLivingBase entity : entityList) {
            double zDiff;
            double xDiff;
            if (entity instanceof EntityZachriel || this.reapplicationDelayMap.containsKey(entity) || !((xDiff = entity.field_70165_t - this.field_70165_t) * xDiff + (zDiff = entity.field_70163_u - this.field_70163_u) * zDiff <= (double)(radius * radius))) continue;
            this.affectEntity(entity);
        }
    }

    public void affectEntity(EntityLivingBase entity) {
        this.reapplicationDelayMap.put((Entity)entity, this.reapplicationDelay);
        PotionEffect effect = entity.func_70660_b((Potion)ModPotions.ZACH_CORRUPTION);
        if (effect == null) {
            entity.func_70690_d(new PotionEffect((Potion)ModPotions.ZACH_CORRUPTION, 100, 0, true, false));
        } else {
            entity.func_70690_d(new PotionEffect((Potion)ModPotions.ZACH_CORRUPTION, 100, effect.func_76458_c() + 1, true, false));
        }
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }
}

