/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.render.block;

import com.teamwizardry.librarianlib.features.base.block.tile.TileMod;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.librarianlib.features.tesr.TileRenderHandler;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.common.tile.TileLight;
import java.awt.Color;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileLightRenderer
extends TileRenderHandler<TileLight> {
    private TileLight te;

    public TileLightRenderer(TileLight te) {
        super((TileMod)te);
        this.te = te;
    }

    public void render(float partialTicks, int destroyStage, float alpha) {
        if (RandUtil.nextInt(4) == 0) {
            Color secondaryColor;
            Color primaryColor;
            if (this.te.getModule() != null) {
                primaryColor = this.te.getModule().getPrimaryColor();
                secondaryColor = this.te.getModule().getSecondaryColor();
            } else {
                primaryColor = new Color(0xAA00AA);
                secondaryColor = new Color(0);
            }
            ParticleBuilder glitter = new ParticleBuilder(30);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
            glitter.setColorFunction((InterpFunction)new InterpColorHSV(Color.CYAN, Color.BLUE));
            glitter.setScaleFunction((InterpFunction)new InterpScale((float)RandUtil.nextDouble(1.0, 3.0), 0.0f));
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)this.te.func_145831_w(), (InterpFunction)new StaticInterp((Object)new Vec3d((Vec3i)this.te.func_174877_v()).func_72441_c(0.5, 0.5, 0.5)), (int)1, (int)0, (i, build) -> {
                build.setMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(0.0, 0.03), RandUtil.nextDouble(-0.01, 0.01)));
                if (RandUtil.nextBoolean()) {
                    build.setColorFunction((InterpFunction)new InterpColorHSV(primaryColor, secondaryColor));
                } else {
                    build.setColorFunction((InterpFunction)new InterpColorHSV(secondaryColor, primaryColor));
                }
            });
        }
    }
}

