/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell;

import com.teamwizardry.wizardry.api.capability.player.mana.DefaultManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability;
import com.teamwizardry.wizardry.api.spell.ProcessData;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterDataType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

public class SpellDataTypes {
    private SpellDataTypes() {
    }

    public static class BlockStateCache {
        private final Map<BlockPos, IBlockState> blockStateCache;

        public BlockStateCache(Map<BlockPos, IBlockState> blockStateCache) {
            this.blockStateCache = blockStateCache;
        }

        public Map<BlockPos, IBlockState> getBlockStateCache() {
            return this.blockStateCache;
        }
    }

    public static class BlockSet {
        private final Set<BlockPos> blockSet;

        public BlockSet(Set<BlockPos> blockSet) {
            this.blockSet = blockSet;
        }

        public Set<BlockPos> getBlockSet() {
            return this.blockSet;
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagList", dataType="com.teamwizardry.wizardry.api.spell.SpellDataTypes$BlockStateCache")
    public static class BlockStateCacheType
    implements ProcessData.Process<NBTTagList, BlockStateCache> {
        @Override
        @NotNull
        public NBTTagList serialize(BlockStateCache object) {
            NBTTagList list = new NBTTagList();
            if (object == null) {
                return list;
            }
            for (Map.Entry<BlockPos, IBlockState> entry : object.getBlockStateCache().entrySet()) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74772_a("pos", entry.getKey().func_177986_g());
                NBTTagCompound nbtState = new NBTTagCompound();
                NBTUtil.func_190009_a((NBTTagCompound)nbtState, (IBlockState)entry.getValue());
                compound.func_74782_a("blockstate", (NBTBase)nbtState);
                list.func_74742_a((NBTBase)compound);
            }
            return list;
        }

        @Override
        public BlockStateCache deserialize(@NotNull NBTTagList object) {
            HashMap<BlockPos, IBlockState> stateCache = new HashMap<BlockPos, IBlockState>();
            for (NBTBase base : object) {
                NBTTagCompound compound;
                if (!(base instanceof NBTTagCompound) || !(compound = (NBTTagCompound)base).func_74764_b("pos") || !compound.func_74764_b("blockstate")) continue;
                BlockPos pos = BlockPos.func_177969_a((long)compound.func_74763_f("pos"));
                IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("blockstate"));
                stateCache.put(pos, state);
            }
            return new BlockStateCache(stateCache);
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagList", dataType="com.teamwizardry.wizardry.api.spell.SpellDataTypes$BlockSet")
    public static class BlockSetType
    implements ProcessData.Process<NBTTagList, BlockSet> {
        @Override
        @NotNull
        public NBTTagList serialize(BlockSet object) {
            NBTTagList list = new NBTTagList();
            if (object == null) {
                return list;
            }
            for (BlockPos pos : object.getBlockSet()) {
                list.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
            }
            return list;
        }

        @Override
        public BlockSet deserialize(@NotNull NBTTagList object) {
            HashSet<BlockPos> poses = new HashSet<BlockPos>();
            for (NBTBase base : object) {
                if (!(base instanceof NBTTagLong)) continue;
                poses.add(BlockPos.func_177969_a((long)((NBTTagLong)base).func_150291_c()));
            }
            return new BlockSet(poses);
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagLong", dataType="java.lang.Long")
    public static class LongType
    implements ProcessData.Process<NBTTagLong, Long> {
        @Override
        @NotNull
        public NBTTagLong serialize(Long object) {
            if (object == null) {
                return new NBTTagLong(0L);
            }
            return new NBTTagLong(object.longValue());
        }

        @Override
        public Long deserialize(@NotNull NBTTagLong object) {
            return object.func_150291_c();
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagCompound", dataType="net.minecraft.block.state.IBlockState")
    public static class BlockStateType
    implements ProcessData.Process<NBTTagCompound, IBlockState> {
        @Override
        @NotNull
        public NBTTagCompound serialize(IBlockState object) {
            NBTTagCompound nbtState = new NBTTagCompound();
            if (object == null) {
                return nbtState;
            }
            NBTUtil.func_190009_a((NBTTagCompound)nbtState, (IBlockState)object);
            return nbtState;
        }

        @Override
        public IBlockState deserialize(@NotNull NBTTagCompound object) {
            return NBTUtil.func_190008_d((NBTTagCompound)object);
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagCompound", dataType="com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability")
    public static class ManaCapabilityType
    implements ProcessData.Process<NBTTagCompound, IManaCapability> {
        @Override
        @NotNull
        public NBTTagCompound serialize(IManaCapability object) {
            if (object == null) {
                return new NBTTagCompound();
            }
            return (NBTTagCompound)object.serializeNBT();
        }

        @Override
        public IManaCapability deserialize(@NotNull NBTTagCompound object) {
            DefaultManaCapability cap = new DefaultManaCapability();
            cap.deserializeNBT(object);
            return cap;
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagString", dataType="net.minecraft.util.EnumFacing")
    public static class EnumFacingType
    implements ProcessData.Process<NBTTagString, EnumFacing> {
        @Override
        @NotNull
        public NBTTagString serialize(EnumFacing object) {
            if (object == null) {
                return new NBTTagString("UP");
            }
            return new NBTTagString(object.name());
        }

        @Override
        public EnumFacing deserialize(@NotNull NBTTagString object) {
            return EnumFacing.valueOf((String)object.func_150285_a_());
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagLong", dataType="net.minecraft.util.math.BlockPos")
    public static class BlockPosType
    implements ProcessData.Process<NBTTagLong, BlockPos> {
        @Override
        @NotNull
        public NBTTagLong serialize(BlockPos object) {
            if (object == null) {
                return new NBTTagLong(-1L);
            }
            return new NBTTagLong(object.func_177986_g());
        }

        @Override
        public BlockPos deserialize(@NotNull NBTTagLong object) {
            return BlockPos.func_177969_a((long)object.func_150291_c());
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagString", dataType="java.util.UUID")
    public static class UUIDType
    implements ProcessData.Process<NBTTagString, UUID> {
        @Override
        @Nonnull
        public NBTTagString serialize(UUID object) {
            return new NBTTagString(object.toString());
        }

        @Override
        @Nullable
        public UUID deserialize(@NotNull NBTTagString object) {
            return UUID.fromString(object.func_150285_a_());
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagString", dataType="java.lang.String")
    public static class CustomTagType
    implements ProcessData.Process<NBTTagString, String> {
        @Override
        @Nonnull
        public NBTTagString serialize(String object) {
            return new NBTTagString(object);
        }

        @Override
        @Nullable
        public String deserialize(@NotNull NBTTagString object) {
            return object.func_150285_a_();
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagCompound", dataType="net.minecraft.util.math.Vec3d")
    public static class Vec3dType
    implements ProcessData.Process<NBTTagCompound, Vec3d> {
        @Override
        @NotNull
        public NBTTagCompound serialize(Vec3d object) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74780_a("x", object.field_72450_a);
            compound.func_74780_a("y", object.field_72448_b);
            compound.func_74780_a("z", object.field_72449_c);
            return compound;
        }

        @Override
        public Vec3d deserialize(@NotNull NBTTagCompound object) {
            if (!(object.func_150297_b("x", 6) && object.func_150297_b("y", 6) && object.func_150297_b("z", 6))) {
                return Vec3d.field_186680_a;
            }
            double x = object.func_74769_h("x");
            double y = object.func_74769_h("y");
            double z = object.func_74769_h("z");
            return new Vec3d(x, y, z);
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagFloat", dataType="java.lang.Float")
    public static class FloatType
    implements ProcessData.Process<NBTTagFloat, Float> {
        @Override
        @NotNull
        public NBTTagFloat serialize(Float object) {
            return new NBTTagFloat(object.floatValue());
        }

        @Override
        public Float deserialize(@NotNull NBTTagFloat object) {
            return Float.valueOf(object.func_150288_h());
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagCompound", dataType="net.minecraft.nbt.NBTTagCompound")
    public static class NBTTagCompoundType
    implements ProcessData.Process<NBTTagCompound, NBTTagCompound> {
        @Override
        @NotNull
        public NBTTagCompound serialize(NBTTagCompound object) {
            return object == null ? new NBTTagCompound() : object;
        }

        @Override
        public NBTTagCompound deserialize(@NotNull NBTTagCompound object) {
            return object;
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagList", dataType="net.minecraft.nbt.NBTTagList")
    public static class NBTTagListType
    implements ProcessData.Process<NBTTagList, NBTTagList> {
        @Override
        @NotNull
        public NBTTagList serialize(NBTTagList object) {
            return object == null ? new NBTTagList() : object;
        }

        @Override
        public NBTTagList deserialize(@NotNull NBTTagList object) {
            return object;
        }
    }

    @RegisterDataType(storageType="net.minecraft.nbt.NBTTagInt", dataType="java.lang.Integer")
    public static class IntegerType
    implements ProcessData.Process<NBTTagInt, Integer> {
        @Override
        @NotNull
        public NBTTagInt serialize(Integer object) {
            if (object == null) {
                return new NBTTagInt(1);
            }
            return new NBTTagInt(object.intValue());
        }

        @Override
        public Integer deserialize(@NotNull NBTTagInt object) {
            return object.func_150287_d();
        }
    }
}

