/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell;

import com.google.common.collect.ArrayListMultimap;
import com.teamwizardry.librarianlib.features.saving.Savable;
import com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaCapabilityProvider;
import com.teamwizardry.wizardry.api.spell.ProcessData;
import com.teamwizardry.wizardry.api.spell.SpellDataTypes;
import com.teamwizardry.wizardry.api.spell.SpellModifierRegistry;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeModifier;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.attribute.Operation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

@Savable
public class SpellData
implements INBTSerializable<NBTTagCompound> {
    private static HashMap<String, DataField<?>> availableFields = new HashMap();
    @Nonnull
    private final HashMap<DataField<?>, Object> data = new HashMap();
    @Nonnull
    private HashMap<AttributeRegistry.Attribute, ArrayListMultimap<Operation, AttributeModifier>> castTimeModifiers = new HashMap();

    @Nonnull
    public static <T> DataField<T> constructField(@Nonnull String key, @Nonnull Class<T> type) {
        DataField<T> field = new DataField<T>(key, type);
        availableFields.put(key, field);
        return field;
    }

    @Nonnull
    static Collection<DataField<?>> getAllAvailableFields() {
        return Collections.unmodifiableCollection(availableFields.values());
    }

    public void addAllData(HashMap<DataField<?>, Object> data) {
        this.data.putAll(data);
    }

    public <T> void addData(@Nonnull DataField<T> key, @Nullable T value) {
        this.data.put(key, value);
    }

    public <T> void removeData(@Nonnull DataField<T> key) {
        this.data.remove(key);
    }

    public static SpellData deserializeData(NBTTagCompound compound) {
        SpellData data = new SpellData();
        data.deserializeNBT(compound);
        return data;
    }

    @Nonnull
    public <T> T getDataWithFallback(@Nonnull DataField<T> key, @Nonnull T fallback) {
        T value = this.getData(key);
        return value != null ? value : fallback;
    }

    public <T> boolean hasData(@Nonnull DataField<T> key) {
        return this.data.get(key) != null;
    }

    public void processTrace(RayTraceResult trace, @Nullable Vec3d fallback) {
        if (trace.field_72313_a == RayTraceResult.Type.ENTITY) {
            this.processEntity(trace.field_72308_g, false);
        } else if (trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.processBlock(trace.func_178782_a(), trace.field_178784_b, trace.field_72307_f);
        } else {
            Vec3d vec;
            Vec3d vec3d = vec = trace.field_72307_f == null ? fallback : trace.field_72307_f;
            if (vec == null) {
                return;
            }
            this.processBlock(new BlockPos(vec), null, vec);
        }
    }

    public void processTrace(RayTraceResult trace) {
        this.processTrace(trace, null);
    }

    @Nullable
    public <T> T getData(@Nonnull DataField<T> key) {
        Object value = this.data.get(key);
        if (key.getDataType().isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    @Nullable
    public Vec3d getOriginWithFallback(World world) {
        Vec3d origin = this.getData(DefaultKeys.ORIGIN);
        if (origin == null) {
            Entity caster = this.getCaster(world);
            if (caster == null) {
                Vec3d target = this.getData(DefaultKeys.TARGET_HIT);
                if (target == null) {
                    BlockPos pos = this.getData(DefaultKeys.BLOCK_HIT);
                    if (pos == null) {
                        Entity victim = this.getVictim(world);
                        if (victim == null) {
                            return null;
                        }
                        return victim.func_174791_d().func_72441_c(0.0, (double)victim.field_70131_O / 2.0, 0.0);
                    }
                    return new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
                }
                return target;
            }
            return caster.func_174791_d().func_72441_c(0.0, (double)caster.field_70131_O / 2.0, 0.0);
        }
        return origin;
    }

    @Nullable
    public Vec3d getOrigin(World world) {
        Vec3d origin = this.getData(DefaultKeys.ORIGIN);
        if (origin == null) {
            Entity caster = this.getCaster(world);
            if (caster == null) {
                return null;
            }
            return caster.func_174791_d().func_72441_c(0.0, (double)caster.field_70131_O / 2.0, 0.0);
        }
        return origin;
    }

    @Nullable
    public Vec3d getTargetWithFallback(World world) {
        Vec3d target = this.getData(DefaultKeys.TARGET_HIT);
        if (target == null) {
            BlockPos pos = this.getData(DefaultKeys.BLOCK_HIT);
            if (pos == null) {
                Entity victim = this.getVictim(world);
                if (victim == null) {
                    Vec3d origin = this.getData(DefaultKeys.ORIGIN);
                    if (origin == null) {
                        Entity caster = this.getCaster(world);
                        if (caster == null) {
                            return null;
                        }
                        return caster.func_174791_d().func_72441_c(0.0, (double)caster.field_70131_O / 2.0, 0.0);
                    }
                    return origin;
                }
                return victim.func_174791_d().func_72441_c(0.0, (double)victim.field_70131_O / 2.0, 0.0);
            }
            return new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
        }
        return target;
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.getData(DefaultKeys.BLOCK_HIT);
    }

    @Nullable
    public EnumFacing getFaceHit() {
        return this.getData(DefaultKeys.FACE_HIT);
    }

    @Nullable
    public Vec3d getTarget(World world) {
        Vec3d target = this.getData(DefaultKeys.TARGET_HIT);
        if (target == null) {
            BlockPos pos = this.getData(DefaultKeys.BLOCK_HIT);
            if (pos == null) {
                Entity victim = this.getVictim(world);
                if (victim == null) {
                    return null;
                }
                return victim.func_174791_d().func_72441_c(0.0, (double)victim.field_70131_O / 2.0, 0.0);
            }
            return new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
        }
        return target;
    }

    @Nullable
    public Entity getCaster(World world) {
        return world.func_73045_a(this.getDataWithFallback(DefaultKeys.CASTER, -1).intValue());
    }

    @Nullable
    public Entity getVictim(World world) {
        return world.func_73045_a(this.getDataWithFallback(DefaultKeys.ENTITY_HIT, -1).intValue());
    }

    @Nullable
    public IManaCapability getCapability(World world) {
        IManaCapability capability = this.getData(DefaultKeys.CAPABILITY);
        if (capability == null) {
            Entity caster = this.getCaster(world);
            if (caster == null) {
                return null;
            }
            return ManaCapabilityProvider.getCap(caster);
        }
        return capability;
    }

    public float getPitch() {
        return this.getDataWithFallback(DefaultKeys.PITCH, Float.valueOf(0.0f)).floatValue();
    }

    public float getYaw() {
        return this.getDataWithFallback(DefaultKeys.YAW, Float.valueOf(0.0f)).floatValue();
    }

    public RayTraceResult.Type getHitType(World world) {
        if (this.getVictim(world) == null) {
            Vec3d vec = this.getTarget(world);
            if (vec == null) {
                return RayTraceResult.Type.MISS;
            }
            return RayTraceResult.Type.BLOCK;
        }
        return RayTraceResult.Type.ENTITY;
    }

    @Nullable
    public Vec3d getOriginHand(World world) {
        Vec3d trueOrigin = this.getOriginWithFallback(world);
        if (trueOrigin == null) {
            return null;
        }
        float offX = 0.5f * (float)Math.sin(Math.toRadians(-90.0f - this.getYaw()));
        float offZ = 0.5f * (float)Math.cos(Math.toRadians(-90.0f - this.getYaw()));
        return new Vec3d((double)offX, 0.0, (double)offZ).func_178787_e(trueOrigin);
    }

    public void processBlock(@Nullable BlockPos pos, @Nullable EnumFacing facing, @Nullable Vec3d targetHit) {
        if (pos == null && targetHit != null) {
            pos = new BlockPos(targetHit);
        }
        if (targetHit == null && pos != null) {
            targetHit = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
        }
        this.addData(DefaultKeys.BLOCK_HIT, pos);
        this.addData(DefaultKeys.TARGET_HIT, targetHit);
        this.addData(DefaultKeys.FACE_HIT, facing);
    }

    public void processEntity(@Nonnull Entity entity, boolean asCaster) {
        if (asCaster) {
            this.addData(DefaultKeys.ORIGIN, entity.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0));
            this.addData(DefaultKeys.CASTER, entity.func_145782_y());
            this.addData(DefaultKeys.YAW, Float.valueOf(entity.field_70177_z));
            this.addData(DefaultKeys.PITCH, Float.valueOf(entity.field_70125_A));
            this.addData(DefaultKeys.LOOK, entity.func_70676_i(0.0f));
            this.addData(DefaultKeys.CAPABILITY, ManaCapabilityProvider.getCap(entity));
        } else {
            this.addData(DefaultKeys.TARGET_HIT, entity.func_174791_d().func_72441_c(0.0, (double)entity.field_70131_O / 2.0, 0.0));
            this.addData(DefaultKeys.BLOCK_HIT, entity.func_180425_c());
            this.addData(DefaultKeys.ENTITY_HIT, entity.func_145782_y());
        }
    }

    public SpellData copy() {
        SpellData spell = new SpellData();
        spell.addAllData(this.data);
        spell.deserializeNBT(this.serializeNBT());
        return spell;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (String key : nbt.func_150296_c()) {
            DataField<?> field = availableFields.get(key);
            if (field == null) continue;
            NBTBase nbtType = nbt.func_74781_a(key);
            this.data.put(field, field.getDataTypeProcess().deserialize(nbtType));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        for (Map.Entry<DataField<?>, Object> entry : this.data.entrySet()) {
            NBTBase nbtClass = entry.getKey().getDataTypeProcess().serialize(entry.getValue());
            compound.func_74782_a(entry.getKey().getFieldName(), nbtClass);
        }
        return compound;
    }

    public String toString() {
        return "SpellData{data=" + this.data + '}';
    }

    public void processCastTimeModifiers(Entity entity, SpellRing spellRing) {
        List<AttributeModifier> modifiers = SpellModifierRegistry.compileModifiers(entity, spellRing, this);
        for (AttributeModifier modifier : modifiers) {
            AttributeRegistry.Attribute attribute = modifier.getAttribute();
            Operation operation = modifier.getOperation();
            ArrayListMultimap operationMap = this.castTimeModifiers.get(attribute);
            if (operationMap == null) {
                operationMap = ArrayListMultimap.create();
                this.castTimeModifiers.put(attribute, (ArrayListMultimap<Operation, AttributeModifier>)operationMap);
            }
            operationMap.put((Object)operation, (Object)modifier);
        }
    }

    public final float getCastTimeValue(AttributeRegistry.Attribute attribute, float value) {
        ArrayListMultimap<Operation, AttributeModifier> operationMap = this.castTimeModifiers.get(attribute);
        if (operationMap == null) {
            return value;
        }
        for (Operation op : Operation.values()) {
            for (AttributeModifier modifier : operationMap.get((Object)op)) {
                value = modifier.apply(value);
            }
        }
        return value;
    }

    public static class DefaultKeys {
        public static final DataField<NBTTagList> TAG_LIST = SpellData.constructField("list", NBTTagList.class);
        public static final DataField<NBTTagCompound> COMPOUND = SpellData.constructField("compound", NBTTagCompound.class);
        public static final DataField<Integer> MAX_TIME = SpellData.constructField("max_time", Integer.class);
        public static final DataField<Integer> CASTER = SpellData.constructField("caster", Integer.class);
        public static final DataField<Float> YAW = SpellData.constructField("yaw", Float.class);
        public static final DataField<Float> PITCH = SpellData.constructField("pitch", Float.class);
        public static final DataField<Vec3d> LOOK = SpellData.constructField("look", Vec3d.class);
        public static final DataField<Vec3d> ORIGIN = SpellData.constructField("origin", Vec3d.class);
        public static final DataField<Integer> ENTITY_HIT = SpellData.constructField("entity_hit", Integer.class);
        public static final DataField<BlockPos> BLOCK_HIT = SpellData.constructField("block_hit", BlockPos.class);
        public static final DataField<EnumFacing> FACE_HIT = SpellData.constructField("face_hit", EnumFacing.class);
        public static final DataField<IManaCapability> CAPABILITY = SpellData.constructField("capability", IManaCapability.class);
        public static final DataField<Vec3d> TARGET_HIT = SpellData.constructField("target_hit", Vec3d.class);
        public static final DataField<IBlockState> BLOCK_STATE = SpellData.constructField("block_state", IBlockState.class);
        public static final DataField<Long> SEED = SpellData.constructField("seed", Long.class);
        public static final DataField<SpellDataTypes.BlockSet> BLOCK_SET = SpellData.constructField("block_set", SpellDataTypes.BlockSet.class);
        public static final DataField<SpellDataTypes.BlockStateCache> BLOCKSTATE_CACHE = SpellData.constructField("blockstate_cache", SpellDataTypes.BlockStateCache.class);
        public static final DataField<UUID> UUID = SpellData.constructField("uuid", UUID.class);
        public static final DataField<String> CUSTOM_TAG = SpellData.constructField("tag", String.class);
    }

    public static class DataField<E> {
        private final String fieldName;
        private final Class<E> dataType;
        private ProcessData.DataType lazy_dataTypeProcess = null;

        public DataField(String fieldName, Class<E> dataType) {
            this.fieldName = fieldName;
            this.dataType = dataType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Class<E> getDataType() {
            return this.dataType;
        }

        public ProcessData.DataType getDataTypeProcess() {
            if (this.lazy_dataTypeProcess == null) {
                this.lazy_dataTypeProcess = ProcessData.INSTANCE.getDataType(this.dataType);
            }
            return this.lazy_dataTypeProcess;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dataType == null ? 0 : this.dataType.toString().hashCode());
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataField other = (DataField)obj;
            if (this.dataType == null ? other.dataType != null : !this.dataType.toString().equals(other.dataType.toString())) {
                return false;
            }
            if (this.fieldName == null) {
                return other.fieldName == null;
            }
            return this.fieldName.equals(other.fieldName);
        }
    }
}

