/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.capability.player.mana;

import com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaCapabilityProvider;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class ManaManager {
    public static CapManagerBuilder forObject(@Nullable Entity entity) {
        return new CapManagerBuilder(entity);
    }

    public static CapManagerBuilder forObject(@Nullable ItemStack stack) {
        return new CapManagerBuilder(stack);
    }

    public static CapManagerBuilder forObject(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing facing) {
        return new CapManagerBuilder(world, pos, facing);
    }

    public static CapManagerBuilder forObject(@Nullable IManaCapability cap) {
        return new CapManagerBuilder(cap);
    }

    @Nullable
    private static IManaCapability getCap(@Nullable ItemStack stack) {
        return stack != null && !stack.func_190926_b() ? ManaCapabilityProvider.getCap(stack) : null;
    }

    @Nullable
    private static IManaCapability getCap(@Nullable Entity entity) {
        return entity != null ? ManaCapabilityProvider.getCap(entity) : null;
    }

    @Nullable
    private static IManaCapability getCap(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing facing) {
        return world == null || pos == null ? null : (world.field_72995_K ? null : ManaCapabilityProvider.getCap(world, pos, facing));
    }

    public static double getMaxMana(@Nullable IManaCapability cap) {
        if (cap == null) {
            return 0.0;
        }
        return cap.getMaxMana();
    }

    public static double getMaxMana(@Nullable Entity entity) {
        IManaCapability cap = ManaManager.getCap(entity);
        if (cap == null) {
            return 0.0;
        }
        return cap.getMaxMana();
    }

    public static double getMaxMana(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing facing) {
        IManaCapability cap = ManaManager.getCap(world, pos, facing);
        if (cap == null) {
            return 0.0;
        }
        return cap.getMaxMana();
    }

    public static double getMaxMana(@Nullable ItemStack stack) {
        IManaCapability cap = ManaManager.getCap(stack);
        if (cap == null) {
            return 0.0;
        }
        return cap.getMaxMana();
    }

    public static double getMana(@Nullable IManaCapability cap) {
        if (cap == null) {
            return 0.0;
        }
        return cap.getMana();
    }

    public static double getMana(@Nullable Entity entity) {
        IManaCapability cap = ManaManager.getCap(entity);
        if (cap == null) {
            return 0.0;
        }
        return cap.getMana();
    }

    public static double getMana(@Nullable ItemStack stack) {
        IManaCapability cap = ManaManager.getCap(stack);
        if (cap == null) {
            return 0.0;
        }
        return cap.getMana();
    }

    public static double getMana(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing facing) {
        IManaCapability cap = ManaManager.getCap(world, pos, facing);
        if (cap == null) {
            return 0.0;
        }
        return cap.getMana();
    }

    public static double getBurnout(@Nullable IManaCapability cap) {
        if (cap == null) {
            return 0.0;
        }
        return cap.getBurnout();
    }

    public static double getBurnout(@Nullable ItemStack stack) {
        IManaCapability cap = ManaManager.getCap(stack);
        if (cap == null) {
            return 0.0;
        }
        return cap.getBurnout();
    }

    public static double getBurnout(@Nullable Entity entity) {
        IManaCapability cap = ManaManager.getCap(entity);
        if (cap == null) {
            return 0.0;
        }
        return cap.getBurnout();
    }

    public static double getBurnout(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing facing) {
        IManaCapability cap = ManaManager.getCap(world, pos, facing);
        if (cap == null) {
            return 0.0;
        }
        return cap.getBurnout();
    }

    public static double getMaxBurnout(@Nullable IManaCapability cap) {
        if (cap == null) {
            return 0.0;
        }
        return cap.getMaxBurnout();
    }

    public static double getMaxBurnout(@Nullable ItemStack stack) {
        IManaCapability cap = ManaManager.getCap(stack);
        if (cap == null) {
            return 0.0;
        }
        return cap.getMaxBurnout();
    }

    public static double getMaxBurnout(@Nullable Entity entity) {
        IManaCapability cap = ManaManager.getCap(entity);
        if (cap == null) {
            return 0.0;
        }
        return cap.getMaxBurnout();
    }

    public static double getMaxBurnout(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing facing) {
        IManaCapability cap = ManaManager.getCap(world, pos, facing);
        if (cap == null) {
            return 0.0;
        }
        return cap.getMaxBurnout();
    }

    public static boolean isManaFull(@Nullable IManaCapability cap) {
        return cap != null && cap.getMana() >= cap.getMaxMana();
    }

    public static boolean isManaFull(@Nullable Entity entity) {
        IManaCapability cap = ManaManager.getCap(entity);
        return cap != null && cap.getMana() >= cap.getMaxMana();
    }

    public static boolean isManaFull(@Nullable ItemStack stack) {
        IManaCapability cap = ManaManager.getCap(stack);
        return cap != null && cap.getMana() >= cap.getMaxMana();
    }

    public static boolean isManaFull(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing facing) {
        IManaCapability cap = ManaManager.getCap(world, pos, facing);
        return cap != null && cap.getMana() >= cap.getMaxMana();
    }

    public static boolean isBurnoutFull(@Nullable ItemStack stack) {
        IManaCapability cap = ManaManager.getCap(stack);
        return cap != null && cap.getBurnout() >= cap.getMaxBurnout();
    }

    public static boolean isBurnoutFull(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing facing) {
        IManaCapability cap = ManaManager.getCap(world, pos, facing);
        return cap != null && cap.getBurnout() >= cap.getMaxBurnout();
    }

    public static boolean isManaEmpty(@Nullable IManaCapability cap) {
        return cap != null && cap.getMana() <= 0.0;
    }

    public static boolean isManaEmpty(@Nullable ItemStack stack) {
        IManaCapability cap = ManaManager.getCap(stack);
        return cap != null && cap.getMana() <= 0.0;
    }

    public static boolean isManaEmpty(@Nullable Entity entity) {
        IManaCapability cap = ManaManager.getCap(entity);
        return cap != null && cap.getMana() <= 0.0;
    }

    public static boolean isManaEmpty(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing facing) {
        IManaCapability cap = ManaManager.getCap(world, pos, facing);
        return cap != null && cap.getMana() <= 0.0;
    }

    public static boolean isBurnoutEmpty(@Nullable IManaCapability cap) {
        return cap != null && cap.getBurnout() <= 0.0;
    }

    public static boolean isBurnoutEmpty(@Nullable Entity entity) {
        IManaCapability cap = ManaManager.getCap(entity);
        return cap != null && cap.getBurnout() <= 0.0;
    }

    public static boolean isBurnoutEmpty(@Nullable ItemStack stack) {
        IManaCapability cap = ManaManager.getCap(stack);
        return cap != null && cap.getBurnout() <= 0.0;
    }

    public static boolean isBurnoutEmpty(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing facing) {
        IManaCapability cap = ManaManager.getCap(world, pos, facing);
        return cap != null && cap.getBurnout() <= 0.0;
    }

    public static class CapManagerBuilder
    implements AutoCloseable {
        @Nullable
        private IManaCapability cap = null;
        @Nullable
        private Entity entity = null;
        private boolean somethingChanged = false;

        CapManagerBuilder(@Nullable Entity entity) {
            this.entity = entity;
            if (entity != null) {
                this.cap = ManaCapabilityProvider.getCap(entity);
            }
        }

        CapManagerBuilder(@Nullable ItemStack stack) {
            if (stack != null && !stack.func_190926_b()) {
                this.cap = ManaCapabilityProvider.getCap(stack);
            }
        }

        CapManagerBuilder(@Nullable IManaCapability cap) {
            this.cap = cap;
        }

        CapManagerBuilder(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing facing) {
            if (world == null || pos == null) {
                return;
            }
            if (world.field_72995_K) {
                return;
            }
            this.cap = ManaCapabilityProvider.getCap(world, pos, facing);
        }

        public CapManagerBuilder addMana(double mana) {
            this.setMana(this.getMana() + mana);
            return this;
        }

        public CapManagerBuilder removeMana(double mana) {
            this.setMana(this.getMana() - mana);
            return this;
        }

        public CapManagerBuilder addBurnout(double burnout) {
            this.setBurnout(this.getBurnout() + burnout);
            return this;
        }

        public CapManagerBuilder removeBurnout(double burnout) {
            this.setBurnout(this.getBurnout() - burnout);
            return this;
        }

        public double getMaxMana() {
            if (this.cap == null) {
                return 0.0;
            }
            return this.cap.getMaxMana();
        }

        public CapManagerBuilder setMaxMana(double mana) {
            if (this.cap == null) {
                return this;
            }
            if (this.getMaxMana() != mana) {
                this.cap.setMaxMana(mana);
                this.somethingChanged = true;
            }
            if (this.getMana() > mana) {
                this.cap.setMana(mana);
                this.somethingChanged = true;
            }
            return this;
        }

        public double getMana() {
            if (this.cap == null) {
                return 0.0;
            }
            return this.cap.getMana();
        }

        public CapManagerBuilder setMana(double mana) {
            if (this.cap == null) {
                return this;
            }
            double clamped = MathHelper.func_151237_a((double)mana, (double)0.0, (double)this.getMaxMana());
            if (this.cap.getMana() != clamped) {
                this.cap.setMana(clamped);
                this.somethingChanged = true;
            }
            return this;
        }

        public double getBurnout() {
            if (this.cap == null) {
                return 0.0;
            }
            return this.cap.getBurnout();
        }

        public CapManagerBuilder setBurnout(double burnout) {
            if (this.cap == null) {
                return this;
            }
            double clamped = MathHelper.func_151237_a((double)burnout, (double)0.0, (double)this.getMaxBurnout());
            if (this.cap.getBurnout() != clamped) {
                this.cap.setBurnout(clamped);
                this.somethingChanged = true;
            }
            return this;
        }

        public double getMaxBurnout() {
            if (this.cap == null) {
                return 0.0;
            }
            return this.cap.getMaxBurnout();
        }

        public CapManagerBuilder setMaxBurnout(double burnout) {
            if (this.cap == null) {
                return this;
            }
            if (this.getMaxBurnout() != burnout) {
                this.cap.setMaxBurnout(burnout);
                this.somethingChanged = true;
            }
            if (this.getBurnout() > burnout) {
                this.cap.setBurnout(burnout);
                this.somethingChanged = true;
            }
            return this;
        }

        public boolean isManaFull() {
            return this.cap != null && this.cap.getMana() >= this.cap.getMaxMana();
        }

        public boolean isBurnoutFull() {
            return this.cap != null && this.cap.getBurnout() >= this.cap.getMaxBurnout();
        }

        public boolean isManaEmpty() {
            return this.cap != null && this.cap.getMana() <= 0.0;
        }

        public boolean isBurnoutEmpty() {
            return this.cap != null && this.cap.getBurnout() <= 0.0;
        }

        @Override
        public void close() {
            if (this.somethingChanged && this.cap != null && this.entity != null && !this.entity.field_70170_p.field_72995_K) {
                this.cap.dataChanged(this.entity);
            }
        }
    }
}

