/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Entity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Spawning
extends AbstractConditional {
    private final List<Entity> entities = new NNList();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.entities.isEmpty()) {
                throw new InvalidRecipeConfigException("Missing <entity>");
            }
            this.valid = true;
            for (Entity entity : this.entities) {
                this.valid = this.valid && entity.isValid();
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <spawning>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (Entity entity : this.entities) {
            entity.enforceValidity();
        }
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            for (Entity entity : this.entities) {
                entity.register(recipeName);
            }
        }
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("entity".equals(name)) {
            this.entities.add(factory.read(new Entity(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

