/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import java.io.File;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public final class QuestVariable
extends QuestObject {
    public final QuestFile file;
    public long maxValue;
    public boolean team;

    public QuestVariable(QuestFile f) {
        this.file = f;
        this.maxValue = 1L;
        this.team = false;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.VARIABLE;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("max", this.maxValue);
        if (this.team) {
            nbt.func_74757_a("team", true);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.maxValue = nbt.func_74763_f("max");
        if (this.maxValue < 1L) {
            this.maxValue = 1L;
        }
        this.team = nbt.func_74767_n("team");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarLong(this.maxValue);
        data.writeBoolean(this.team);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.maxValue = data.readVarLong();
        this.team = data.readBoolean();
    }

    @Override
    public void getConfig(EntityPlayer player, ConfigGroup config) {
        super.getConfig(player, config);
        config.addLong("max_value", () -> this.maxValue, v -> {
            this.maxValue = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addBool("team", () -> this.team, v -> {
            this.team = v;
        }, false);
    }

    @Override
    public Icon getAltIcon() {
        return GuiIcons.CONTROLLER;
    }

    @Override
    public void changeProgress(ITeamData data, EnumChangeProgress type) {
        if (type.reset) {
            data.setVariable(this.id, 0L);
        } else if (type.complete) {
            data.setVariable(this.id, this.maxValue);
        }
    }

    @Override
    public int getRelativeProgressFromChildren(ITeamData data) {
        if (this.maxValue <= 0L) {
            return 0;
        }
        long value = data.getVariable(this.id);
        if (value <= 0L) {
            return 0;
        }
        if (value >= this.maxValue) {
            return 100;
        }
        return (int)Math.min(1L, value * 100L / this.maxValue);
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.variable", (Object[])new Object[0]);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.file.variables.remove(this);
    }

    @Override
    public void onCreated() {
        this.file.variables.add(this);
    }

    @Override
    public File getFile(File folder) {
        return new File(folder, "variables/" + this.getCodeString() + ".nbt");
    }
}

