/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.gui.editor.ConfigPane;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.latmod.mods.itemfilters.item.ItemMissing;
import java.io.File;
import java.util.Optional;
import javafx.scene.Node;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public abstract class QuestObjectBase {
    public int id = 0;
    public boolean invalid = false;
    public String title = "";
    public ItemStack icon = ItemStack.field_190927_a;
    private Icon cachedIcon = null;
    private String cachedTitle = null;

    public final String toString() {
        return String.format("#%08x", this.id);
    }

    public final String getCodeString() {
        return String.format("%08x", this.id);
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return this.id;
    }

    public abstract QuestObjectType getObjectType();

    public abstract QuestFile getQuestFile();

    public void changeProgress(ITeamData data, EnumChangeProgress type) {
    }

    @Nullable
    public QuestChapter getQuestChapter() {
        return null;
    }

    public int getParentID() {
        return 0;
    }

    public void writeData(NBTTagCompound nbt) {
        if (!this.title.isEmpty()) {
            nbt.func_74778_a("title", this.title);
        }
        if (!this.icon.func_190926_b()) {
            nbt.func_74782_a("icon", ItemMissing.write((ItemStack)this.icon, (boolean)false));
        }
    }

    public void readData(NBTTagCompound nbt) {
        this.title = nbt.func_74779_i("title");
        this.icon = ItemMissing.read((NBTBase)nbt.func_74781_a("icon"));
    }

    public void writeNetData(DataOut data) {
        data.writeString(this.title);
        data.writeItemStack(this.icon);
    }

    public void readNetData(DataIn data) {
        this.title = data.readString();
        this.icon = data.readItemStack();
    }

    public void getConfig(EntityPlayer player, ConfigGroup config) {
        config.addString("title", () -> this.title, v -> {
            this.title = v;
        }, "").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.title", new Object[0])).setOrder(-127);
        config.add("icon", (ConfigValue)new ConfigItemStack.SimpleStack(() -> this.icon, v -> {
            this.icon = v;
        }), (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a)).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.icon", new Object[0])).setOrder(-126);
    }

    public abstract Icon getAltIcon();

    public abstract String getAltTitle();

    public final Icon getIcon() {
        if (this.cachedIcon != null) {
            return this.cachedIcon;
        }
        this.cachedIcon = !this.icon.func_190926_b() ? ItemIcon.getItemIcon((ItemStack)this.icon) : this.getAltIcon();
        return this.cachedIcon;
    }

    public final String getTitle() {
        if (this.cachedTitle != null) {
            return this.cachedTitle;
        }
        String key = String.format("quests.%08x.title", this.id);
        String t = FTBQuestsClient.addI18nAndColors(I18n.func_135052_a((String)key, (Object[])new Object[0]));
        this.cachedTitle = t.isEmpty() || key.equals(t) ? (!this.title.isEmpty() ? FTBQuestsClient.addI18nAndColors(this.title) : this.getAltTitle().trim()) : t;
        return this.cachedTitle;
    }

    public final String getUnformattedTitle() {
        return StringUtils.unformatted((String)this.getTitle());
    }

    public final String getYellowDisplayName() {
        return TextFormatting.YELLOW + this.getTitle();
    }

    public void deleteSelf() {
        this.getQuestFile().remove(this.id);
    }

    public void deleteChildren() {
    }

    public void editedFromGUI() {
        ClientQuestFile.INSTANCE.refreshGui();
    }

    public void onCreated() {
    }

    @Nullable
    public File getFile(File folder) {
        return null;
    }

    public void clearCachedData() {
        this.cachedIcon = null;
        this.cachedTitle = null;
    }

    public ConfigGroup createSubGroup(ConfigGroup group) {
        return group.getGroup(this.getObjectType().getID());
    }

    public void onEditButtonClicked() {
        new MessageEditObject(this.id).sendToServer();
    }

    public int refreshJEI() {
        return 0;
    }

    public Optional<Node> createTabContent() {
        return Optional.of(new ConfigPane(this));
    }
}

