/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import it.unimi.dsi.fastutil.shorts.Short2IntOpenHashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;

public abstract class QuestObject
extends QuestObjectBase {
    private Short2IntOpenHashMap cachedRelativeProgress = new Short2IntOpenHashMap();

    public QuestObject() {
        this.cachedRelativeProgress.defaultReturnValue(-1);
    }

    @Override
    public abstract void changeProgress(ITeamData var1, EnumChangeProgress var2);

    public abstract int getRelativeProgressFromChildren(ITeamData var1);

    public final int getRelativeProgress(ITeamData data) {
        int i = this.cachedRelativeProgress.get(data.getTeamUID());
        if (i == -1) {
            i = this.getRelativeProgressFromChildren(data);
            this.cachedRelativeProgress.put(data.getTeamUID(), i);
        }
        return i;
    }

    public static int getRelativeProgressFromChildren(int progressSum, int count) {
        if (count <= 0 || progressSum <= 0) {
            return 0;
        }
        if (progressSum >= count * 100) {
            return 100;
        }
        return Math.max(1, (int)((double)progressSum / (double)count));
    }

    public final boolean isStarted(ITeamData data) {
        return this.getRelativeProgress(data) > 0;
    }

    public final boolean isComplete(ITeamData data) {
        return this.getRelativeProgress(data) >= 100;
    }

    public boolean isVisible(ITeamData data) {
        return true;
    }

    public void onCompleted(ITeamData data, List<EntityPlayerMP> notifyPlayers) {
    }

    @Override
    public abstract String getAltTitle();

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.clearCachedProgress((short)0);
    }

    public void clearCachedProgress(short id) {
        if (id == 0) {
            this.cachedRelativeProgress.clear();
        } else {
            this.cachedRelativeProgress.remove(id);
        }
    }

    protected boolean verifyDependenciesInternal(QuestObject original, boolean firstLoop) {
        return true;
    }
}

