/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net.edit;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToServer;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.edit.FTBQuestsEditNetHandler;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateObjectResponse;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MessageCreateTaskAt
extends MessageToServer {
    private int chapter;
    private int x;
    private int y;
    private QuestTaskType type;
    private NBTTagCompound nbt;

    public MessageCreateTaskAt() {
    }

    public MessageCreateTaskAt(QuestChapter c, int _x, int _y, QuestTask task) {
        this.chapter = c.id;
        this.x = _x;
        this.y = _y;
        this.type = task.getType();
        this.nbt = new NBTTagCompound();
        task.writeData(this.nbt);
    }

    public NetworkWrapper getWrapper() {
        return FTBQuestsEditNetHandler.EDIT;
    }

    public void writeData(DataOut data) {
        data.writeInt(this.chapter);
        data.writeVarInt(this.x);
        data.writeVarInt(this.y);
        data.writeVarInt(QuestTaskType.getRegistry().getID((IForgeRegistryEntry)this.type));
        data.writeNBT(this.nbt);
    }

    public void readData(DataIn data) {
        this.chapter = data.readInt();
        this.x = data.readVarInt();
        this.y = data.readVarInt();
        this.type = (QuestTaskType)QuestTaskType.getRegistry().getValue(data.readVarInt());
        this.nbt = data.readNBT();
    }

    public void onMessage(EntityPlayerMP player) {
        QuestChapter c;
        if (FTBQuests.canEdit(player) && (c = ServerQuestFile.INSTANCE.getChapter(this.chapter)) != null) {
            Quest quest = new Quest(c);
            quest.x = (byte)this.x;
            quest.y = (byte)this.y;
            quest.id = ServerQuestFile.INSTANCE.readID(0);
            quest.onCreated();
            new MessageCreateObjectResponse(quest, null).sendToAll();
            QuestTask task = this.type.provider.create(quest);
            task.id = ServerQuestFile.INSTANCE.readID(0);
            task.readData(this.nbt);
            task.onCreated();
            NBTTagCompound extra = new NBTTagCompound();
            extra.func_74778_a("type", this.type.getTypeForNBT());
            new MessageCreateObjectResponse(task, extra).sendToAll();
            ServerQuestFile.INSTANCE.refreshIDMap();
            ServerQuestFile.INSTANCE.clearCachedData();
            ServerQuestFile.INSTANCE.save();
        }
    }
}

