/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.gamestages;

import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftbquests.integration.gamestages.GameStageReward;
import com.feed_the_beast.ftbquests.integration.gamestages.GameStageTask;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import java.util.Collections;
import java.util.UUID;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GameStagesIntegration {
    public static void preInit() {
        MinecraftForge.EVENT_BUS.register(GameStagesIntegration.class);
    }

    @SubscribeEvent
    public static void registerTasks(RegistryEvent.Register<QuestTaskType> event) {
        FTBQuestsTasks.GAMESTAGE = ((QuestTaskType)new QuestTaskType(GameStageTask::new).setRegistryName("gamestage")).setIcon(GuiIcons.CONTROLLER);
        event.getRegistry().register((IForgeRegistryEntry)FTBQuestsTasks.GAMESTAGE);
    }

    @SubscribeEvent
    public static void registerRewards(RegistryEvent.Register<QuestRewardType> event) {
        FTBQuestsRewards.GAMESTAGE = ((QuestRewardType)new QuestRewardType(GameStageReward::new).setRegistryName("gamestage")).setIcon(GuiIcons.CONTROLLER);
        event.getRegistry().register((IForgeRegistryEntry)FTBQuestsRewards.GAMESTAGE);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onGameStageAdded(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            GameStagesIntegration.checkStages((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onGameStageAdded(GameStageEvent.Added event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            GameStagesIntegration.checkStages((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public static void onGameStageRemoved(GameStageEvent.Removed event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            GameStagesIntegration.checkStages((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    private static void checkStages(EntityPlayerMP player) {
        ITeamData data;
        ITeamData iTeamData = data = ServerQuestFile.INSTANCE == null ? null : ServerQuestFile.INSTANCE.getData(FTBLibAPI.getTeam((UUID)player.func_110124_au()));
        if (data != null) {
            for (QuestChapter chapter : ServerQuestFile.INSTANCE.chapters) {
                for (Quest quest : chapter.quests) {
                    for (QuestTask task : quest.tasks) {
                        if (!(task instanceof GameStageTask)) continue;
                        data.getQuestTaskData(task).submitTask(player, Collections.emptyList(), false);
                    }
                }
            }
        }
    }
}

