/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.gamestages;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import java.util.Collection;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class GameStageTask
extends QuestTask {
    public String stage = "";

    public GameStageTask(Quest quest) {
        super(quest);
    }

    @Override
    public QuestTaskType getType() {
        return FTBQuestsTasks.GAMESTAGE;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("stage", this.stage);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.stage = nbt.func_74779_i("stage");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.stage);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.stage = data.readString();
    }

    @Override
    public void getConfig(EntityPlayer player, ConfigGroup config) {
        super.getConfig(player, config);
        config.addString("stage", () -> this.stage, v -> {
            this.stage = v;
        }, "").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.ftbquests.gamestage", new Object[0]));
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.task.ftbquests.gamestage", (Object[])new Object[0]) + ": " + TextFormatting.YELLOW + this.stage;
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<GameStageTask> {
        private Data(GameStageTask task, ITeamData data) {
            super(task, data);
        }

        @Override
        public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
            if (this.progress <= 0L && GameStageHelper.hasStage((EntityPlayer)player, (String)((GameStageTask)this.task).stage)) {
                if (!simulate) {
                    this.progress = 1L;
                    this.sync();
                }
                return true;
            }
            return false;
        }
    }
}

