/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.block;

import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftbquests.block.BlockWithHorizontalFacing;
import com.feed_the_beast.ftbquests.block.FTBQuestsBlocks;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.tile.ITaskScreen;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenCore;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenPart;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTaskScreen
extends BlockWithHorizontalFacing {
    public static boolean BREAKING_SCREEN = false;
    public static QuestTask currentTask = null;

    public static double getClickX(EnumFacing facing, int offX, int offY, double hitX, double hitZ, int size) {
        return 0.5;
    }

    public static double getClickY(int offY, double hitY, int size) {
        return 1.0 - ((double)offY + hitY) / ((double)size * 2.0 + 1.0);
    }

    public BlockTaskScreen() {
        super(Material.field_151573_f, MapColor.field_151646_E);
        this.func_149711_c(0.3f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return currentTask == null ? new TileTaskScreenCore() : currentTask.createScreenCore(world);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
        for (int i = 1; i <= 4; ++i) {
            ItemStack stack = new ItemStack((Block)this);
            stack.func_77983_a("Size", (NBTBase)new NBTTagByte((byte)i));
            items.add((Object)stack);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return FTBQuestsItems.SCREEN;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileTaskScreenCore screen;
        ItemStack stack = new ItemStack(FTBQuestsItems.SCREEN);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITaskScreen && (screen = ((ITaskScreen)tileEntity).getScreen()) != null) {
            screen.writeToPickBlock(stack);
        }
        return stack;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ITaskScreen base;
        TileTaskScreenCore screen;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITaskScreen && (screen = (base = (ITaskScreen)tileEntity).getScreen()) != null) {
            if (player.func_70093_af()) {
                if (player instanceof EntityPlayerMP) {
                    screen.onClicked((EntityPlayerMP)player, hand, 0.0, 0.0);
                }
                return true;
            }
            if (facing == state.func_177229_b((IProperty)field_185512_D)) {
                if (player instanceof EntityPlayerMP) {
                    screen.onClicked((EntityPlayerMP)player, hand, BlockTaskScreen.getClickX(facing, base.getOffsetX(), base.getOffsetZ(), hitX, hitZ, screen.size), BlockTaskScreen.getClickY(base.getOffsetY(), hitY, screen.size));
                }
                return true;
            }
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTaskScreenCore) {
            TileTaskScreenCore screen = (TileTaskScreenCore)tileEntity;
            screen.readFromItem(stack);
            screen.setIDFromPlacer(placer);
            screen.facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
            if (screen.size > 0) {
                int offZ;
                int offX;
                int x;
                int y;
                IBlockState state1 = FTBQuestsBlocks.SCREEN_PART.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)screen.getFacing());
                boolean xaxis = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == EnumFacing.Axis.X;
                for (y = 0; y < screen.size * 2 + 1; ++y) {
                    for (x = -screen.size; x <= screen.size; ++x) {
                        if (x == 0 && y == 0) continue;
                        offX = xaxis ? 0 : x;
                        offZ = xaxis ? x : 0;
                        world.func_175698_g(new BlockPos(pos.func_177958_n() + offX, pos.func_177956_o() + y, pos.func_177952_p() + offZ));
                    }
                }
                for (y = 0; y < screen.size * 2 + 1; ++y) {
                    for (x = -screen.size; x <= screen.size; ++x) {
                        if (x == 0 && y == 0) continue;
                        offX = xaxis ? 0 : x;
                        offZ = xaxis ? x : 0;
                        BlockPos pos1 = new BlockPos(pos.func_177958_n() + offX, pos.func_177956_o() + y, pos.func_177952_p() + offZ);
                        world.func_175656_a(pos1, state1);
                        TileEntity tileEntity1 = world.func_175625_s(pos1);
                        if (!(tileEntity1 instanceof TileTaskScreenPart)) continue;
                        ((TileTaskScreenPart)tileEntity1).setOffset(offX, y, offZ);
                    }
                }
            }
        }
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return null;
    }

    public int getHarvestLevel(IBlockState state) {
        return -1;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTaskScreenCore) {
            TileTaskScreenCore screen = (TileTaskScreenCore)tileEntity;
            if (screen.size > 0) {
                BREAKING_SCREEN = true;
                boolean xaxis = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == EnumFacing.Axis.X;
                for (int y = 0; y < screen.size * 2 + 1; ++y) {
                    for (int x = -screen.size; x <= screen.size; ++x) {
                        if (x == 0 && y == 0) continue;
                        int offX = xaxis ? 0 : x;
                        int offZ = xaxis ? x : 0;
                        BlockPos pos1 = new BlockPos(pos.func_177958_n() + offX, pos.func_177956_o() + y, pos.func_177952_p() + offZ);
                        IBlockState state1 = world.func_180495_p(pos1);
                        if (state1.func_177230_c() != FTBQuestsBlocks.SCREEN_PART) continue;
                        world.func_175698_g(pos1);
                    }
                }
                BREAKING_SCREEN = false;
            }
            if (!screen.indestructible) {
                ItemStack stack = new ItemStack((Block)this);
                screen.writeToPickBlock(stack);
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @Deprecated
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        TileTaskScreenCore screen;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITaskScreen && (screen = ((ITaskScreen)tileEntity).getScreen()) != null) {
            return BlockTaskScreen.getScreenAABB(screen.func_174877_v(), screen.getFacing(), screen.size);
        }
        return new AxisAlignedBB(0.0, -1.0, 0.0, 0.0, -1.0, 0.0);
    }

    public static AxisAlignedBB getScreenAABB(BlockPos pos, EnumFacing facing, int size) {
        boolean xaxis;
        if (size == 0) {
            return field_185505_j.func_186670_a(pos);
        }
        boolean bl = xaxis = facing.func_176740_k() == EnumFacing.Axis.X;
        if (xaxis) {
            return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - size), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + (double)size * 2.0 + 1.0, (double)(pos.func_177952_p() + size) + 1.0);
        }
        return new AxisAlignedBB((double)(pos.func_177958_n() - size), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + size) + 1.0, (double)pos.func_177956_o() + (double)size * 2.0 + 1.0, (double)pos.func_177952_p() + 1.0);
    }

    @Deprecated
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileTaskScreenCore core;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITaskScreen && (core = ((ITaskScreen)tileEntity).getScreen()) != null && core.indestructible) {
            return -1.0f;
        }
        return super.func_176195_g(state, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileTaskScreenCore core;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITaskScreen && (core = ((ITaskScreen)tileEntity).getScreen()) != null && core.indestructible) {
            return Float.MAX_VALUE;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileTaskScreenCore core;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITaskScreen && (core = ((ITaskScreen)tileEntity).getScreen()) != null && core.skin != BlockUtils.AIR_STATE) {
            return core.skin;
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        Quest quest;
        NBTTagCompound nbt = stack.func_77978_p();
        byte size = nbt == null ? (byte)0 : nbt.func_74771_c("Size");
        tooltip.add(I18n.func_135052_a((String)"tile.ftbquests.screen.size", (Object[])new Object[0]) + ": " + TextFormatting.GOLD + (1 + size * 2) + " x " + (1 + size * 2));
        if (!ClientQuestFile.exists()) {
            return;
        }
        Quest quest2 = quest = nbt == null ? null : ClientQuestFile.INSTANCE.getQuest(nbt.func_74762_e("Quest"));
        if (quest == null || quest.tasks.isEmpty()) {
            return;
        }
        tooltip.add(I18n.func_135052_a((String)"ftbquests.chapter", (Object[])new Object[0]) + ": " + quest.chapter.getYellowDisplayName());
        tooltip.add(I18n.func_135052_a((String)"ftbquests.quest", (Object[])new Object[0]) + ": " + quest.getYellowDisplayName());
        QuestTask task = quest.getTask(nbt.func_74771_c("TaskIndex") & 0xFF);
        tooltip.add(I18n.func_135052_a((String)"ftbquests.task", (Object[])new Object[0]) + ": " + task.getYellowDisplayName());
        if (ClientQuestFile.INSTANCE.self != null) {
            QuestTaskData taskData = ClientQuestFile.INSTANCE.self.getQuestTaskData(task);
            tooltip.add(I18n.func_135052_a((String)"ftbquests.progress", (Object[])new Object[0]) + ": " + TextFormatting.BLUE + String.format("%s / %s [%d%%]", taskData.getProgressString(), task.getMaxProgressString(), taskData.getRelativeProgress()));
        }
    }
}

