/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xt9.deepmoblearning.DeepMobLearning;
import xt9.deepmoblearning.common.items.ItemGlitchIngot;
import xt9.deepmoblearning.common.util.ItemStackNBTHelper;
import xt9.deepmoblearning.common.util.PlayerHelper;

public class ItemGlitchSword
extends ItemSword {
    private static final int DAMAGE_BONUS = 2;
    private static final int DAMAGE_BONUS_MAX = 18;
    private static final int DAMAGE_INCREASE_CHANCE = 6;
    private static Item.ToolMaterial material = EnumHelper.addToolMaterial((String)"GLITCH_INFUSED_MATERIAL", (int)3, (int)2200, (float)8.0f, (float)9.0f, (int)15);

    public ItemGlitchSword() {
        super(material);
        String itemName = "glitch_infused_sword";
        this.func_77655_b("deepmoblearning." + itemName);
        this.func_77637_a(DeepMobLearning.creativeTab);
        this.setRegistryName(itemName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.add("\u00a7rBonus: Quick learner\u00a7r");
        list.add("\u00a7r(Bonuses are disabled during Trials)\u00a7r");
        list.add("\u00a76The Data gained from the demise of a mob is doubled,\u00a7r");
        list.add("\u00a76when Data is gained there is also a small chance\u00a7r");
        list.add("\u00a76that the sword will get a permanent damage increase.\u00a7r");
        list.add("");
        list.add("Current damage increase: \u00a7b" + ItemGlitchSword.getPermanentWeaponDamage(stack) + " \u00a7r(Max " + 18 + ")\u00a7r");
    }

    public static void increaseDamage(ItemStack stack, EntityPlayerMP player) {
        if (ThreadLocalRandom.current().nextInt(1, 100) <= 6) {
            int current = ItemGlitchSword.getPermanentWeaponDamage(stack);
            ItemGlitchSword.setPermanentWeaponDamage(stack, current + 2 >= 18 ? 18 : current + 2);
            if (ItemGlitchSword.getPermanentWeaponDamage(stack) >= 18) {
                PlayerHelper.sendMessage(player, new TextComponentString("Your " + stack.func_82833_r() + " has now reached peak performance!"));
            } else {
                PlayerHelper.sendMessage(player, new TextComponentString("Your " + stack.func_82833_r() + " grows in power!"));
            }
        }
    }

    public static boolean canIncreaseDamage(ItemStack sword) {
        return ItemGlitchSword.getPermanentWeaponDamage(sword) < 18;
    }

    public static int getPermanentWeaponDamage(ItemStack stack) {
        return ItemStackNBTHelper.getInt(stack, "permDamage", 0);
    }

    public static void setPermanentWeaponDamage(ItemStack stack, int damage) {
        ItemStackNBTHelper.setInt(stack, "permDamage", damage);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() instanceof ItemGlitchIngot;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            modifiers.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)(material.func_78000_c() + (float)ItemGlitchSword.getPermanentWeaponDamage(stack)), 0));
            modifiers.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return modifiers;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }
}

