/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.capabilities;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xt9.deepmoblearning.DeepMobLearning;
import xt9.deepmoblearning.common.capabilities.IPlayerTrial;
import xt9.deepmoblearning.common.capabilities.PlayerTrialProvider;
import xt9.deepmoblearning.common.network.UpdatePlayerTrialCapabilityMessage;

@Mod.EventBusSubscriber
public class PlayerTrial
implements IPlayerTrial,
Capability.IStorage<IPlayerTrial> {
    private int currentWave = 0;
    private int lastWave = 0;
    private int mobsDefeated = 0;
    private int waveMobTotal = 0;
    private boolean isActive = false;
    private long tilePos;

    public static void init() {
        CapabilityManager.INSTANCE.register(IPlayerTrial.class, (Capability.IStorage)new PlayerTrial(), PlayerTrial::new);
    }

    public PlayerTrial() {
    }

    public PlayerTrial(int currentWave, int lastWave, int mobsDefeated, int waveMobTotal, long pos, boolean isActive) {
        this.currentWave = currentWave;
        this.lastWave = lastWave;
        this.mobsDefeated = mobsDefeated;
        this.waveMobTotal = waveMobTotal;
        this.tilePos = pos;
        this.isActive = isActive;
    }

    @Nullable
    public NBTTagCompound writeNBT(Capability<IPlayerTrial> capability, IPlayerTrial instance, EnumFacing enumFacing) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("currentWave", instance.getCurrentWave());
        compound.func_74768_a("lastWave", instance.getLastWave());
        compound.func_74768_a("mobsDefeated", instance.getDefated());
        compound.func_74768_a("waveMobTotal", instance.getWaveMobTotal());
        compound.func_74757_a("isActive", instance.isTrialActive());
        compound.func_74772_a("tilePos", instance.getTilePos());
        return compound;
    }

    public void readNBT(Capability<IPlayerTrial> capability, IPlayerTrial instance, EnumFacing enumFacing, NBTBase nbt) {
        instance.setCurrentWave(((NBTTagCompound)nbt).func_74762_e("currentWave"));
        instance.setLastWave(((NBTTagCompound)nbt).func_74762_e("lastWave"));
        instance.setDefeated(((NBTTagCompound)nbt).func_74762_e("mobsDefeated"));
        instance.setWaveMobTotal(((NBTTagCompound)nbt).func_74762_e("waveMobTotal"));
        instance.setIsActive(((NBTTagCompound)nbt).func_74767_n("isActive"));
        instance.setTilePos(((NBTTagCompound)nbt).func_74763_f("tilePos"));
    }

    @Override
    public void sync(EntityPlayerMP player) {
        DeepMobLearning.network.sendTo((IMessage)new UpdatePlayerTrialCapabilityMessage((PlayerTrial)player.getCapability(PlayerTrialProvider.PLAYER_TRIAL_CAP, null)), player);
    }

    @Override
    public void setCurrentWave(int wave) {
        this.currentWave = wave;
    }

    @Override
    public int getCurrentWave() {
        return this.currentWave;
    }

    @Override
    public void setLastWave(int wave) {
        this.lastWave = wave;
    }

    @Override
    public int getLastWave() {
        return this.lastWave;
    }

    @Override
    public void setDefeated(int count) {
        this.mobsDefeated = count;
    }

    @Override
    public int getDefated() {
        return this.mobsDefeated;
    }

    @Override
    public void setWaveMobTotal(int total) {
        this.waveMobTotal = total;
    }

    @Override
    public int getWaveMobTotal() {
        return this.waveMobTotal;
    }

    @Override
    public void setTilePos(long pos) {
        this.tilePos = pos;
    }

    @Override
    public long getTilePos() {
        return this.tilePos;
    }

    @Override
    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isTrialActive() {
        return this.isActive;
    }
}

