/*
 * Decompiled with CFR 0.152.
 */
package de.lellson.roughmobs2.misc;

import de.lellson.roughmobs2.RoughMobs;
import de.lellson.roughmobs2.config.RoughConfig;
import de.lellson.roughmobs2.misc.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeEnd;
import net.minecraft.world.biome.BiomeHell;
import net.minecraft.world.biome.BiomeVoid;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class SpawnHelper {
    public static final List<SpawnEntry> ENTRIES = new ArrayList<SpawnEntry>();

    public static void initSpawnOption() {
        RoughConfig.getConfig().addCustomCategoryComment("spawnEntries", "Add custom entity spawn entries or override old ones. Takes 5+ values seperated by a semicolon:\nFormat: entity;chance;min;max;type;biome1;biome2;...\nentity:\tEntity name\nchance:\tSpawn chance\nmin:\t\tMinimal group size. Must be greater than 0\nmax:\t\tMaximal group size\ntype:\t\tSpawn Type (AMBIENT = day and night, CREATURE = day only, MONSTER = night only and not in peaceful mode, WATER_CREATURE = only in water)\nbiomes:\tBiome name/id/type (Can be more than one). Put a \"!\" in front of the biome to revert this feature and disable entity spawning in the biome. Use OVERWORLD for all non nether/end biomes (Doesn't work with BoP hell biomes). Leave this blank for every biome!");
        String[] options = RoughConfig.getStringArray("spawnEntries", "List", Constants.DEFAULT_SPAWN_ENTRIES, "");
        SpawnHelper.fillEntries(options);
    }

    public static List<Biome> getOverworldBiomes() {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
            if (biome instanceof BiomeVoid || biome instanceof BiomeHell || biome instanceof BiomeEnd || biomes.contains(biome)) continue;
            biomes.add(biome);
        }
        return biomes;
    }

    private static void fillEntries(String[] options) {
        for (String option : options) {
            String[] parts = option.split(";");
            if (parts.length >= 5) {
                String[] biomes = new String[parts.length - 5];
                for (int i = 0; i < biomes.length; ++i) {
                    biomes[i] = parts[5 + i];
                }
                SpawnEntry entry = new SpawnEntry(parts[0], parts[1], parts[2], parts[3], parts[4], biomes);
                if (entry.isValid()) {
                    ENTRIES.add(entry);
                    continue;
                }
                RoughMobs.logError("Spawn Entries: " + entry.getError(), new Object[0]);
                continue;
            }
            RoughMobs.logError("Spawn Entries: Entry \"" + option + "\" needs at least 5 values!", new Object[0]);
        }
    }

    public static void addEntries() {
        for (SpawnEntry entry : ENTRIES) {
            EntityRegistry.addSpawn(entry.entityClass, (int)entry.prob, (int)entry.min, (int)entry.max, (EnumCreatureType)entry.type, (Biome[])((Biome[])entry.biomes.func_76341_a()));
            if (((Biome[])entry.biomes.func_76340_b()).length != 0) {
                for (Biome b : (Biome[])entry.biomes.func_76340_b()) {
                    System.out.println(b.func_185359_l());
                }
            }
            EntityRegistry.removeSpawn(entry.entityClass, (EnumCreatureType)entry.type, (Biome[])((Biome[])entry.biomes.func_76340_b()));
        }
    }

    public static class SpawnEntry {
        public static final Map<String, BiomeDictionary.Type> TYPE_MAP = (Map)ReflectionHelper.getPrivateValue(BiomeDictionary.Type.class, null, (int)0);
        public static final String OW_TYPE = "OVERWORLD";
        public static final String DISABLE_KEY = "!";
        private boolean valid = true;
        private String error = "";
        public Class<? extends EntityLiving> entityClass;
        public int prob;
        public int min;
        public int max;
        public EnumCreatureType type;
        public Tuple<Biome[], Biome[]> biomes;

        public SpawnEntry(String entityName, String prob, String min, String max, String type, String ... biomes) {
            this.entityClass = this.getEntityClass(entityName);
            this.prob = this.getInteger(prob);
            this.min = this.getInteger(min);
            this.max = this.getInteger(max);
            this.type = this.getType(type);
            this.biomes = this.getBiomes(biomes);
        }

        private Tuple<Biome[], Biome[]> getBiomes(String[] biomes) {
            ArrayList<Biome> listAdd = new ArrayList<Biome>();
            ArrayList<Biome> listRemove = new ArrayList<Biome>();
            for (String biomeId : biomes) {
                ArrayList<Biome> list;
                ArrayList<Biome> arrayList = list = biomeId.startsWith(DISABLE_KEY) ? listRemove : listAdd;
                if (biomeId.startsWith(DISABLE_KEY)) {
                    biomeId = biomeId.substring(1);
                }
                BiomeDictionary.Type type = TYPE_MAP.get(biomeId);
                if (biomeId.equals(OW_TYPE)) {
                    for (Biome biome : SpawnHelper.getOverworldBiomes()) {
                        list.add(biome);
                    }
                    continue;
                }
                if (type != null) {
                    list.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
                    continue;
                }
                Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeId));
                if (biome != null) {
                    list.add(biome);
                    continue;
                }
                int id = this.getInteger(biomeId);
                if (id < 0) continue;
                biome = Biome.func_185357_a((int)id);
                if (biome != null) {
                    list.add(biome);
                    continue;
                }
                this.valid = false;
                this.error = "Biomes with the id/name " + id + " don't exist!";
            }
            if (biomes.length == 0) {
                for (Biome biome : Biome.field_185377_q) {
                    listAdd.add(biome);
                }
            }
            Biome[] resultToAdd = new Biome[listAdd.size()];
            Biome[] resultToRemove = new Biome[listRemove.size()];
            return new Tuple((Object)listAdd.toArray(resultToAdd), (Object)listRemove.toArray(resultToRemove));
        }

        private EnumCreatureType getType(String type) {
            switch (type.toUpperCase()) {
                case "AMBIENT": {
                    return EnumCreatureType.AMBIENT;
                }
                case "CREATURE": {
                    return EnumCreatureType.CREATURE;
                }
                case "MONSTER": {
                    return EnumCreatureType.MONSTER;
                }
                case "WATER_CREATURE": {
                    return EnumCreatureType.WATER_CREATURE;
                }
            }
            this.valid = false;
            this.error = "Creature type " + type + " doesn't exist!";
            return null;
        }

        private int getInteger(String str) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                this.valid = false;
                this.error = this.prob + " is not a valid number!";
                return -1;
            }
        }

        private Class<? extends EntityLiving> getEntityClass(String entityName) {
            Class clazz = EntityList.getClass((ResourceLocation)new ResourceLocation(entityName));
            if (clazz != null) {
                try {
                    return clazz;
                }
                catch (Exception e) {
                    this.valid = false;
                    this.error = entityName + " is not a valid living entity!";
                }
            } else {
                this.valid = false;
                this.error = entityName + " is not a valid entity!";
            }
            return null;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getError() {
            return this.error;
        }
    }
}

