/*
 * Decompiled with CFR 0.152.
 */
package de.lellson.roughmobs2;

import de.lellson.roughmobs2.config.RoughConfig;
import de.lellson.roughmobs2.features.BlazeFeatures;
import de.lellson.roughmobs2.features.CreeperFeatures;
import de.lellson.roughmobs2.features.EndermanFeatures;
import de.lellson.roughmobs2.features.EndermiteFeatures;
import de.lellson.roughmobs2.features.EntityFeatures;
import de.lellson.roughmobs2.features.GhastFeatures;
import de.lellson.roughmobs2.features.GuardianFeatures;
import de.lellson.roughmobs2.features.HostileHorseFeatures;
import de.lellson.roughmobs2.features.MagmaCubeFeatures;
import de.lellson.roughmobs2.features.SilverfishFeatures;
import de.lellson.roughmobs2.features.SkeletonFeatures;
import de.lellson.roughmobs2.features.SlimeFeatures;
import de.lellson.roughmobs2.features.SpiderFeatures;
import de.lellson.roughmobs2.features.WitchFeatures;
import de.lellson.roughmobs2.features.WitherFeatures;
import de.lellson.roughmobs2.features.ZombieFeatures;
import de.lellson.roughmobs2.features.ZombiePigmanFeatures;
import de.lellson.roughmobs2.misc.AttributeHelper;
import de.lellson.roughmobs2.misc.Constants;
import de.lellson.roughmobs2.misc.SpawnHelper;
import de.lellson.roughmobs2.misc.TargetHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RoughApplier {
    public static final String FEATURES_APPLIED = Constants.unique("featuresApplied");
    public static final List<EntityFeatures> FEATURES = new ArrayList<EntityFeatures>();

    public RoughApplier() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FEATURES.add(new ZombieFeatures());
        FEATURES.add(new SkeletonFeatures());
        FEATURES.add(new HostileHorseFeatures());
        FEATURES.add(new CreeperFeatures());
        FEATURES.add(new SlimeFeatures());
        FEATURES.add(new EndermanFeatures());
        FEATURES.add(new SpiderFeatures());
        FEATURES.add(new WitchFeatures().addPotionHandler(FEATURES));
        FEATURES.add(new SilverfishFeatures());
        FEATURES.add(new ZombiePigmanFeatures());
        FEATURES.add(new BlazeFeatures());
        FEATURES.add(new GhastFeatures());
        FEATURES.add(new MagmaCubeFeatures());
        FEATURES.add(new WitherFeatures());
        FEATURES.add(new EndermiteFeatures());
        FEATURES.add(new GuardianFeatures());
    }

    public void preInit() {
        for (EntityFeatures features : FEATURES) {
            features.preInit();
        }
        RoughConfig.loadFeatures();
    }

    public void postInit() {
        for (EntityFeatures features : FEATURES) {
            features.postInit();
        }
        AttributeHelper.initAttributeOption();
        SpawnHelper.initSpawnOption();
        SpawnHelper.addEntries();
        TargetHelper.init();
        RoughConfig.saveFeatures();
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityLiving) {
            AttributeHelper.addAttributes((EntityLivingBase)((EntityLiving)entity));
        }
        for (EntityFeatures features : FEATURES) {
            if (!features.isEntity(entity)) continue;
            if (!entity.getEntityData().func_74767_n(FEATURES_APPLIED)) {
                features.addFeatures(event, entity);
            }
            if (!(entity instanceof EntityLiving)) continue;
            features.addAI(event, entity, ((EntityLiving)entity).field_70714_bg, ((EntityLiving)entity).field_70715_bh);
        }
        entity.getEntityData().func_74757_a(FEATURES_APPLIED, true);
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        Entity immediateSource = event.getSource().func_76364_f();
        Entity target = event.getEntity();
        if (trueSource == null || target == null || target instanceof FakePlayer || trueSource instanceof FakePlayer || immediateSource instanceof FakePlayer || target.field_70170_p.field_72995_K) {
            return;
        }
        boolean finish = false;
        for (EntityFeatures features : FEATURES) {
            if (trueSource instanceof EntityLiving && features.isEntity((Entity)((EntityLiving)trueSource)) && (!(target instanceof EntityPlayer) || !((EntityPlayer)target).func_184812_l_())) {
                features.onAttack((Entity)((EntityLiving)trueSource), immediateSource, target, event);
                finish = true;
            }
            if (!(target instanceof EntityLiving) || !features.isEntity((Entity)((EntityLiving)target)) || trueSource instanceof EntityPlayer && ((EntityPlayer)trueSource).func_184812_l_()) continue;
            features.onDefend((Entity)((EntityLiving)target), trueSource, immediateSource, event);
            finish = true;
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        Entity deadEntity = event.getEntity();
        if (deadEntity == null || deadEntity.field_70170_p.field_72995_K || !(deadEntity instanceof EntityLiving)) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            if (!features.isEntity((Entity)((EntityLiving)deadEntity))) continue;
            features.onDeath((Entity)((EntityLiving)deadEntity), event.getSource());
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || entity.field_70170_p.field_72995_K || !(entity instanceof EntityLiving)) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            if (!features.isEntity((Entity)((EntityLiving)entity))) continue;
            features.onFall((Entity)((EntityLiving)entity), event);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player == null || player.field_70170_p.field_72995_K || player.func_184812_l_()) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            features.onBlockBreak(player, event);
        }
    }

    @SubscribeEvent
    public void onTarget(LivingSetAttackTargetEvent event) {
        if (!(TargetHelper.targetBlockerEnabled() && event.getTarget() != null && event.getTarget() instanceof EntityMob && event.getEntityLiving() instanceof EntityMob)) {
            return;
        }
        Class<? extends Entity> validAttacker = TargetHelper.getBlockerEntityForTarget((Entity)event.getTarget());
        if (validAttacker != null && validAttacker.isInstance(event.getEntityLiving())) {
            EntityPlayer player = event.getEntityLiving().func_130014_f_().func_184142_a((Entity)event.getEntityLiving(), 32.0, 32.0);
            if (player != null && player.func_184191_r((Entity)event.getEntityLiving())) {
                return;
            }
            event.getEntityLiving().func_70604_c((EntityLivingBase)player);
            ((EntityLiving)event.getEntityLiving()).func_70624_b((EntityLivingBase)player);
        }
    }
}

